/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.message.DbException;
import org.h2.mvstore.db.MVTempResult;
import org.h2.result.ResultExternal;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.result.Row;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.Utils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueLob;
import org.h2.value.ValueRow;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class LocalResult
implements ResultInterface,
ResultTarget {
    private int maxMemoryRows;
    private final SessionLocal session;
    private int visibleColumnCount;
    private int resultColumnCount;
    private Expression[] expressions;
    private boolean forDataChangeDeltaTable;
    private long rowId;
    private long rowCount;
    private ArrayList<Value[]> rows;
    private SortOrder sort;
    private TreeMap<ValueRow, Value[]> distinctRows;
    private Value[] currentRow;
    private long offset;
    private long limit = -1L;
    private boolean fetchPercent;
    private SortOrder withTiesSortOrder;
    private boolean limitsWereApplied;
    private ResultExternal external;
    private boolean distinct;
    private int[] distinctIndexes;
    private boolean closed;
    private boolean containsLobs;
    private Boolean containsNull;

    public static LocalResult forTable(SessionLocal session, Table table) {
        Column[] columns = table.getColumns();
        int degree = columns.length;
        Expression[] expressions = new Expression[degree + 1];
        Database database = session.getDatabase();
        int i = 0;
        while (i < degree) {
            expressions[i] = new ExpressionColumn(database, columns[i]);
            ++i;
        }
        Column rowIdColumn = table.getRowIdColumn();
        expressions[degree] = rowIdColumn != null ? new ExpressionColumn(database, rowIdColumn) : new ExpressionColumn(database, null, table.getName());
        return new LocalResult(session, expressions, degree, degree + 1);
    }

    public LocalResult() {
        this(null);
    }

    private LocalResult(SessionLocal session) {
        this.session = session;
    }

    public LocalResult(SessionLocal session, Expression[] expressions, int visibleColumnCount, int resultColumnCount) {
        Database db;
        this.session = session;
        this.maxMemoryRows = session == null ? Integer.MAX_VALUE : ((db = session.getDatabase()).isPersistent() && !db.isReadOnly() ? session.getDatabase().getMaxMemoryRows() : Integer.MAX_VALUE);
        this.rows = Utils.newSmallArrayList();
        this.visibleColumnCount = visibleColumnCount;
        this.resultColumnCount = resultColumnCount;
        this.rowId = -1L;
        this.expressions = expressions;
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    public void setMaxMemoryRows(int maxValue) {
        this.maxMemoryRows = maxValue;
    }

    public void setForDataChangeDeltaTable() {
        this.forDataChangeDeltaTable = true;
    }

    @Override
    public LocalResult createShallowCopy(Session targetSession) {
        if (this.external == null && (this.rows == null || (long)this.rows.size() < this.rowCount)) {
            return null;
        }
        if (this.containsLobs) {
            return null;
        }
        ResultExternal e2 = null;
        if (this.external != null && (e2 = this.external.createShallowCopy()) == null) {
            return null;
        }
        LocalResult copy = new LocalResult((SessionLocal)targetSession);
        copy.maxMemoryRows = this.maxMemoryRows;
        copy.visibleColumnCount = this.visibleColumnCount;
        copy.resultColumnCount = this.resultColumnCount;
        copy.expressions = this.expressions;
        copy.rowId = -1L;
        copy.rowCount = this.rowCount;
        copy.rows = this.rows;
        copy.sort = this.sort;
        copy.distinctRows = this.distinctRows;
        copy.distinct = this.distinct;
        copy.distinctIndexes = this.distinctIndexes;
        copy.currentRow = null;
        copy.offset = 0L;
        copy.limit = -1L;
        copy.external = e2;
        copy.containsNull = this.containsNull;
        return copy;
    }

    public void setSortOrder(SortOrder sort) {
        this.sort = sort;
    }

    public void setDistinct() {
        assert (this.distinctIndexes == null);
        this.distinct = true;
        this.distinctRows = new TreeMap(this.session.getDatabase().getCompareMode());
    }

    public void setDistinct(int[] distinctIndexes) {
        assert (!this.distinct);
        this.distinctIndexes = distinctIndexes;
        this.distinctRows = new TreeMap(this.session.getDatabase().getCompareMode());
    }

    private boolean isAnyDistinct() {
        return this.distinct || this.distinctIndexes != null;
    }

    public boolean containsDistinct(Value[] values) {
        ValueRow array;
        assert (values.length == this.visibleColumnCount);
        if (this.external != null) {
            return this.external.contains(values);
        }
        if (this.distinctRows == null) {
            this.distinctRows = new TreeMap(this.session.getDatabase().getCompareMode());
            for (Value[] row : this.rows) {
                ValueRow array2 = this.getDistinctRow(row);
                this.distinctRows.put(array2, array2.getList());
            }
        }
        return this.distinctRows.get(array = ValueRow.get(values)) != null;
    }

    public boolean containsNull() {
        Boolean r = this.containsNull;
        if (r == null) {
            r = false;
            this.reset();
            block0: while (this.next()) {
                Value[] row = this.currentRow;
                int i = 0;
                while (i < this.visibleColumnCount) {
                    if (row[i].containsNull()) {
                        r = true;
                        break block0;
                    }
                    ++i;
                }
            }
            this.reset();
            this.containsNull = r;
        }
        return r;
    }

    public void removeDistinct(Value[] values) {
        if (!this.distinct) {
            throw DbException.getInternalError();
        }
        assert (values.length == this.visibleColumnCount);
        if (this.distinctRows != null) {
            this.distinctRows.remove(ValueRow.get(values));
            this.rowCount = this.distinctRows.size();
        } else {
            this.rowCount = this.external.removeRow(values);
        }
    }

    @Override
    public void reset() {
        this.rowId = -1L;
        this.currentRow = null;
        if (this.external != null) {
            this.external.reset();
        }
    }

    public Row currentRowForTable() {
        int degree = this.visibleColumnCount;
        Value[] currentRow = this.currentRow;
        Row row = this.session.getDatabase().getRowFactory().createRow(Arrays.copyOf(currentRow, degree), -1);
        row.setKey(currentRow[degree].getLong());
        return row;
    }

    @Override
    public Value[] currentRow() {
        return this.currentRow;
    }

    @Override
    public boolean next() {
        if (!this.closed && this.rowId < this.rowCount) {
            ++this.rowId;
            if (this.rowId < this.rowCount) {
                this.currentRow = this.external != null ? this.external.next() : this.rows.get((int)this.rowId);
                return true;
            }
            this.currentRow = null;
        }
        return false;
    }

    @Override
    public long getRowId() {
        return this.rowId;
    }

    @Override
    public boolean isAfterLast() {
        return this.rowId >= this.rowCount;
    }

    private void cloneLobs(Value[] values) {
        int i = 0;
        while (i < values.length) {
            Value v = values[i];
            if (v instanceof ValueLob) {
                if (this.forDataChangeDeltaTable) {
                    this.containsLobs = true;
                } else {
                    ValueLob v2 = ((ValueLob)v).copyToResult();
                    if (v2 != v) {
                        this.containsLobs = true;
                        values[i] = this.session.addTemporaryLob(v2);
                    }
                }
            }
            ++i;
        }
    }

    private ValueRow getDistinctRow(Value[] values) {
        if (this.distinctIndexes != null) {
            int cnt = this.distinctIndexes.length;
            Value[] newValues = new Value[cnt];
            int i = 0;
            while (i < cnt) {
                newValues[i] = values[this.distinctIndexes[i]];
                ++i;
            }
            values = newValues;
        } else if (values.length > this.visibleColumnCount) {
            values = Arrays.copyOf(values, this.visibleColumnCount);
        }
        return ValueRow.get(values);
    }

    private void createExternalResult() {
        this.external = MVTempResult.of(this.session.getDatabase(), this.expressions, this.distinct, this.distinctIndexes, this.visibleColumnCount, this.resultColumnCount, this.sort);
    }

    public void addRowForTable(Row row) {
        int degree = this.visibleColumnCount;
        Value[] values = new Value[degree + 1];
        int i = 0;
        while (i < degree) {
            values[i] = row.getValue(i);
            ++i;
        }
        values[degree] = ValueBigint.get(row.getKey());
        this.addRowInternal(values);
    }

    @Override
    public void addRow(Value ... values) {
        assert (values.length == this.resultColumnCount);
        this.cloneLobs(values);
        this.addRowInternal(values);
    }

    private void addRowInternal(Value ... values) {
        if (this.isAnyDistinct()) {
            if (this.distinctRows != null) {
                ValueRow distinctRow = this.getDistinctRow(values);
                Value[] previous = this.distinctRows.get(distinctRow);
                if (previous == null || this.sort != null && this.sort.compare(previous, values) > 0) {
                    this.distinctRows.put(distinctRow, values);
                }
                this.rowCount = this.distinctRows.size();
                if (this.rowCount > (long)this.maxMemoryRows) {
                    this.createExternalResult();
                    this.rowCount = this.external.addRows(this.distinctRows.values());
                    this.distinctRows = null;
                }
            } else {
                this.rowCount = this.external.addRow(values);
            }
        } else {
            this.rows.add(values);
            ++this.rowCount;
            if (this.rows.size() > this.maxMemoryRows) {
                this.addRowsToDisk();
            }
        }
    }

    private void addRowsToDisk() {
        if (this.external == null) {
            this.createExternalResult();
        }
        this.rowCount = this.external.addRows(this.rows);
        this.rows.clear();
    }

    @Override
    public int getVisibleColumnCount() {
        return this.visibleColumnCount;
    }

    public void done() {
        if (this.external != null) {
            this.addRowsToDisk();
        } else {
            if (this.isAnyDistinct()) {
                this.rows = new ArrayList<Value[]>(this.distinctRows.values());
            }
            if (this.sort != null && this.limit != 0L && !this.limitsWereApplied) {
                boolean withLimit;
                boolean bl = withLimit = this.limit > 0L && this.withTiesSortOrder == null;
                if (this.offset > 0L || withLimit) {
                    int endExclusive = this.rows.size();
                    if (this.offset < (long)endExclusive) {
                        int fromInclusive = (int)this.offset;
                        if (withLimit && this.limit < (long)(endExclusive - fromInclusive)) {
                            endExclusive = fromInclusive + (int)this.limit;
                        }
                        this.sort.sort(this.rows, fromInclusive, endExclusive);
                    }
                } else {
                    this.sort.sort(this.rows);
                }
            }
        }
        this.applyOffsetAndLimit();
        this.reset();
    }

    private void applyOffsetAndLimit() {
        boolean clearAll;
        if (this.limitsWereApplied) {
            return;
        }
        long offset = Math.max(this.offset, 0L);
        long limit = this.limit;
        if (offset == 0L && limit < 0L && !this.fetchPercent || this.rowCount == 0L) {
            return;
        }
        if (this.fetchPercent) {
            if (limit < 0L || limit > 100L) {
                throw DbException.getInvalidValueException("FETCH PERCENT", limit);
            }
            limit = (limit * this.rowCount + 99L) / 100L;
        }
        boolean bl = clearAll = offset >= this.rowCount || limit == 0L;
        if (!clearAll) {
            long remaining = this.rowCount - offset;
            long l = limit = limit < 0L ? remaining : Math.min(remaining, limit);
            if (offset == 0L && remaining <= limit) {
                return;
            }
        } else {
            limit = 0L;
        }
        this.distinctRows = null;
        this.rowCount = limit;
        if (this.external == null) {
            if (clearAll) {
                this.rows.clear();
                return;
            }
            int to = (int)(offset + limit);
            if (this.withTiesSortOrder != null) {
                Value[] expected = this.rows.get(to - 1);
                while (to < this.rows.size() && this.withTiesSortOrder.compare(expected, this.rows.get(to)) == 0) {
                    ++to;
                    ++this.rowCount;
                }
            }
            if (offset != 0L || to != this.rows.size()) {
                this.rows = new ArrayList<Value[]>(this.rows.subList((int)offset, to));
            }
        } else {
            if (clearAll) {
                this.external.close();
                this.external = null;
                return;
            }
            this.trimExternal(offset, limit);
        }
    }

    private void trimExternal(long offset, long limit) {
        ResultExternal temp = this.external;
        this.external = null;
        temp.reset();
        while (--offset >= 0L) {
            temp.next();
        }
        Value[] row = null;
        while (--limit >= 0L) {
            row = temp.next();
            this.rows.add(row);
            if (this.rows.size() <= this.maxMemoryRows) continue;
            this.addRowsToDisk();
        }
        if (this.withTiesSortOrder != null && row != null) {
            Value[] expected = row;
            while ((row = temp.next()) != null && this.withTiesSortOrder.compare(expected, row) == 0) {
                this.rows.add(row);
                ++this.rowCount;
                if (this.rows.size() <= this.maxMemoryRows) continue;
                this.addRowsToDisk();
            }
        }
        if (this.external != null) {
            this.addRowsToDisk();
        }
        temp.close();
    }

    @Override
    public long getRowCount() {
        return this.rowCount;
    }

    @Override
    public void limitsWereApplied() {
        this.limitsWereApplied = true;
    }

    @Override
    public boolean hasNext() {
        return !this.closed && this.rowId < this.rowCount - 1L;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public void setFetchPercent(boolean fetchPercent) {
        this.fetchPercent = fetchPercent;
    }

    public void setWithTies(SortOrder withTiesSortOrder) {
        assert (this.sort == null || this.sort == withTiesSortOrder);
        this.withTiesSortOrder = withTiesSortOrder;
    }

    @Override
    public boolean needToClose() {
        return this.external != null;
    }

    @Override
    public void close() {
        if (this.external != null) {
            this.external.close();
            this.external = null;
            this.closed = true;
        }
    }

    @Override
    public String getAlias(int i) {
        return this.expressions[i].getAlias(this.session, i);
    }

    @Override
    public String getTableName(int i) {
        return this.expressions[i].getTableName();
    }

    @Override
    public String getSchemaName(int i) {
        return this.expressions[i].getSchemaName();
    }

    @Override
    public String getColumnName(int i) {
        return this.expressions[i].getColumnName(this.session, i);
    }

    @Override
    public TypeInfo getColumnType(int i) {
        return this.expressions[i].getType();
    }

    @Override
    public int getNullable(int i) {
        return this.expressions[i].getNullable();
    }

    @Override
    public boolean isIdentity(int i) {
        return this.expressions[i].isIdentity();
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public String toString() {
        return super.toString() + " columns: " + this.visibleColumnCount + " rows: " + this.rowCount + " pos: " + this.rowId;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public int getFetchSize() {
        return 0;
    }

    @Override
    public void setFetchSize(int fetchSize) {
    }
}

