/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.h2.result.ResultInterface;
import org.h2.result.SimpleResult;
import org.h2.util.Utils;
import org.h2.value.Value;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class MergedResult {
    private final ArrayList<Map<SimpleResult.Column, Value>> data = Utils.newSmallArrayList();
    private final ArrayList<SimpleResult.Column> columns = Utils.newSmallArrayList();

    public void add(ResultInterface result) {
        int count = result.getVisibleColumnCount();
        if (count == 0) {
            return;
        }
        SimpleResult.Column[] cols = new SimpleResult.Column[count];
        int i = 0;
        while (i < count) {
            SimpleResult.Column c;
            cols[i] = c = new SimpleResult.Column(result.getAlias(i), result.getColumnName(i), result.getColumnType(i));
            if (!this.columns.contains(c)) {
                this.columns.add(c);
            }
            ++i;
        }
        while (result.next()) {
            if (count == 1) {
                this.data.add(Collections.singletonMap(cols[0], result.currentRow()[0]));
                continue;
            }
            HashMap<SimpleResult.Column, Value> map = new HashMap<SimpleResult.Column, Value>();
            int i2 = 0;
            while (i2 < count) {
                SimpleResult.Column ci = cols[i2];
                map.put(ci, result.currentRow()[i2]);
                ++i2;
            }
            this.data.add(map);
        }
    }

    public SimpleResult getResult() {
        SimpleResult result = new SimpleResult();
        for (SimpleResult.Column column : this.columns) {
            result.addColumn(column);
        }
        for (Map map : this.data) {
            Value[] row = new Value[this.columns.size()];
            for (Map.Entry entry : map.entrySet()) {
                row[this.columns.indexOf(entry.getKey())] = (Value)entry.getValue();
            }
            result.addRow(row);
        }
        return result;
    }

    public String toString() {
        return String.valueOf(this.columns) + ": " + this.data.size();
    }
}

