/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.io.IOException;
import org.h2.result.ResultInterface;
import org.h2.value.Transfer;
import org.h2.value.TypeInfo;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ResultColumn {
    final String alias;
    final String schemaName;
    final String tableName;
    final String columnName;
    final TypeInfo columnType;
    final boolean identity;
    final int nullable;

    ResultColumn(Transfer in) throws IOException {
        this.alias = in.readString();
        this.schemaName = in.readString();
        this.tableName = in.readString();
        this.columnName = in.readString();
        this.columnType = in.readTypeInfo();
        if (in.getVersion() < 20) {
            in.readInt();
        }
        this.identity = in.readBoolean();
        this.nullable = in.readInt();
    }

    public static void writeColumn(Transfer out, ResultInterface result, int i) throws IOException {
        out.writeString(result.getAlias(i));
        out.writeString(result.getSchemaName(i));
        out.writeString(result.getTableName(i));
        out.writeString(result.getColumnName(i));
        TypeInfo type = result.getColumnType(i);
        out.writeTypeInfo(type);
        if (out.getVersion() < 20) {
            out.writeInt(type.getDisplaySize());
        }
        out.writeBoolean(result.isIdentity(i));
        out.writeInt(result.getNullable(i));
    }
}

