/*
 * Decompiled with CFR 0.152.
 */
package org.h2.samples;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import org.h2.tools.RunScript;
import org.h2.util.StringUtils;

public class Newsfeed {
    public static void main(String ... args) throws Exception {
        Path targetDir = Paths.get(args.length == 0 ? "." : args[0], new String[0]);
        Class.forName("org.h2.Driver");
        Connection conn = DriverManager.getConnection("jdbc:h2:mem:", "sa", "");
        InputStream in = Newsfeed.class.getResourceAsStream("newsfeed.sql");
        ResultSet rs = RunScript.execute(conn, new InputStreamReader(in, StandardCharsets.ISO_8859_1));
        in.close();
        while (rs.next()) {
            String file = rs.getString("FILE");
            String content = rs.getString("CONTENT");
            if (file.endsWith(".txt")) {
                content = Newsfeed.convertHtml2Text(content);
            }
            Files.createDirectories(targetDir, new FileAttribute[0]);
            Files.write(targetDir.resolve(file), content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        conn.close();
    }

    private static String convertHtml2Text(String html) {
        String s = html;
        s = StringUtils.replaceAll(s, "<b>", "");
        s = StringUtils.replaceAll(s, "</b>", "");
        s = StringUtils.replaceAll(s, "<ul>", "");
        s = StringUtils.replaceAll(s, "</ul>", "");
        s = StringUtils.replaceAll(s, "<li>", "- ");
        s = StringUtils.replaceAll(s, "</li>", "");
        s = StringUtils.replaceAll(s, "<a href=\"", "( ");
        s = StringUtils.replaceAll(s, "\">", " ) ");
        s = StringUtils.replaceAll(s, "</a>", "");
        s = StringUtils.replaceAll(s, "<br />", "");
        s = StringUtils.replaceAll(s, "<br/>", "");
        if ((s = StringUtils.replaceAll(s, "<br>", "")).indexOf(60) >= 0 || s.indexOf(62) >= 0) {
            throw new RuntimeException("Unsupported HTML Tag: < or > in " + s);
        }
        return s;
    }
}

