/*
 * Decompiled with CFR 0.152.
 */
package org.h2.samples;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import org.h2.api.DatabaseEventListener;
import org.h2.engine.SessionLocal;
import org.h2.jdbc.JdbcConnection;

public class ShowProgress
implements DatabaseEventListener {
    private final long startNs;
    private long lastNs;

    public ShowProgress() {
        this.startNs = this.lastNs = System.nanoTime();
    }

    public static void main(String ... args) throws Exception {
        new ShowProgress().test();
    }

    void test() throws Exception {
        Class.forName("org.h2.Driver");
        Connection conn = DriverManager.getConnection("jdbc:h2:./test", "sa", "");
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?, 'Test' || SPACE(100))");
        long time = System.nanoTime();
        int len = 1000;
        int i = 0;
        while (i < len) {
            long now = System.nanoTime();
            if (now > time + TimeUnit.SECONDS.toNanos(1L)) {
                time = now;
                System.out.println("Inserting " + 100L * (long)i / (long)len + "%");
            }
            prep.setInt(1, i);
            prep.execute();
            ++i;
        }
        boolean abnormalTermination = true;
        if (abnormalTermination) {
            ((SessionLocal)((JdbcConnection)conn).getSession()).getDatabase().setPowerOffCount(1);
            try {
                stat.execute("INSERT INTO TEST VALUES(-1, 'Test' || SPACE(100))");
            }
            catch (SQLException sQLException) {}
        } else {
            conn.close();
        }
        System.out.println("Open connection...");
        time = System.nanoTime();
        conn = DriverManager.getConnection("jdbc:h2:./test;DATABASE_EVENT_LISTENER='" + this.getClass().getName() + "'", "sa", "");
        time = System.nanoTime() - time;
        System.out.println("Done after " + TimeUnit.NANOSECONDS.toMillis(time) + " ms");
        prep.close();
        stat.close();
        conn.close();
    }

    @Override
    public void exceptionThrown(SQLException e, String sql) {
        System.out.println("Error executing " + sql);
        e.printStackTrace();
    }

    @Override
    public void setProgress(int state, String name, long current, long max) {
        long time = System.nanoTime();
        if (time < this.lastNs + TimeUnit.SECONDS.toNanos(5L)) {
            return;
        }
        this.lastNs = time;
        Object stateName = "?";
        switch (state) {
            case 0: {
                stateName = "Scan " + name;
                break;
            }
            case 1: {
                stateName = "Create Index " + name;
                break;
            }
            case 2: {
                stateName = "Recover";
                break;
            }
            default: {
                return;
            }
        }
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("State: " + (String)stateName + " " + 100L * current / max + "% (" + current + " of " + max + ") " + TimeUnit.NANOSECONDS.toMillis(time - this.startNs) + " ms");
    }

    @Override
    public void closingDatabase() {
        System.out.println("Closing the database");
    }

    @Override
    public void init(String url) {
        System.out.println("Initializing the event listener for database " + url);
    }

    @Override
    public void opened() {
    }
}

