/*
 * Decompiled with CFR 0.152.
 */
package org.h2.samples;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.tools.TriggerAdapter;

public class UpdatableView
extends TriggerAdapter {
    private PreparedStatement prepDelete;
    private PreparedStatement prepInsert;

    public static void main(String ... args) throws Exception {
        Class.forName("org.h2.Driver");
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection conn = DriverManager.getConnection("jdbc:h2:mem:");){
            ResultSet rs;
            Statement stat = conn.createStatement();
            stat.execute("CREATE TABLE TEST_TABLE(ID BIGINT GENERATED BY DEFAULT AS IDENTITY DEFAULT ON NULL PRIMARY KEY, NAME VARCHAR)");
            stat.execute("CREATE VIEW TEST_VIEW AS TABLE TEST_TABLE");
            stat.execute("CREATE TRIGGER T_TEST_VIEW INSTEAD OF INSERT, UPDATE, DELETE ON TEST_VIEW FOR EACH ROW CALL \"" + UpdatableView.class.getName() + "\"");
            stat.execute("INSERT INTO TEST_VIEW(NAME) VALUES 'Hello', 'World'", new String[]{"ID"});
            Throwable throwable2 = null;
            Object var6_11 = null;
            try {
                rs = stat.getGeneratedKeys();
                try {
                    while (rs.next()) {
                        System.out.printf("Key %d was generated%n", rs.getLong(1));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            System.out.println();
            stat.execute("UPDATE TEST_VIEW SET NAME = 'Hallo' WHERE ID = 1");
            stat.execute("DELETE FROM TEST_VIEW WHERE ID = 2");
            System.out.println("TEST_TABLE:");
            throwable2 = null;
            var6_11 = null;
            try {
                rs = stat.executeQuery("TABLE TEST_TABLE");
                try {
                    while (rs.next()) {
                        System.out.printf("%d %s%n", rs.getLong(1), rs.getString(2));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                } else if (throwable2 != throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
            System.out.println();
            System.out.println("TEST_VIEW:");
            throwable2 = null;
            var6_11 = null;
            try {
                rs = stat.executeQuery("TABLE TEST_VIEW");
                try {
                    while (rs.next()) {
                        System.out.printf("%d %s%n", rs.getLong(1), rs.getString(2));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable2 == null) {
                    throwable2 = throwable5;
                } else if (throwable2 != throwable5) {
                    throwable2.addSuppressed(throwable5);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    @Override
    public void init(Connection conn, String schemaName, String triggerName, String tableName, boolean before, int type) throws SQLException {
        this.prepDelete = conn.prepareStatement("DELETE FROM TEST_TABLE WHERE ID = ?");
        this.prepInsert = conn.prepareStatement("SELECT * FROM FINAL TABLE(INSERT INTO TEST_TABLE VALUES (?, ?))");
        super.init(conn, schemaName, triggerName, tableName, before, type);
    }

    @Override
    public void fire(Connection conn, ResultSet oldRow, ResultSet newRow) throws SQLException {
        if (oldRow != null && oldRow.next()) {
            this.prepDelete.setLong(1, oldRow.getLong(1));
            this.prepDelete.execute();
        }
        if (newRow != null && newRow.next()) {
            long id = newRow.getLong(1);
            if (newRow.wasNull()) {
                this.prepInsert.setNull(1, -5);
            } else {
                this.prepInsert.setLong(1, id);
            }
            this.prepInsert.setString(2, newRow.getString(2));
            Throwable throwable = null;
            Object var7_7 = null;
            try (ResultSet rs = this.prepInsert.executeQuery();){
                rs.next();
                newRow.updateLong(1, rs.getLong(1));
                newRow.updateString(2, rs.getString(2));
                newRow.rowUpdated();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    @Override
    public void close() throws SQLException {
        this.prepInsert.close();
        this.prepDelete.close();
    }
}

