/*
 * Decompiled with CFR 0.152.
 */
package org.h2.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.engine.User;
import org.h2.schema.Schema;
import org.h2.table.Table;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class MetaSchema
extends Schema {
    public MetaSchema(Database database, int id, String schemaName, User owner) {
        super(database, id, schemaName, owner, true);
    }

    @Override
    public Table findTableOrView(SessionLocal session, String name) {
        Map<String, Table> map = this.getMap(session);
        Table table = map.get(name);
        if (table != null) {
            return table;
        }
        return super.findTableOrView(session, name);
    }

    @Override
    public Collection<Table> getAllTablesAndViews(SessionLocal session) {
        Collection<Table> userTables = super.getAllTablesAndViews(session);
        if (session == null) {
            return userTables;
        }
        Collection<Table> systemTables = this.getMap(session).values();
        if (userTables.isEmpty()) {
            return systemTables;
        }
        ArrayList<Table> list = new ArrayList<Table>(systemTables.size() + userTables.size());
        list.addAll(systemTables);
        list.addAll(userTables);
        return list;
    }

    @Override
    public Table getTableOrView(SessionLocal session, String name) {
        Map<String, Table> map = this.getMap(session);
        Table table = map.get(name);
        if (table != null) {
            return table;
        }
        return super.getTableOrView(session, name);
    }

    @Override
    public Table getTableOrViewByName(SessionLocal session, String name) {
        Map<String, Table> map = this.getMap(session);
        Table table = map.get(name);
        if (table != null) {
            return table;
        }
        return super.getTableOrViewByName(session, name);
    }

    protected abstract Map<String, Table> getMap(SessionLocal var1);

    @Override
    public boolean isEmpty() {
        return false;
    }
}

