/*
 * Decompiled with CFR 0.152.
 */
package org.h2.schema;

import java.sql.Connection;
import java.sql.SQLException;
import org.h2.api.Aggregate;
import org.h2.api.AggregateFunction;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.UserDefinedFunction;
import org.h2.util.JdbcUtils;
import org.h2.util.StringUtils;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class UserAggregate
extends UserDefinedFunction {
    private Class<?> javaClass;

    public UserAggregate(Schema schema, int id, String name, String className, boolean force) {
        super(schema, id, name, 3);
        this.className = className;
        if (!force) {
            this.getInstance();
        }
    }

    public Aggregate getInstance() {
        if (this.javaClass == null) {
            this.javaClass = JdbcUtils.loadUserClass(this.className);
        }
        try {
            Object obj = this.javaClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Aggregate agg = obj instanceof Aggregate ? (Aggregate)obj : new AggregateWrapper((AggregateFunction)obj);
            return agg;
        }
        catch (Exception e) {
            throw DbException.convert(e);
        }
    }

    @Override
    public String getDropSQL() {
        StringBuilder builder = new StringBuilder("DROP AGGREGATE IF EXISTS ");
        return this.getSQL(builder, 0).toString();
    }

    @Override
    public String getCreateSQL() {
        StringBuilder builder = new StringBuilder("CREATE FORCE AGGREGATE ");
        this.getSQL(builder, 0).append(" FOR ");
        return StringUtils.quoteStringSQL(builder, this.className).toString();
    }

    @Override
    public int getType() {
        return 14;
    }

    @Override
    public synchronized void removeChildrenAndResources(SessionLocal session) {
        this.database.removeMeta(session, this.getId());
        this.className = null;
        this.javaClass = null;
        this.invalidate();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class AggregateWrapper
    implements Aggregate {
        private final AggregateFunction aggregateFunction;

        AggregateWrapper(AggregateFunction aggregateFunction) {
            this.aggregateFunction = aggregateFunction;
        }

        @Override
        public void init(Connection conn) throws SQLException {
            this.aggregateFunction.init(conn);
        }

        @Override
        public int getInternalType(int[] inputTypes) throws SQLException {
            int[] sqlTypes = new int[inputTypes.length];
            int i = 0;
            while (i < inputTypes.length) {
                sqlTypes[i] = DataType.convertTypeToSQLType(TypeInfo.getTypeInfo(inputTypes[i]));
                ++i;
            }
            return DataType.convertSQLTypeToValueType(this.aggregateFunction.getType(sqlTypes));
        }

        @Override
        public void add(Object value) throws SQLException {
            this.aggregateFunction.add(value);
        }

        @Override
        public Object getResult() throws SQLException {
            return this.aggregateFunction.getResult();
        }
    }
}

