/*
 * Decompiled with CFR 0.152.
 */
package org.h2.security;

import org.h2.security.BlockCipher;
import org.h2.util.Bits;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Fog
implements BlockCipher {
    private int key;

    @Override
    public void encrypt(byte[] bytes, int off, int len) {
        int i = off;
        while (i < off + len) {
            this.encryptBlock(bytes, bytes, i);
            i += 16;
        }
    }

    @Override
    public void decrypt(byte[] bytes, int off, int len) {
        int i = off;
        while (i < off + len) {
            this.decryptBlock(bytes, bytes, i);
            i += 16;
        }
    }

    private void encryptBlock(byte[] in, byte[] out, int off) {
        int x0 = Bits.INT_VH_BE.get(in, off);
        int x1 = Bits.INT_VH_BE.get(in, off + 4);
        int x2 = Bits.INT_VH_BE.get(in, off + 8);
        int x3 = Bits.INT_VH_BE.get(in, off + 12);
        int k = this.key;
        x0 = Integer.rotateLeft(x0 ^ k, x1);
        x2 = Integer.rotateLeft(x2 ^ k, x1);
        x1 = Integer.rotateLeft(x1 ^ k, x0);
        x3 = Integer.rotateLeft(x3 ^ k, x0);
        Bits.INT_VH_BE.set(out, off, x0);
        Bits.INT_VH_BE.set(out, off + 4, x1);
        Bits.INT_VH_BE.set(out, off + 8, x2);
        Bits.INT_VH_BE.set(out, off + 12, x3);
    }

    private void decryptBlock(byte[] in, byte[] out, int off) {
        int x0 = Bits.INT_VH_BE.get(in, off);
        int x1 = Bits.INT_VH_BE.get(in, off + 4);
        int x2 = Bits.INT_VH_BE.get(in, off + 8);
        int x3 = Bits.INT_VH_BE.get(in, off + 12);
        int k = this.key;
        x1 = Integer.rotateRight(x1, x0) ^ k;
        x3 = Integer.rotateRight(x3, x0) ^ k;
        x0 = Integer.rotateRight(x0, x1) ^ k;
        x2 = Integer.rotateRight(x2, x1) ^ k;
        Bits.INT_VH_BE.set(out, off, x0);
        Bits.INT_VH_BE.set(out, off + 4, x1);
        Bits.INT_VH_BE.set(out, off + 8, x2);
        Bits.INT_VH_BE.set(out, off + 12, x3);
    }

    @Override
    public int getKeyLength() {
        return 16;
    }

    @Override
    public void setKey(byte[] key) {
        this.key = (int)Bits.LONG_VH_BE.get(key, 0);
    }
}

