/*
 * Decompiled with CFR 0.152.
 */
package org.h2.security.auth;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.h2.api.CredentialsValidator;
import org.h2.api.UserToRolesMapper;
import org.h2.engine.Database;
import org.h2.engine.Right;
import org.h2.engine.Role;
import org.h2.engine.SessionLocal;
import org.h2.engine.SysProperties;
import org.h2.engine.User;
import org.h2.engine.UserBuilder;
import org.h2.message.Trace;
import org.h2.security.auth.AuthConfigException;
import org.h2.security.auth.AuthenticationException;
import org.h2.security.auth.AuthenticationInfo;
import org.h2.security.auth.Authenticator;
import org.h2.security.auth.ConfigProperties;
import org.h2.security.auth.H2AuthConfig;
import org.h2.security.auth.H2AuthConfigXml;
import org.h2.security.auth.RealmConfig;
import org.h2.security.auth.UserToRolesMapperConfig;
import org.h2.security.auth.impl.AssignRealmNameRole;
import org.h2.security.auth.impl.JaasCredentialsValidator;
import org.h2.util.StringUtils;
import org.xml.sax.SAXException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DefaultAuthenticator
implements Authenticator {
    public static final String DEFAULT_REALMNAME = "H2";
    private Map<String, CredentialsValidator> realms = new HashMap<String, CredentialsValidator>();
    private List<UserToRolesMapper> userToRolesMappers = new ArrayList<UserToRolesMapper>();
    private boolean allowUserRegistration;
    private boolean persistUsers;
    private boolean createMissingRoles;
    private boolean skipDefaultInitialization;
    private boolean initialized;
    private static DefaultAuthenticator instance;

    protected static final DefaultAuthenticator getInstance() {
        if (instance == null) {
            instance = new DefaultAuthenticator();
        }
        return instance;
    }

    public DefaultAuthenticator() {
    }

    public DefaultAuthenticator(boolean skipDefaultInitialization) {
        this.skipDefaultInitialization = skipDefaultInitialization;
    }

    public boolean isPersistUsers() {
        return this.persistUsers;
    }

    public void setPersistUsers(boolean persistUsers) {
        this.persistUsers = persistUsers;
    }

    public boolean isAllowUserRegistration() {
        return this.allowUserRegistration;
    }

    public void setAllowUserRegistration(boolean allowUserRegistration) {
        this.allowUserRegistration = allowUserRegistration;
    }

    public boolean isCreateMissingRoles() {
        return this.createMissingRoles;
    }

    public void setCreateMissingRoles(boolean createMissingRoles) {
        this.createMissingRoles = createMissingRoles;
    }

    public void addRealm(String name, CredentialsValidator credentialsValidator) {
        this.realms.put(StringUtils.toUpperEnglish(name), credentialsValidator);
    }

    public List<UserToRolesMapper> getUserToRolesMappers() {
        return this.userToRolesMappers;
    }

    public void setUserToRolesMappers(UserToRolesMapper ... userToRolesMappers) {
        ArrayList<UserToRolesMapper> userToRolesMappersList = new ArrayList<UserToRolesMapper>();
        UserToRolesMapper[] userToRolesMapperArray = userToRolesMappers;
        int n = userToRolesMappers.length;
        int n2 = 0;
        while (n2 < n) {
            UserToRolesMapper current = userToRolesMapperArray[n2];
            userToRolesMappersList.add(current);
            ++n2;
        }
        this.userToRolesMappers = userToRolesMappersList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Database database) throws AuthConfigException {
        if (this.skipDefaultInitialization) {
            return;
        }
        if (this.initialized) {
            return;
        }
        DefaultAuthenticator defaultAuthenticator = this;
        synchronized (defaultAuthenticator) {
            if (this.initialized) {
                return;
            }
            Trace trace = database.getTrace(2);
            URL h2AuthenticatorConfigurationUrl = null;
            try {
                String configFile = SysProperties.AUTH_CONFIG_FILE;
                if (configFile != null) {
                    if (trace.isDebugEnabled()) {
                        trace.debug("DefaultAuthenticator.config: configuration read from system property h2auth.configurationfile={0}", configFile);
                    }
                    h2AuthenticatorConfigurationUrl = new URL(configFile);
                }
                if (h2AuthenticatorConfigurationUrl == null) {
                    if (trace.isDebugEnabled()) {
                        trace.debug("DefaultAuthenticator.config: default configuration");
                    }
                    this.defaultConfiguration();
                } else {
                    this.configureFromUrl(h2AuthenticatorConfigurationUrl);
                }
            }
            catch (Exception e) {
                trace.error(e, "DefaultAuthenticator.config: an error occurred during configuration from {0} ", h2AuthenticatorConfigurationUrl);
                throw new AuthConfigException("Failed to configure authentication from " + String.valueOf(h2AuthenticatorConfigurationUrl), e);
            }
            this.initialized = true;
        }
    }

    private void defaultConfiguration() {
        this.createMissingRoles = false;
        this.allowUserRegistration = true;
        this.realms = new HashMap<String, CredentialsValidator>();
        JaasCredentialsValidator jaasCredentialsValidator = new JaasCredentialsValidator();
        jaasCredentialsValidator.configure(new ConfigProperties());
        this.realms.put(DEFAULT_REALMNAME, jaasCredentialsValidator);
        AssignRealmNameRole assignRealmNameRole = new AssignRealmNameRole();
        assignRealmNameRole.configure(new ConfigProperties());
        this.userToRolesMappers.add(assignRealmNameRole);
    }

    public void configureFromUrl(URL configUrl) throws AuthenticationException, SAXException, IOException, ParserConfigurationException {
        H2AuthConfig config = H2AuthConfigXml.parseFrom(configUrl);
        this.configureFrom(config);
    }

    private void configureFrom(H2AuthConfig config) throws AuthenticationException {
        this.allowUserRegistration = config.isAllowUserRegistration();
        this.createMissingRoles = config.isCreateMissingRoles();
        HashMap<String, CredentialsValidator> newRealms = new HashMap<String, CredentialsValidator>();
        for (RealmConfig currentRealmConfig : config.getRealms()) {
            String currentRealmName = currentRealmConfig.getName();
            if (currentRealmName == null) {
                throw new AuthenticationException("Missing realm name");
            }
            currentRealmName = currentRealmName.toUpperCase();
            CredentialsValidator currentValidator = null;
            try {
                currentValidator = (CredentialsValidator)Class.forName(currentRealmConfig.getValidatorClass()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new AuthenticationException("invalid validator class fo realm " + currentRealmName, e);
            }
            currentValidator.configure(new ConfigProperties(currentRealmConfig.getProperties()));
            if (newRealms.putIfAbsent(currentRealmConfig.getName().toUpperCase(), currentValidator) == null) continue;
            throw new AuthenticationException("Duplicate realm " + currentRealmConfig.getName());
        }
        this.realms = newRealms;
        ArrayList<UserToRolesMapper> newUserToRolesMapper = new ArrayList<UserToRolesMapper>();
        for (UserToRolesMapperConfig currentUserToRolesMapperConfig : config.getUserToRolesMappers()) {
            UserToRolesMapper currentUserToRolesMapper = null;
            try {
                currentUserToRolesMapper = (UserToRolesMapper)Class.forName(currentUserToRolesMapperConfig.getClassName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new AuthenticationException("Invalid class in UserToRolesMapperConfig", e);
            }
            currentUserToRolesMapper.configure(new ConfigProperties(currentUserToRolesMapperConfig.getProperties()));
            newUserToRolesMapper.add(currentUserToRolesMapper);
        }
        this.userToRolesMappers = newUserToRolesMapper;
    }

    private boolean updateRoles(AuthenticationInfo authenticationInfo, User user, Database database) throws AuthenticationException {
        boolean updatedDb = false;
        HashSet<String> roles = new HashSet<String>();
        for (UserToRolesMapper currentUserToRolesMapper : this.userToRolesMappers) {
            Collection<String> currentRoles = currentUserToRolesMapper.mapUserToRoles(authenticationInfo);
            if (currentRoles == null || currentRoles.isEmpty()) continue;
            roles.addAll(currentRoles);
        }
        for (String currentRoleName : roles) {
            if (currentRoleName == null || currentRoleName.isEmpty()) continue;
            Role currentRole = database.findRole(currentRoleName);
            if (currentRole == null && this.isCreateMissingRoles()) {
                SessionLocal systemSession = database.getSystemSession();
                systemSession.lock();
                try {
                    currentRole = new Role(database, database.allocateObjectId(), currentRoleName, false);
                    database.addDatabaseObject(database.getSystemSession(), currentRole);
                    database.getSystemSession().commit(false);
                    updatedDb = true;
                }
                finally {
                    systemSession.unlock();
                }
            }
            if (currentRole == null || user.getRightForRole(currentRole) != null) continue;
            Right currentRight = new Right(database, -1, user, currentRole);
            currentRight.setTemporary(true);
            user.grantRole(currentRole, currentRight);
        }
        return updatedDb;
    }

    @Override
    public final User authenticate(AuthenticationInfo authenticationInfo, Database database) throws AuthenticationException {
        String userName = authenticationInfo.getFullyQualifiedName();
        User user = database.findUser(userName);
        if (user == null && !this.isAllowUserRegistration()) {
            throw new AuthenticationException("User " + userName + " not found in db");
        }
        CredentialsValidator validator = this.realms.get(authenticationInfo.getRealm());
        if (validator == null) {
            throw new AuthenticationException("realm " + authenticationInfo.getRealm() + " not configured");
        }
        try {
            if (!validator.validateCredentials(authenticationInfo)) {
                return null;
            }
        }
        catch (Exception e) {
            throw new AuthenticationException(e);
        }
        if (user == null) {
            SessionLocal systemSession = database.getSystemSession();
            systemSession.lock();
            try {
                user = UserBuilder.buildUser(authenticationInfo, database, this.isPersistUsers());
                database.addDatabaseObject(database.getSystemSession(), user);
                database.getSystemSession().commit(false);
            }
            finally {
                systemSession.unlock();
            }
        }
        user.revokeTemporaryRightsOnRoles();
        this.updateRoles(authenticationInfo, user, database);
        return user;
    }
}

