/*
 * Decompiled with CFR 0.152.
 */
package org.h2.security.auth.impl;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.directory.InitialDirContext;
import org.h2.api.CredentialsValidator;
import org.h2.security.auth.AuthenticationInfo;
import org.h2.security.auth.ConfigProperties;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class LdapCredentialsValidator
implements CredentialsValidator {
    private String bindDnPattern;
    private String host;
    private int port;
    private boolean secure;
    private String url;

    @Override
    public void configure(ConfigProperties configProperties) {
        this.bindDnPattern = configProperties.getStringValue("bindDnPattern");
        this.host = configProperties.getStringValue("host");
        this.secure = configProperties.getBooleanValue("secure", true);
        this.port = configProperties.getIntValue("port", this.secure ? 636 : 389);
        this.url = "ldap" + (this.secure ? "s" : "") + "://" + this.host + ":" + this.port;
    }

    @Override
    public boolean validateCredentials(AuthenticationInfo authenticationInfo) throws Exception {
        try (Context dirContext = null;){
            String dn = this.bindDnPattern.replace("%u", authenticationInfo.getUserName());
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", this.url);
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", dn);
            env.put("java.naming.security.credentials", authenticationInfo.getPassword());
            if (this.secure) {
                env.put("java.naming.security.protocol", "ssl");
            }
            dirContext = new InitialDirContext(env);
            authenticationInfo.setNestedIdentity(dn);
            return true;
        }
    }
}

