/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.server.Service;
import org.h2.server.ShutdownHandler;
import org.h2.server.TcpServerThread;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;
import org.h2.util.StringUtils;
import org.h2.util.Tool;
import org.h2.util.Utils;
import org.h2.util.Utils10;
import org.h2.util.Utils21;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TcpServer
implements Service {
    private static final int SHUTDOWN_NORMAL = 0;
    private static final int SHUTDOWN_FORCE = 1;
    private static final String MANAGEMENT_DB_PREFIX = "management_db_";
    private static final ConcurrentHashMap<Integer, TcpServer> SERVERS = new ConcurrentHashMap();
    private int port;
    private boolean portIsSet;
    private boolean trace;
    private boolean ssl;
    private boolean stop;
    private ShutdownHandler shutdownHandler;
    private ServerSocket serverSocket;
    private final Set<TcpServerThread> running = Collections.synchronizedSet(new HashSet());
    private String baseDir;
    private boolean allowOthers;
    private boolean isDaemon;
    private boolean ifExists = true;
    private boolean virtualThreads;
    private JdbcConnection managementDb;
    private PreparedStatement managementDbAdd;
    private PreparedStatement managementDbRemove;
    private String managementPassword = "";
    private Thread listenerThread;
    private int nextThreadId;
    private String key;
    private String keyDatabase;

    public static String getManagementDbName(int port) {
        return "mem:management_db_" + port;
    }

    private void initManagementDb() throws SQLException {
        JdbcConnection conn;
        if (this.managementPassword.isEmpty()) {
            this.managementPassword = StringUtils.convertBytesToHex(MathUtils.secureRandomBytes(32));
        }
        this.managementDb = conn = new JdbcConnection("jdbc:h2:" + TcpServer.getManagementDbName(this.port), null, "", this.managementPassword, false);
        Throwable throwable = null;
        Object var3_4 = null;
        try (Statement stat = conn.createStatement();){
            stat.execute("CREATE ALIAS IF NOT EXISTS STOP_SERVER FOR '" + TcpServer.class.getName() + ".stopServer'");
            stat.execute("CREATE TABLE IF NOT EXISTS SESSIONS(ID INT PRIMARY KEY, URL VARCHAR, `USER` VARCHAR, CONNECTED TIMESTAMP(9) WITH TIME ZONE)");
            this.managementDbAdd = conn.prepareStatement("INSERT INTO SESSIONS VALUES(?, ?, ?, CURRENT_TIMESTAMP(9))");
            this.managementDbRemove = conn.prepareStatement("DELETE FROM SESSIONS WHERE ID=?");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        SERVERS.put(this.port, this);
    }

    void shutdown() {
        if (this.shutdownHandler != null) {
            this.shutdownHandler.shutdown();
        }
    }

    public void setShutdownHandler(ShutdownHandler shutdownHandler) {
        this.shutdownHandler = shutdownHandler;
    }

    synchronized void addConnection(int id, String url, String user) {
        try {
            this.managementDbAdd.setInt(1, id);
            this.managementDbAdd.setString(2, url);
            this.managementDbAdd.setString(3, user);
            this.managementDbAdd.execute();
        }
        catch (SQLException e) {
            DbException.traceThrowable(e);
        }
    }

    synchronized void removeConnection(int id) {
        try {
            this.managementDbRemove.setInt(1, id);
            this.managementDbRemove.execute();
        }
        catch (SQLException e) {
            DbException.traceThrowable(e);
        }
    }

    private synchronized void stopManagementDb() {
        if (this.managementDb != null) {
            try {
                this.managementDb.close();
            }
            catch (SQLException e) {
                DbException.traceThrowable(e);
            }
            this.managementDb = null;
        }
    }

    @Override
    public void init(String ... args) {
        this.port = 9092;
        int i = 0;
        while (args != null && i < args.length) {
            String a = args[i];
            if (Tool.isOption(a, "-trace")) {
                this.trace = true;
            } else if (Tool.isOption(a, "-tcpSSL")) {
                this.ssl = true;
            } else if (Tool.isOption(a, "-tcpPort")) {
                this.port = Integer.decode(args[++i]);
                this.portIsSet = true;
            } else if (Tool.isOption(a, "-tcpPassword")) {
                this.managementPassword = args[++i];
            } else if (Tool.isOption(a, "-baseDir")) {
                this.baseDir = args[++i];
            } else if (Tool.isOption(a, "-key")) {
                this.key = args[++i];
                this.keyDatabase = args[++i];
            } else if (Tool.isOption(a, "-tcpAllowOthers")) {
                this.allowOthers = true;
            } else if (Tool.isOption(a, "-tcpDaemon")) {
                this.isDaemon = true;
            } else if (Tool.isOption(a, "-tcpVirtualThreads")) {
                this.virtualThreads = Utils.parseBoolean(args[++i], this.virtualThreads, true);
            } else if (Tool.isOption(a, "-ifExists")) {
                this.ifExists = true;
            } else if (Tool.isOption(a, "-ifNotExists")) {
                this.ifExists = false;
            }
            ++i;
        }
    }

    @Override
    public String getURL() {
        return (this.ssl ? "ssl" : "tcp") + "://" + NetUtils.getLocalAddress() + ":" + this.port;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public boolean getSSL() {
        return this.ssl;
    }

    boolean allow(Socket socket) {
        if (this.allowOthers) {
            return true;
        }
        try {
            return NetUtils.isLocalAddress(socket);
        }
        catch (UnknownHostException e) {
            this.traceError(e);
            return false;
        }
    }

    @Override
    public synchronized void start() throws SQLException {
        this.stop = false;
        try {
            this.serverSocket = NetUtils.createServerSocket(this.port, this.ssl);
        }
        catch (DbException e) {
            if (!this.portIsSet) {
                this.serverSocket = NetUtils.createServerSocket(0, this.ssl);
            }
            throw e;
        }
        this.port = this.serverSocket.getLocalPort();
        this.initManagementDb();
    }

    @Override
    public void listen() {
        block5: {
            this.listenerThread = Thread.currentThread();
            String threadName = this.listenerThread.getName();
            try {
                while (!this.stop) {
                    Thread thread;
                    int id;
                    Socket s = this.serverSocket.accept();
                    Utils10.setTcpQuickack(s, true);
                    ++this.nextThreadId;
                    TcpServerThread c = new TcpServerThread(s, this, id);
                    this.running.add(c);
                    if (this.virtualThreads) {
                        thread = Utils21.newVirtualThread(c);
                    } else {
                        thread = new Thread(c);
                        thread.setDaemon(this.isDaemon);
                    }
                    thread.setName(threadName + " thread-" + id);
                    c.setThread(thread);
                    thread.start();
                }
                this.serverSocket = NetUtils.closeSilently(this.serverSocket);
            }
            catch (Exception e) {
                if (this.stop) break block5;
                DbException.traceThrowable(e);
            }
        }
        this.stopManagementDb();
    }

    @Override
    public synchronized boolean isRunning(boolean traceError) {
        if (this.serverSocket == null) {
            return false;
        }
        try {
            Socket s = NetUtils.createLoopbackSocket(this.port, this.ssl);
            s.close();
            return true;
        }
        catch (Exception e) {
            if (traceError) {
                this.traceError(e);
            }
            return false;
        }
    }

    @Override
    public void stop() {
        SERVERS.remove(this.port);
        if (!this.stop) {
            this.stopManagementDb();
            this.stop = true;
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    DbException.traceThrowable(e);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                this.serverSocket = null;
            }
            if (this.listenerThread != null) {
                try {
                    this.listenerThread.join(1000L);
                }
                catch (InterruptedException e) {
                    DbException.traceThrowable(e);
                }
            }
        }
        for (TcpServerThread c : new ArrayList<TcpServerThread>(this.running)) {
            if (c == null) continue;
            c.close();
            try {
                c.getThread().join(100L);
            }
            catch (Exception e) {
                DbException.traceThrowable(e);
            }
        }
    }

    public static void stopServer(int port, String password, int shutdownMode) {
        if (port == 0) {
            Integer[] integerArray = ((ConcurrentHashMap.CollectionView)((Object)SERVERS.keySet())).toArray(new Integer[0]);
            int n = integerArray.length;
            int n2 = 0;
            while (n2 < n) {
                int p = integerArray[n2];
                if (p != 0) {
                    TcpServer.stopServer(p, password, shutdownMode);
                }
                ++n2;
            }
            return;
        }
        TcpServer server = SERVERS.get(port);
        if (server == null) {
            return;
        }
        if (!server.managementPassword.equals(password)) {
            return;
        }
        if (shutdownMode == 0) {
            server.stopManagementDb();
            server.stop = true;
            try {
                Socket s = NetUtils.createLoopbackSocket(port, false);
                s.close();
            }
            catch (Exception exception) {}
        } else if (shutdownMode == 1) {
            server.stop();
        }
        server.shutdown();
    }

    void remove(TcpServerThread t) {
        this.running.remove(t);
    }

    String getBaseDir() {
        return this.baseDir;
    }

    void trace(String s) {
        if (this.trace) {
            System.out.println(s);
        }
    }

    void traceError(Throwable e) {
        if (this.trace) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean getAllowOthers() {
        return this.allowOthers;
    }

    @Override
    public String getType() {
        return "TCP";
    }

    @Override
    public String getName() {
        return "H2 TCP Server";
    }

    boolean getIfExists() {
        return this.ifExists;
    }

    public static synchronized void shutdown(String url, String password, boolean force, boolean all) throws SQLException {
        try {
            String p;
            int port = 9092;
            int idx = url.lastIndexOf(58);
            if (idx >= 0 && StringUtils.isNumber(p = url.substring(idx + 1))) {
                port = Integer.decode(p);
            }
            String db = TcpServer.getManagementDbName(port);
            int i = 0;
            while (i < 2) {
                try {
                    Throwable throwable = null;
                    Object var9_12 = null;
                    try (JdbcConnection conn = new JdbcConnection("jdbc:h2:" + url + "/" + db, null, "", password, true);){
                        PreparedStatement prep = conn.prepareStatement("CALL STOP_SERVER(?, ?, ?)");
                        prep.setInt(1, all ? 0 : port);
                        prep.setString(2, password);
                        prep.setInt(3, force ? 1 : 0);
                        try {
                            prep.execute();
                            break;
                        }
                        catch (SQLException e) {
                            if (!force && e.getErrorCode() != 90067) {
                                throw e;
                            }
                            break;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    if (i == 1) {
                        throw e;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw DbException.toSQLException(e);
        }
    }

    void cancelStatement(String sessionId, int statementId) {
        for (TcpServerThread c : new ArrayList<TcpServerThread>(this.running)) {
            if (c == null) continue;
            c.cancelStatement(sessionId, statementId);
        }
    }

    public String checkKeyAndGetDatabaseName(String db) {
        if (this.key == null) {
            return db;
        }
        if (this.key.equals(db)) {
            return this.keyDatabase;
        }
        throw DbException.get(28000);
    }

    @Override
    public boolean isDaemon() {
        return this.isDaemon;
    }
}

