/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.pg;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.h2.message.DbException;
import org.h2.server.Service;
import org.h2.server.pg.PgServerThread;
import org.h2.util.NetUtils;
import org.h2.util.Tool;
import org.h2.util.Utils;
import org.h2.util.Utils10;
import org.h2.util.Utils21;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class PgServer
implements Service {
    public static final int DEFAULT_PORT = 5435;
    public static final int PG_TYPE_VARCHAR = 1043;
    public static final int PG_TYPE_BOOL = 16;
    public static final int PG_TYPE_BYTEA = 17;
    public static final int PG_TYPE_BPCHAR = 1042;
    public static final int PG_TYPE_INT8 = 20;
    public static final int PG_TYPE_INT2 = 21;
    public static final int PG_TYPE_INT4 = 23;
    public static final int PG_TYPE_TEXT = 25;
    public static final int PG_TYPE_FLOAT4 = 700;
    public static final int PG_TYPE_FLOAT8 = 701;
    public static final int PG_TYPE_UNKNOWN = 705;
    public static final int PG_TYPE_INT2_ARRAY = 1005;
    public static final int PG_TYPE_INT4_ARRAY = 1007;
    public static final int PG_TYPE_VARCHAR_ARRAY = 1015;
    public static final int PG_TYPE_DATE = 1082;
    public static final int PG_TYPE_TIME = 1083;
    public static final int PG_TYPE_TIMETZ = 1266;
    public static final int PG_TYPE_TIMESTAMP = 1114;
    public static final int PG_TYPE_TIMESTAMPTZ = 1184;
    public static final int PG_TYPE_NUMERIC = 1700;
    private final HashSet<Integer> typeSet = new HashSet();
    private int port = 5435;
    private boolean portIsSet;
    private boolean stop;
    private boolean trace;
    private ServerSocket serverSocket;
    private final Set<PgServerThread> running = Collections.synchronizedSet(new HashSet());
    private final AtomicInteger pid = new AtomicInteger();
    private String baseDir;
    private boolean allowOthers;
    private boolean isDaemon;
    private boolean ifExists = true;
    private boolean virtualThreads;
    private String key;
    private String keyDatabase;

    @Override
    public void init(String ... args) {
        this.port = 5435;
        int i = 0;
        while (args != null && i < args.length) {
            String a = args[i];
            if (Tool.isOption(a, "-trace")) {
                this.trace = true;
            } else if (Tool.isOption(a, "-pgPort")) {
                this.port = Integer.decode(args[++i]);
                this.portIsSet = true;
            } else if (Tool.isOption(a, "-baseDir")) {
                this.baseDir = args[++i];
            } else if (Tool.isOption(a, "-pgAllowOthers")) {
                this.allowOthers = true;
            } else if (Tool.isOption(a, "-pgDaemon")) {
                this.isDaemon = true;
            } else if (Tool.isOption(a, "-pgVirtualThreads")) {
                this.virtualThreads = Utils.parseBoolean(args[++i], this.virtualThreads, true);
            } else if (Tool.isOption(a, "-ifExists")) {
                this.ifExists = true;
            } else if (Tool.isOption(a, "-ifNotExists")) {
                this.ifExists = false;
            } else if (Tool.isOption(a, "-key")) {
                this.key = args[++i];
                this.keyDatabase = args[++i];
            }
            ++i;
        }
    }

    boolean getTrace() {
        return this.trace;
    }

    void trace(String s) {
        if (this.trace) {
            System.out.println(s);
        }
    }

    synchronized void remove(PgServerThread t) {
        this.running.remove(t);
    }

    void traceError(Exception e) {
        if (this.trace) {
            e.printStackTrace();
        }
    }

    @Override
    public String getURL() {
        return "pg://" + NetUtils.getLocalAddress() + ":" + this.port;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    private boolean allow(Socket socket) {
        if (this.allowOthers) {
            return true;
        }
        try {
            return NetUtils.isLocalAddress(socket);
        }
        catch (UnknownHostException e) {
            this.traceError(e);
            return false;
        }
    }

    @Override
    public void start() {
        this.stop = false;
        try {
            this.serverSocket = NetUtils.createServerSocket(this.port, false);
        }
        catch (DbException e) {
            if (!this.portIsSet) {
                this.serverSocket = NetUtils.createServerSocket(0, false);
            }
            throw e;
        }
        this.port = this.serverSocket.getLocalPort();
    }

    @Override
    public void listen() {
        block6: {
            String threadName = Thread.currentThread().getName();
            try {
                while (!this.stop) {
                    Thread thread;
                    Socket s = this.serverSocket.accept();
                    if (!this.allow(s)) {
                        this.trace("Connection not allowed");
                        s.close();
                        continue;
                    }
                    Utils10.setTcpQuickack(s, true);
                    PgServerThread c = new PgServerThread(s, this);
                    this.running.add(c);
                    int id = this.pid.incrementAndGet();
                    c.setProcessId(id);
                    if (this.virtualThreads) {
                        thread = Utils21.newVirtualThread(c);
                    } else {
                        thread = new Thread(c);
                        thread.setDaemon(this.isDaemon);
                    }
                    thread.setName(threadName + " thread-" + id);
                    c.setThread(thread);
                    thread.start();
                }
            }
            catch (Exception e) {
                if (this.stop) break block6;
                e.printStackTrace();
            }
        }
    }

    @Override
    public void stop() {
        if (!this.stop) {
            this.stop = true;
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.serverSocket = null;
            }
        }
        for (PgServerThread c : new ArrayList<PgServerThread>(this.running)) {
            c.close();
            try {
                Thread t = c.getThread();
                if (t == null) continue;
                t.join(100L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isRunning(boolean traceError) {
        if (this.serverSocket == null) {
            return false;
        }
        try {
            Socket s = NetUtils.createLoopbackSocket(this.serverSocket.getLocalPort(), false);
            s.close();
            return true;
        }
        catch (Exception e) {
            if (traceError) {
                this.traceError(e);
            }
            return false;
        }
    }

    PgServerThread getThread(int processId) {
        for (PgServerThread c : new ArrayList<PgServerThread>(this.running)) {
            if (c.getProcessId() != processId) continue;
            return c;
        }
        return null;
    }

    String getBaseDir() {
        return this.baseDir;
    }

    @Override
    public boolean getAllowOthers() {
        return this.allowOthers;
    }

    @Override
    public String getType() {
        return "PG";
    }

    @Override
    public String getName() {
        return "H2 PG Server";
    }

    boolean getIfExists() {
        return this.ifExists;
    }

    public static String formatType(int pgType) {
        int valueType;
        switch (pgType) {
            case 0: {
                return "-";
            }
            case 16: {
                valueType = 8;
                break;
            }
            case 17: {
                valueType = 6;
                break;
            }
            case 18: {
                return "char";
            }
            case 19: {
                return "name";
            }
            case 20: {
                valueType = 12;
                break;
            }
            case 21: {
                valueType = 10;
                break;
            }
            case 22: {
                return "int2vector";
            }
            case 23: {
                valueType = 11;
                break;
            }
            case 24: {
                return "regproc";
            }
            case 25: {
                valueType = 3;
                break;
            }
            case 700: {
                valueType = 14;
                break;
            }
            case 701: {
                valueType = 15;
                break;
            }
            case 1005: {
                return "smallint[]";
            }
            case 1007: {
                return "integer[]";
            }
            case 1015: {
                return "character varying[]";
            }
            case 1042: {
                valueType = 1;
                break;
            }
            case 1043: {
                valueType = 2;
                break;
            }
            case 1082: {
                valueType = 17;
                break;
            }
            case 1083: {
                valueType = 18;
                break;
            }
            case 1266: {
                valueType = 19;
                break;
            }
            case 1114: {
                valueType = 20;
                break;
            }
            case 1184: {
                valueType = 21;
                break;
            }
            case 1700: {
                valueType = 13;
                break;
            }
            case 2205: {
                return "regclass";
            }
            default: {
                return "???";
            }
        }
        return Value.getTypeName(valueType);
    }

    public static int convertType(TypeInfo type) {
        switch (type.getValueType()) {
            case 8: {
                return 16;
            }
            case 2: {
                return 1043;
            }
            case 0: 
            case 3: {
                return 25;
            }
            case 1: {
                return 1042;
            }
            case 10: {
                return 21;
            }
            case 11: {
                return 23;
            }
            case 12: {
                return 20;
            }
            case 13: 
            case 16: {
                return 1700;
            }
            case 14: {
                return 700;
            }
            case 15: {
                return 701;
            }
            case 18: {
                return 1083;
            }
            case 19: {
                return 1266;
            }
            case 17: {
                return 1082;
            }
            case 20: {
                return 1114;
            }
            case 21: {
                return 1184;
            }
            case 5: 
            case 6: {
                return 17;
            }
            case 40: {
                type = (TypeInfo)type.getExtTypeInfo();
                switch (type.getValueType()) {
                    case 10: {
                        return 1005;
                    }
                    case 11: {
                        return 1007;
                    }
                    case 2: {
                        return 1015;
                    }
                }
                return 1015;
            }
        }
        return 705;
    }

    HashSet<Integer> getTypeSet() {
        return this.typeSet;
    }

    void checkType(int type) {
        if (!this.typeSet.contains(type)) {
            this.trace("Unsupported type: " + type);
        }
    }

    public String checkKeyAndGetDatabaseName(String db) {
        if (this.key == null) {
            return db;
        }
        if (this.key.equals(db)) {
            return this.keyDatabase;
        }
        throw DbException.get(28000);
    }

    @Override
    public boolean isDaemon() {
        return this.isDaemon;
    }
}

