/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.h2.util.StringUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class PageParser {
    private static final int TAB_WIDTH = 4;
    private final String page;
    private int pos;
    private final Map<String, Object> settings;
    private final int len;
    private StringBuilder result;

    private PageParser(String page, Map<String, Object> settings, int pos) {
        this.page = page;
        this.pos = pos;
        this.len = page.length();
        this.settings = settings;
        this.result = new StringBuilder(this.len);
    }

    public static String parse(String page, Map<String, Object> settings) {
        PageParser block = new PageParser(page, settings, 0);
        return block.replaceTags();
    }

    private void setError(int i) {
        Object s = this.page.substring(0, i) + "####BUG####" + this.page.substring(i);
        s = PageParser.escapeHtml((String)s);
        this.result = new StringBuilder();
        this.result.append((String)s);
    }

    private String parseBlockUntil(String end) throws ParseException {
        PageParser block = new PageParser(this.page, this.settings, this.pos);
        block.parseAll();
        if (!block.readIf(end)) {
            throw new ParseException(this.page, block.pos);
        }
        this.pos = block.pos;
        return block.result.toString();
    }

    private String replaceTags() {
        try {
            this.parseAll();
            if (this.pos != this.len) {
                this.setError(this.pos);
            }
        }
        catch (ParseException e) {
            this.setError(this.pos);
        }
        return this.result.toString();
    }

    private void parseAll() throws ParseException {
        StringBuilder buff = this.result;
        String p = this.page;
        int i = this.pos;
        while (i < this.len) {
            char c = p.charAt(i);
            switch (c) {
                case '<': {
                    if (p.charAt(i + 3) == ':' && p.charAt(i + 1) == '/') {
                        this.pos = i;
                        return;
                    }
                    if (p.charAt(i + 2) == ':') {
                        this.pos = i;
                        if (this.readIf("<c:forEach")) {
                            String var = this.readParam("var");
                            String items = this.readParam("items");
                            this.read(">");
                            int start = this.pos;
                            ArrayList list = (ArrayList)this.get(items);
                            if (list == null) {
                                this.result.append("?items?");
                                list = new ArrayList();
                            }
                            if (list.isEmpty()) {
                                this.parseBlockUntil("</c:forEach>");
                            }
                            for (Object o : list) {
                                this.settings.put(var, o);
                                this.pos = start;
                                String block = this.parseBlockUntil("</c:forEach>");
                                this.result.append(block);
                            }
                        } else if (this.readIf("<c:if")) {
                            String test = this.readParam("test");
                            int eq = test.indexOf("=='");
                            if (eq < 0) {
                                this.setError(i);
                                return;
                            }
                            String val = test.substring(eq + 3, test.length() - 1);
                            test = test.substring(0, eq);
                            String value = (String)this.get(test);
                            this.read(">");
                            String block = this.parseBlockUntil("</c:if>");
                            --this.pos;
                            if (value.equals(val)) {
                                this.result.append(block);
                            }
                        } else {
                            this.setError(i);
                            return;
                        }
                        i = this.pos;
                        break;
                    }
                    buff.append(c);
                    break;
                }
                case '$': {
                    if (p.length() > i + 1 && p.charAt(i + 1) == '{') {
                        int j = p.indexOf(125, i += 2);
                        if (j < 0) {
                            this.setError(i);
                            return;
                        }
                        String item = StringUtils.trimSubstring(p, i, j);
                        i = j;
                        String s = (String)this.get(item);
                        this.replaceTags(s);
                        break;
                    }
                    buff.append(c);
                    break;
                }
                default: {
                    buff.append(c);
                }
            }
            ++i;
        }
        this.pos = i;
    }

    private Object get(String item) {
        int dot = item.indexOf(46);
        if (dot >= 0) {
            String sub = item.substring(dot + 1);
            HashMap map = (HashMap)this.settings.get(item = item.substring(0, dot));
            if (map == null) {
                return "?" + item + "?";
            }
            return map.get(sub);
        }
        return this.settings.get(item);
    }

    private void replaceTags(String s) {
        if (s != null) {
            this.result.append(PageParser.parse(s, this.settings));
        }
    }

    private String readParam(String name) throws ParseException {
        this.read(name);
        this.read("=");
        this.read("\"");
        int start = this.pos;
        while (this.page.charAt(this.pos) != '\"') {
            ++this.pos;
        }
        int end = this.pos;
        this.read("\"");
        String s = this.page.substring(start, end);
        return PageParser.parse(s, this.settings);
    }

    private void skipSpaces() {
        while (this.page.charAt(this.pos) == ' ') {
            ++this.pos;
        }
    }

    private void read(String s) throws ParseException {
        if (!this.readIf(s)) {
            throw new ParseException(s, this.pos);
        }
    }

    private boolean readIf(String s) {
        this.skipSpaces();
        if (this.page.regionMatches(this.pos, s, 0, s.length())) {
            this.pos += s.length();
            this.skipSpaces();
            return true;
        }
        return false;
    }

    static String escapeHtmlData(String s) {
        return PageParser.escapeHtml(s, false);
    }

    public static String escapeHtml(String s) {
        return PageParser.escapeHtml(s, true);
    }

    private static String escapeHtml(String s, boolean convertBreakAndSpace) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        if (convertBreakAndSpace && length == 0) {
            return "&nbsp;";
        }
        StringBuilder builder = new StringBuilder(length);
        boolean convertSpace = true;
        int i = 0;
        while (i < length) {
            int cp = s.codePointAt(i);
            if (cp == 32 || cp == 9) {
                int j = 0;
                while (j < (cp == 32 ? 1 : 4)) {
                    if (convertSpace && convertBreakAndSpace) {
                        builder.append("&nbsp;");
                    } else {
                        builder.append(' ');
                        convertSpace = true;
                    }
                    ++j;
                }
            } else {
                convertSpace = false;
                switch (cp) {
                    case 36: {
                        builder.append("&#36;");
                        break;
                    }
                    case 60: {
                        builder.append("&lt;");
                        break;
                    }
                    case 62: {
                        builder.append("&gt;");
                        break;
                    }
                    case 38: {
                        builder.append("&amp;");
                        break;
                    }
                    case 34: {
                        builder.append("&quot;");
                        break;
                    }
                    case 39: {
                        builder.append("&#39;");
                        break;
                    }
                    case 10: {
                        if (convertBreakAndSpace) {
                            builder.append("<br />");
                            convertSpace = true;
                            break;
                        }
                        builder.append(cp);
                        break;
                    }
                    default: {
                        if (cp >= 128) {
                            builder.append("&#").append(cp).append(';');
                            break;
                        }
                        builder.append((char)cp);
                    }
                }
            }
            i += Character.charCount(cp);
        }
        return builder.toString();
    }

    static String escapeJavaScript(String s) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        if (length == 0) {
            return "";
        }
        StringBuilder buff = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    buff.append("\\\"");
                    break;
                }
                case '\'': {
                    buff.append("\\'");
                    break;
                }
                case '\\': {
                    buff.append("\\\\");
                    break;
                }
                case '\n': {
                    buff.append("\\n");
                    break;
                }
                case '\r': {
                    buff.append("\\r");
                    break;
                }
                case '\t': {
                    buff.append("\\t");
                    break;
                }
                default: {
                    buff.append(c);
                }
            }
            ++i;
        }
        return buff.toString();
    }
}

