/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.nio.channels.FileChannel;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.h2.message.DbException;
import org.h2.message.TraceSystem;
import org.h2.store.FileLock;
import org.h2.store.FileLockMethod;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FileUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class FileLister {
    private FileLister() {
    }

    public static void tryUnlockDatabase(List<String> files, String message) throws SQLException {
        for (String fileName : files) {
            Object lock;
            if (fileName.endsWith(".lock.db")) {
                lock = new FileLock(new TraceSystem(null), fileName, 1000);
                try {
                    ((FileLock)lock).lock(FileLockMethod.FILE);
                    ((FileLock)lock).unlock();
                    continue;
                }
                catch (DbException e) {
                    throw DbException.getJdbcSQLException(90133, message);
                }
            }
            if (!fileName.endsWith(".mv.db")) continue;
            try {
                lock = null;
                Object var5_7 = null;
                try (FileChannel f = FilePath.get(fileName).open("r");){
                    java.nio.channels.FileLock lock2 = f.tryLock(0L, Long.MAX_VALUE, true);
                    lock2.release();
                }
                catch (Throwable throwable) {
                    if (lock == null) {
                        lock = throwable;
                    } else if (lock != throwable) {
                        ((Throwable)lock).addSuppressed(throwable);
                    }
                    throw lock;
                }
            }
            catch (Exception e) {
                throw DbException.getJdbcSQLException(90133, e, message);
            }
        }
    }

    public static String getDir(String dir) {
        if (dir == null || dir.equals("")) {
            return ".";
        }
        return FileUtils.toRealPath(dir);
    }

    public static ArrayList<String> getDatabaseFiles(String dir, String db, boolean all) {
        ArrayList<String> files = new ArrayList<String>();
        String start = db == null ? null : db + ".";
        for (FilePath path : FilePath.get(dir).newDirectoryStream()) {
            boolean ok = false;
            String f = path.toString();
            if (f.endsWith(".mv.db")) {
                ok = true;
            } else if (all) {
                if (f.endsWith(".lock.db")) {
                    ok = true;
                } else if (f.endsWith(".temp.db")) {
                    ok = true;
                } else if (f.endsWith(".trace.db")) {
                    ok = true;
                }
            }
            if (!ok || db != null && !path.getName().startsWith(start)) continue;
            files.add(f);
        }
        return files;
    }
}

