/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Properties;
import org.h2.Driver;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.store.FileLockMethod;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FileUtils;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;
import org.h2.util.SortedProperties;
import org.h2.util.StringUtils;
import org.h2.value.Transfer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class FileLock
implements Runnable {
    private static final String MAGIC = "FileLock";
    private static final String FILE = "file";
    private static final String SOCKET = "socket";
    private static final int RANDOM_BYTES = 16;
    private static final int SLEEP_GAP = 25;
    private static final int TIME_GRANULARITY = 2000;
    private volatile String fileName;
    private volatile ServerSocket serverSocket;
    private volatile boolean locked;
    private final int sleep;
    private final Trace trace;
    private long lastWrite;
    private String method;
    private Properties properties;
    private String uniqueId;
    private Thread watchdog;

    public FileLock(TraceSystem traceSystem, String fileName, int sleep) {
        this.trace = traceSystem == null ? null : traceSystem.getTrace(4);
        this.fileName = fileName;
        this.sleep = sleep;
    }

    public synchronized void lock(FileLockMethod fileLockMethod) {
        this.checkServer();
        if (this.locked) {
            throw DbException.getInternalError("already locked");
        }
        switch (fileLockMethod) {
            case FILE: {
                this.lockFile();
                break;
            }
            case SOCKET: {
                this.lockSocket();
                break;
            }
        }
        this.locked = true;
    }

    public synchronized void unlock() {
        block17: {
            if (!this.locked) {
                return;
            }
            this.locked = false;
            try {
                if (this.watchdog != null) {
                    this.watchdog.interrupt();
                }
            }
            catch (Exception e) {
                this.trace.debug(e, "unlock");
            }
            try {
                try {
                    if (this.fileName != null && this.load().equals(this.properties)) {
                        FileUtils.delete(this.fileName);
                    }
                    if (this.serverSocket != null) {
                        this.serverSocket.close();
                    }
                }
                catch (Exception e) {
                    this.trace.debug(e, "unlock");
                    this.fileName = null;
                    this.serverSocket = null;
                    break block17;
                }
            }
            catch (Throwable throwable) {
                this.fileName = null;
                this.serverSocket = null;
                throw throwable;
            }
            this.fileName = null;
            this.serverSocket = null;
        }
        try {
            try {
                if (this.watchdog != null) {
                    this.watchdog.join();
                }
            }
            catch (Exception e) {
                this.trace.debug(e, "unlock");
                this.watchdog = null;
            }
        }
        finally {
            this.watchdog = null;
        }
    }

    public void setProperty(String key, String value) {
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, value);
        }
    }

    public Properties save() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (OutputStream out = FileUtils.newOutputStream(this.fileName, false);){
                this.properties.store(out, MAGIC);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.lastWrite = FileLock.aggressiveLastModified(this.fileName);
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("save " + String.valueOf(this.properties));
            }
            return this.properties;
        }
        catch (IOException e) {
            throw FileLock.getExceptionFatal("Could not save properties " + this.fileName, e);
        }
    }

    private static long aggressiveLastModified(String fileName) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileChannel f = FilePath.get(fileName).open("rws");){
                ByteBuffer b = ByteBuffer.wrap(new byte[1]);
                f.read(b);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return FileUtils.lastModified(fileName);
    }

    private void checkServer() {
        Properties prop = this.load();
        String server = prop.getProperty("server");
        if (server == null) {
            return;
        }
        boolean running = false;
        String id = prop.getProperty("id");
        try {
            Socket socket = NetUtils.createSocket(server, 9092, false);
            Transfer transfer = new Transfer(null, socket);
            transfer.init();
            transfer.writeInt(17);
            transfer.writeInt(21);
            transfer.writeString(null);
            transfer.writeString(null);
            transfer.writeString(id);
            transfer.writeInt(14);
            transfer.flush();
            int state = transfer.readInt();
            if (state == 1) {
                running = true;
            }
            transfer.close();
            socket.close();
        }
        catch (IOException e) {
            return;
        }
        if (running) {
            DbException e = DbException.get(90020, "Server is running");
            throw e.addSQL(server + "/" + id);
        }
    }

    public Properties load() {
        IOException lastException = null;
        int i = 0;
        while (i < 5) {
            try {
                SortedProperties p2 = SortedProperties.loadProperties(this.fileName);
                if (this.trace.isDebugEnabled()) {
                    this.trace.debug("load " + String.valueOf(p2));
                }
                return p2;
            }
            catch (IOException e) {
                lastException = e;
                ++i;
            }
        }
        throw FileLock.getExceptionFatal("Could not load properties " + this.fileName, lastException);
    }

    private void waitUntilOld() {
        int i = 0;
        while (i < 160) {
            long last = FileLock.aggressiveLastModified(this.fileName);
            long dist = System.currentTimeMillis() - last;
            if (dist < -2000L) {
                try {
                    Thread.sleep(2L * (long)this.sleep);
                }
                catch (Exception e) {
                    this.trace.debug(e, "sleep");
                }
                return;
            }
            if (dist > 2000L) {
                return;
            }
            try {
                Thread.sleep(25L);
            }
            catch (Exception e) {
                this.trace.debug(e, "sleep");
            }
            ++i;
        }
        throw FileLock.getExceptionFatal("Lock file recently modified", null);
    }

    private void setUniqueId() {
        byte[] bytes = MathUtils.secureRandomBytes(16);
        String random = StringUtils.convertBytesToHex(bytes);
        this.uniqueId = Long.toHexString(System.currentTimeMillis()) + random;
        this.properties.setProperty("id", this.uniqueId);
    }

    private void lockFile() {
        this.method = FILE;
        this.properties = new SortedProperties();
        this.properties.setProperty("method", String.valueOf(this.method));
        this.setUniqueId();
        FileUtils.createDirectories(FileUtils.getParent(this.fileName));
        if (!FileUtils.createFile(this.fileName)) {
            this.waitUntilOld();
            String m2 = this.load().getProperty("method", FILE);
            if (!m2.equals(FILE)) {
                throw FileLock.getExceptionFatal("Unsupported lock method " + m2, null);
            }
            this.save();
            FileLock.sleep(2 * this.sleep);
            if (!this.load().equals(this.properties)) {
                throw this.getExceptionAlreadyInUse("Locked by another process: " + this.fileName);
            }
            FileUtils.delete(this.fileName);
            if (!FileUtils.createFile(this.fileName)) {
                throw FileLock.getExceptionFatal("Another process was faster", null);
            }
        }
        this.save();
        FileLock.sleep(25);
        if (!this.load().equals(this.properties)) {
            this.fileName = null;
            throw FileLock.getExceptionFatal("Concurrent update", null);
        }
        this.locked = true;
        this.watchdog = new Thread((Runnable)this, "H2 File Lock Watchdog " + this.fileName);
        Driver.setThreadContextClassLoader(this.watchdog);
        this.watchdog.setDaemon(true);
        this.watchdog.setPriority(9);
        this.watchdog.start();
    }

    private void lockSocket() {
        this.method = SOCKET;
        this.properties = new SortedProperties();
        this.properties.setProperty("method", String.valueOf(this.method));
        this.setUniqueId();
        String ipAddress = NetUtils.getLocalAddress();
        FileUtils.createDirectories(FileUtils.getParent(this.fileName));
        if (!FileUtils.createFile(this.fileName)) {
            InetAddress address;
            this.waitUntilOld();
            long read = FileLock.aggressiveLastModified(this.fileName);
            Properties p2 = this.load();
            String m2 = p2.getProperty("method", SOCKET);
            if (m2.equals(FILE)) {
                this.lockFile();
                return;
            }
            if (!m2.equals(SOCKET)) {
                throw FileLock.getExceptionFatal("Unsupported lock method " + m2, null);
            }
            String ip = p2.getProperty("ipAddress", ipAddress);
            if (!ipAddress.equals(ip)) {
                throw this.getExceptionAlreadyInUse("Locked by another computer: " + ip);
            }
            String port = p2.getProperty("port", "0");
            int portId = Integer.parseInt(port);
            try {
                address = InetAddress.getByName(ip);
            }
            catch (UnknownHostException e) {
                throw FileLock.getExceptionFatal("Unknown host " + ip, e);
            }
            int i = 0;
            while (i < 3) {
                try {
                    Socket s = new Socket(address, portId);
                    s.close();
                    throw this.getExceptionAlreadyInUse("Locked by another process");
                }
                catch (BindException e) {
                    throw FileLock.getExceptionFatal("Bind Exception", null);
                }
                catch (ConnectException e) {
                    this.trace.debug(e, "socket not connected to port " + port);
                }
                catch (IOException e) {
                    throw FileLock.getExceptionFatal("IOException", null);
                }
                ++i;
            }
            if (read != FileLock.aggressiveLastModified(this.fileName)) {
                throw FileLock.getExceptionFatal("Concurrent update", null);
            }
            FileUtils.delete(this.fileName);
            if (!FileUtils.createFile(this.fileName)) {
                throw FileLock.getExceptionFatal("Another process was faster", null);
            }
        }
        try {
            this.serverSocket = NetUtils.createServerSocket(0, false);
            int port = this.serverSocket.getLocalPort();
            this.properties.setProperty("ipAddress", ipAddress);
            this.properties.setProperty("port", Integer.toString(port));
        }
        catch (Exception e) {
            this.trace.debug(e, "lock");
            this.serverSocket = null;
            this.lockFile();
            return;
        }
        this.save();
        this.locked = true;
        this.watchdog = new Thread((Runnable)this, "H2 File Lock Watchdog (Socket) " + this.fileName);
        this.watchdog.setDaemon(true);
        this.watchdog.start();
    }

    private static void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            throw FileLock.getExceptionFatal("Sleep interrupted", e);
        }
    }

    private static DbException getExceptionFatal(String reason, Throwable t) {
        return DbException.get(8000, t, reason);
    }

    private DbException getExceptionAlreadyInUse(String reason) {
        DbException e = DbException.get(90020, reason);
        if (this.fileName != null) {
            try {
                Properties prop = this.load();
                String server = prop.getProperty("server");
                if (server != null) {
                    String serverId = server + "/" + prop.getProperty("id");
                    e = e.addSQL(serverId);
                }
            }
            catch (DbException dbException) {
                // empty catch block
            }
        }
        return e;
    }

    public static FileLockMethod getFileLockMethod(String method) {
        if (method == null || method.equalsIgnoreCase("FILE")) {
            return FileLockMethod.FILE;
        }
        if (method.equalsIgnoreCase("NO")) {
            return FileLockMethod.NO;
        }
        if (method.equalsIgnoreCase("SOCKET")) {
            return FileLockMethod.SOCKET;
        }
        if (method.equalsIgnoreCase("FS")) {
            return FileLockMethod.FS;
        }
        throw DbException.get(90060, method);
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block10: {
            ServerSocket local;
            try {
                while (this.locked && this.fileName != null) {
                    try {
                        if (!FileUtils.exists(this.fileName) || FileLock.aggressiveLastModified(this.fileName) != this.lastWrite) {
                            this.save();
                        }
                        Thread.sleep(this.sleep);
                    }
                    catch (InterruptedException | NullPointerException | OutOfMemoryError throwable) {
                    }
                    catch (Exception e) {
                        this.trace.debug(e, "watchdog");
                    }
                }
            }
            catch (Exception e) {
                this.trace.debug(e, "watchdog");
                break block10;
            }
            while ((local = this.serverSocket) != null) {
                try {
                    this.trace.debug("watchdog accept");
                    Socket s = local.accept();
                    s.close();
                }
                catch (Exception e) {
                    this.trace.debug(e, "watchdog");
                }
            }
        }
        this.trace.debug("watchdog end");
    }
}

