/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.InputStream;
import org.h2.engine.SessionRemote;
import org.h2.message.DbException;
import org.h2.mvstore.DataUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class LobStorageRemoteInputStream
extends InputStream {
    private final SessionRemote sessionRemote;
    private final long lobId;
    private final byte[] hmac;
    private long pos;

    public LobStorageRemoteInputStream(SessionRemote handler, long lobId, byte[] hmac) {
        this.sessionRemote = handler;
        this.lobId = lobId;
        this.hmac = hmac;
    }

    @Override
    public int read() throws IOException {
        byte[] buff = new byte[1];
        int len = this.read(buff, 0, 1);
        return len < 0 ? len : buff[0] & 0xFF;
    }

    @Override
    public int read(byte[] buff) throws IOException {
        return this.read(buff, 0, buff.length);
    }

    @Override
    public int read(byte[] buff, int off, int length) throws IOException {
        assert (length >= 0);
        if (length == 0) {
            return 0;
        }
        try {
            length = this.sessionRemote.readLob(this.lobId, this.hmac, this.pos, buff, off, length);
        }
        catch (DbException e) {
            throw DataUtils.convertToIOException(e);
        }
        if (length == 0) {
            return -1;
        }
        this.pos += (long)length;
        return length;
    }
}

