/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.HashSet;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Database;
import org.h2.message.DbException;
import org.h2.store.fs.FileUtils;
import org.h2.store.fs.Recorder;
import org.h2.store.fs.rec.FilePathRec;
import org.h2.tools.Recover;
import org.h2.util.IOUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class RecoverTester
implements Recorder {
    private static final RecoverTester instance = new RecoverTester();
    private String testDatabase = "memFS:reopen";
    private int writeCount = Utils.getProperty("h2.recoverTestOffset", 0);
    private int testEvery = Utils.getProperty("h2.recoverTest", 64);
    private final long maxFileSize = (long)Utils.getProperty("h2.recoverTestMaxFileSize", Integer.MAX_VALUE) * 1024L * 1024L;
    private int verifyCount;
    private final HashSet<String> knownErrors = new HashSet();
    private volatile boolean testing;

    public static synchronized void init(String recoverTest) {
        if (StringUtils.isNumber(recoverTest)) {
            instance.setTestEvery(Integer.parseInt(recoverTest));
        }
        FilePathRec.setRecorder(instance);
    }

    @Override
    public void log(int op, String fileName, byte[] data, long x) {
        if (op != 8 && op != 7) {
            return;
        }
        if (!fileName.endsWith(".mv.db")) {
            return;
        }
        ++this.writeCount;
        if (this.writeCount % this.testEvery != 0) {
            return;
        }
        if (FileUtils.size(fileName) > this.maxFileSize) {
            return;
        }
        if (this.testing) {
            return;
        }
        this.testing = true;
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new OutputStreamWriter(FileUtils.newOutputStream(fileName + ".log", true)));
                this.testDatabase(fileName, out);
            }
            catch (IOException e) {
                throw DbException.convertIOException(e, null);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeSilently(out);
            this.testing = false;
            throw throwable;
        }
        IOUtils.closeSilently(out);
        this.testing = false;
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void testDatabase(String fileName, PrintWriter out) {
        block18: {
            out.println("+ write #" + this.writeCount + " verify #" + this.verifyCount);
            try {
                IOUtils.copyFiles(fileName, this.testDatabase + ".mv.db");
                ++this.verifyCount;
                ci = new ConnectionInfo("jdbc:h2:" + this.testDatabase + ";FILE_LOCK=NO;TRACE_LEVEL_FILE=0", null, "", "");
                database = new Database(ci, null);
                sysSession = database.getSystemSession();
                sysSession.prepare("script to '" + this.testDatabase + ".sql'").query(0L);
                sysSession.prepare("shutdown immediately").update();
                database.removeSession(null);
                return;
            }
            catch (DbException e) {
                e2 = DbException.toSQLException(e);
                errorCode = e2.getErrorCode();
                if (errorCode == 28000) {
                    return;
                }
                if (errorCode == 90049) {
                    return;
                }
                e.printStackTrace(System.out);
            }
            catch (Exception e) {
                errorCode = 0;
                if (e instanceof SQLException) {
                    errorCode = ((SQLException)e).getErrorCode();
                }
                if (errorCode == 28000) {
                    return;
                }
                if (errorCode == 90049) {
                    return;
                }
                e.printStackTrace(System.out);
            }
            out.println("begin ------------------------------ " + this.writeCount);
            try {
                Recover.execute(fileName.substring(0, fileName.lastIndexOf(47)), null);
            }
            catch (SQLException e) {
                // empty catch block
            }
            this.testDatabase = String.valueOf(this.testDatabase) + "X";
            try {
                IOUtils.copyFiles(fileName, this.testDatabase + ".mv.db");
                ci = new ConnectionInfo("jdbc:h2:" + this.testDatabase + ";FILE_LOCK=NO", null, null, null);
                database = new Database(ci, null);
                database.removeSession(null);
                break block18;
            }
            catch (Exception e) {
                errorCode = 0;
                if (e instanceof DbException) {
                    e = ((DbException)e).getSQLException();
                    errorCode = e.getErrorCode();
                }
                if (errorCode == 28000) {
                    return;
                }
                if (errorCode == 90049) {
                    return;
                }
                buff = new StringBuilder();
                list = e.getStackTrace();
                i = 0;
                ** while (i < 10 && i < list.length)
            }
lbl-1000:
            // 1 sources

            {
                buff.append(list[i].toString()).append('\n');
                ++i;
                continue;
            }
lbl62:
            // 1 sources

            s = buff.toString();
            if (!this.knownErrors.contains(s)) {
                out.println(this.writeCount + " code: " + errorCode + " " + e.toString());
                e.printStackTrace(System.out);
                this.knownErrors.add(s);
            } else {
                out.println(this.writeCount + " code: " + errorCode);
            }
        }
    }

    public void setTestEvery(int testEvery) {
        this.testEvery = testEvery;
    }
}

