/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.h2.store.fs.FileBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class FileBaseDefault
extends FileBase {
    private long position = 0L;

    @Override
    public final synchronized long position() throws IOException {
        return this.position;
    }

    @Override
    public final synchronized FileChannel position(long newPosition) throws IOException {
        if (newPosition < 0L) {
            throw new IllegalArgumentException();
        }
        this.position = newPosition;
        return this;
    }

    @Override
    public final synchronized int read(ByteBuffer dst) throws IOException {
        int read = this.read(dst, this.position);
        if (read > 0) {
            this.position += (long)read;
        }
        return read;
    }

    @Override
    public final synchronized int write(ByteBuffer src) throws IOException {
        int written = this.write(src, this.position);
        if (written > 0) {
            this.position += (long)written;
        }
        return written;
    }

    @Override
    public final synchronized FileChannel truncate(long newLength) throws IOException {
        this.implTruncate(newLength);
        if (newLength < this.position) {
            this.position = newLength;
        }
        return this;
    }

    protected abstract void implTruncate(long var1) throws IOException;
}

