/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs.disk;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class FilePathDisk
extends FilePath {
    private static final String CLASSPATH_PREFIX = "classpath:";

    @Override
    public FilePathDisk getPath(String path) {
        FilePathDisk p = new FilePathDisk();
        p.name = FilePathDisk.translateFileName(path);
        return p;
    }

    @Override
    public long size() {
        if (this.name.startsWith(CLASSPATH_PREFIX)) {
            URL url;
            Object path = this.name.substring(CLASSPATH_PREFIX.length());
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            if ((url = this.getClass().getResource((String)path)) == null) {
                return 0L;
            }
            try {
                URI uri = url.toURI();
                if ("file".equals(url.getProtocol())) {
                    return Files.size(Paths.get(uri));
                }
                try {
                    FileSystems.getFileSystem(uri);
                    return Files.size(Paths.get(uri));
                }
                catch (FileSystemNotFoundException e) {
                    HashMap<String, String> env = new HashMap<String, String>();
                    env.put("create", "true");
                    Throwable throwable = null;
                    Object var7_10 = null;
                    try (FileSystem fs = FileSystems.newFileSystem(uri, env);){
                        return Files.size(Paths.get(uri));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            }
            catch (Exception ex) {
                return 0L;
            }
        }
        try {
            return Files.size(Paths.get(this.name, new String[0]));
        }
        catch (IOException e) {
            return 0L;
        }
    }

    protected static String translateFileName(String fileName) {
        if ((fileName = fileName.replace('\\', '/')).startsWith("file:")) {
            fileName = fileName.substring(5);
        } else if (fileName.startsWith("nio:")) {
            fileName = fileName.substring(4);
        }
        return FilePathDisk.expandUserHomeDirectory(fileName);
    }

    public static String expandUserHomeDirectory(String fileName) {
        if (((String)fileName).startsWith("~") && (((String)fileName).length() == 1 || ((String)fileName).startsWith("~/"))) {
            String userDir = SysProperties.USER_HOME;
            fileName = userDir + ((String)fileName).substring(1);
        }
        return fileName;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void moveTo(FilePath newName, boolean atomicReplace) {
        block14: {
            oldFile = Paths.get(this.name, new String[0]);
            newFile = Paths.get(newName.name, new String[0]);
            if (!Files.exists(oldFile, new LinkOption[0])) {
                throw DbException.get(90024, new String[]{this.name + " (not found)", newName.name});
            }
            if (atomicReplace) {
                try {
                    Files.move(oldFile, newFile, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE});
                    return;
                }
                catch (AtomicMoveNotSupportedException var5_5) {
                }
                catch (IOException ex) {
                    throw DbException.get(90024, ex, new String[]{this.name, newName.name});
                }
            }
            if (atomicReplace) {
                v0 = new CopyOption[1];
                v1 = v0;
                v0[0] = StandardCopyOption.REPLACE_EXISTING;
            } else {
                v1 = new CopyOption[]{};
            }
            copyOptions = v1;
            try {
                Files.move(oldFile, newFile, copyOptions);
                break block14;
            }
            catch (FileAlreadyExistsException ex) {
                throw DbException.get(90024, new String[]{this.name, String.valueOf(newName) + " (exists)"});
            }
            catch (IOException ex) {
                cause = ex;
                i = 0;
                ** while (i < SysProperties.MAX_FILE_RETRY)
            }
lbl-1000:
            // 1 sources

            {
                IOUtils.trace("rename", this.name + " >" + String.valueOf(newName), null);
                try {
                    Files.move(oldFile, newFile, copyOptions);
                    return;
                }
                catch (FileAlreadyExistsException ex2) {
                    throw DbException.get(90024, new String[]{this.name, String.valueOf(newName) + " (exists)"});
                }
                catch (IOException ex2) {
                    cause = ex;
                    FilePathDisk.wait(i);
                    ++i;
                }
                continue;
            }
lbl43:
            // 1 sources

            throw DbException.get(90024, cause, new String[]{this.name, newName.name});
        }
    }

    private static void wait(int i) {
        if (i == 8) {
            System.gc();
        }
        try {
            long sleep = Math.min(256, i * i);
            Thread.sleep(sleep);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean createFile() {
        Path file = Paths.get(this.name, new String[0]);
        int i = 0;
        while (i < SysProperties.MAX_FILE_RETRY) {
            try {
                Files.createFile(file, new FileAttribute[0]);
                return true;
            }
            catch (FileAlreadyExistsException e) {
                return false;
            }
            catch (IOException e) {
                FilePathDisk.wait(i);
                ++i;
            }
        }
        return false;
    }

    @Override
    public boolean exists() {
        return Files.exists(Paths.get(this.name, new String[0]), new LinkOption[0]);
    }

    @Override
    public void delete() {
        Path file = Paths.get(this.name, new String[0]);
        IOException cause = null;
        int i = 0;
        while (i < SysProperties.MAX_FILE_RETRY) {
            IOUtils.trace("delete", this.name, null);
            try {
                Files.deleteIfExists(file);
                return;
            }
            catch (DirectoryNotEmptyException e) {
                throw DbException.get(90025, e, this.name);
            }
            catch (AccessDeniedException e) {
                try {
                    FileStore fileStore = Files.getFileStore(file);
                    if (!fileStore.supportsFileAttributeView(PosixFileAttributeView.class) && fileStore.supportsFileAttributeView(DosFileAttributeView.class)) {
                        Files.setAttribute(file, "dos:readonly", false, new LinkOption[0]);
                        Files.delete(file);
                    }
                }
                catch (IOException ioe) {
                    cause = ioe;
                }
            }
            catch (IOException e) {
                cause = e;
            }
            FilePathDisk.wait(i);
            ++i;
        }
        throw DbException.get(90025, cause, this.name);
    }

    @Override
    public List<FilePath> newDirectoryStream() {
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (Stream<Path> files = Files.list(FilePathDisk.toRealPath(Paths.get(this.name, new String[0])));){
                return files.collect(ArrayList::new, (t, u) -> {
                    boolean bl = t.add(this.getPath(u.toString()));
                }, ArrayList::addAll);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NoSuchFileException e) {
            return Collections.emptyList();
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, this.name);
        }
    }

    @Override
    public boolean canWrite() {
        try {
            return Files.isWritable(Paths.get(this.name, new String[0]));
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean setReadOnly() {
        Path f = Paths.get(this.name, new String[0]);
        try {
            FileStore fileStore = Files.getFileStore(f);
            if (fileStore.supportsFileAttributeView(PosixFileAttributeView.class)) {
                HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
                for (PosixFilePermission p : Files.getPosixFilePermissions(f, new LinkOption[0])) {
                    switch (p) {
                        case OWNER_WRITE: 
                        case GROUP_WRITE: 
                        case OTHERS_WRITE: {
                            break;
                        }
                        default: {
                            permissions.add(p);
                        }
                    }
                }
                Files.setPosixFilePermissions(f, permissions);
            } else if (fileStore.supportsFileAttributeView(DosFileAttributeView.class)) {
                Files.setAttribute(f, "dos:readonly", true, new LinkOption[0]);
            } else {
                return false;
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public FilePathDisk toRealPath() {
        return this.getPath(FilePathDisk.toRealPath(Paths.get(this.name, new String[0])).toString());
    }

    private static Path toRealPath(Path path) {
        try {
            path = path.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            path = FilePathDisk.parentToRealPath(path.toAbsolutePath().normalize());
        }
        return path;
    }

    private static Path parentToRealPath(Path path) {
        Path parent = path.getParent();
        if (parent == null) {
            return path;
        }
        try {
            parent = parent.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            parent = FilePathDisk.parentToRealPath(parent);
        }
        return parent.resolve(path.getFileName());
    }

    @Override
    public FilePath getParent() {
        Path p = Paths.get(this.name, new String[0]).getParent();
        return p == null ? null : this.getPath(p.toString());
    }

    @Override
    public boolean isDirectory() {
        return Files.isDirectory(Paths.get(this.name, new String[0]), new LinkOption[0]);
    }

    @Override
    public boolean isRegularFile() {
        return Files.isRegularFile(Paths.get(this.name, new String[0]), new LinkOption[0]);
    }

    @Override
    public boolean isAbsolute() {
        return Paths.get(this.name, new String[0]).isAbsolute();
    }

    @Override
    public long lastModified() {
        try {
            return Files.getLastModifiedTime(Paths.get(this.name, new String[0]), new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void createDirectory() {
        block8: {
            dir = Paths.get(this.name, new String[0]);
            try {
                Files.createDirectory(dir, new FileAttribute[0]);
                break block8;
            }
            catch (FileAlreadyExistsException e) {
                throw DbException.get(90062, this.name + " (a file with this name already exists)");
            }
            catch (IOException e) {
                cause = e;
                i = 0;
                ** while (i < SysProperties.MAX_FILE_RETRY)
            }
lbl-1000:
            // 1 sources

            {
                if (Files.isDirectory(dir, new LinkOption[0])) {
                    return;
                }
                try {
                    Files.createDirectory(dir, new FileAttribute[0]);
                }
                catch (FileAlreadyExistsException ex) {
                    throw DbException.get(90062, this.name + " (a file with this name already exists)");
                }
                catch (IOException ex) {
                    cause = ex;
                }
                FilePathDisk.wait(i);
                ++i;
                continue;
            }
lbl25:
            // 1 sources

            throw DbException.get(90062, cause, new String[]{this.name});
        }
    }

    @Override
    public OutputStream newOutputStream(boolean append) throws IOException {
        OpenOption[] openOptionArray;
        Path file = Paths.get(this.name, new String[0]);
        if (append) {
            OpenOption[] openOptionArray2 = new OpenOption[2];
            openOptionArray2[0] = StandardOpenOption.CREATE;
            openOptionArray = openOptionArray2;
            openOptionArray2[1] = StandardOpenOption.APPEND;
        } else {
            openOptionArray = new OpenOption[]{};
        }
        OpenOption[] options = openOptionArray;
        try {
            Path parent = file.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            OutputStream out = Files.newOutputStream(file, options);
            IOUtils.trace("openFileOutputStream", this.name, out);
            return out;
        }
        catch (IOException e) {
            FilePathDisk.freeMemoryAndFinalize();
            return Files.newOutputStream(file, options);
        }
    }

    @Override
    public InputStream newInputStream() throws IOException {
        if (this.name.matches("[a-zA-Z]{2,19}:.*")) {
            if (this.name.startsWith(CLASSPATH_PREFIX)) {
                InputStream in;
                Object fileName = this.name.substring(CLASSPATH_PREFIX.length());
                if (!((String)fileName).startsWith("/")) {
                    fileName = "/" + (String)fileName;
                }
                if ((in = this.getClass().getResourceAsStream((String)fileName)) == null) {
                    in = Thread.currentThread().getContextClassLoader().getResourceAsStream(((String)fileName).substring(1));
                }
                if (in == null) {
                    throw new FileNotFoundException("resource " + (String)fileName);
                }
                return in;
            }
            URL url = new URL(this.name);
            return url.openStream();
        }
        InputStream in = Files.newInputStream(Paths.get(this.name, new String[0]), new OpenOption[0]);
        IOUtils.trace("openFileInputStream", this.name, in);
        return in;
    }

    static void freeMemoryAndFinalize() {
        IOUtils.trace("freeMemoryAndFinalize", null, null);
        Runtime rt = Runtime.getRuntime();
        long mem = rt.freeMemory();
        int i = 0;
        while (i < 16) {
            rt.gc();
            long now = rt.freeMemory();
            rt.runFinalization();
            if (now == mem) break;
            mem = now;
            ++i;
        }
    }

    @Override
    public FileChannel open(String mode) throws IOException {
        FileChannel f = FileChannel.open(Paths.get(this.name, new String[0]), FileUtils.modeToOptions(mode), FileUtils.NO_ATTRIBUTES);
        IOUtils.trace("open", this.name, f);
        return f;
    }

    @Override
    public String getScheme() {
        return "file";
    }

    @Override
    public FilePath createTempFile(String suffix, boolean inTempDir) throws IOException {
        Path file = Paths.get(this.name + ".", new String[0]).toAbsolutePath();
        String prefix = file.getFileName().toString();
        if (inTempDir) {
            Path tempDir = Paths.get(System.getProperty("java.io.tmpdir", "."), new String[0]);
            if (!Files.isDirectory(tempDir, new LinkOption[0])) {
                Files.createDirectories(tempDir, new FileAttribute[0]);
            }
            file = Files.createTempFile(prefix, suffix, new FileAttribute[0]);
        } else {
            Path dir = file.getParent();
            Files.createDirectories(dir, new FileAttribute[0]);
            file = Files.createTempFile(dir, prefix, suffix, new FileAttribute[0]);
        }
        return FilePathDisk.get(file.toString());
    }
}

