/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs.niomapped;

import java.io.EOFException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import java.nio.file.Paths;
import org.h2.engine.SysProperties;
import org.h2.store.fs.FileBaseDefault;
import org.h2.store.fs.FileUtils;
import org.h2.util.MemoryUnmapper;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class FileNioMapped
extends FileBaseDefault {
    private static final int GC_TIMEOUT_MS = 10000;
    private final String name;
    private final FileChannel.MapMode mode;
    private FileChannel channel;
    private MappedByteBuffer mapped;
    private long fileLength;

    FileNioMapped(String fileName, String mode) throws IOException {
        this.mode = "r".equals(mode) ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
        this.name = fileName;
        this.channel = FileChannel.open(Paths.get(fileName, new String[0]), FileUtils.modeToOptions(mode), FileUtils.NO_ATTRIBUTES);
        this.reMap();
    }

    private void unMap() throws IOException {
        if (this.mapped == null) {
            return;
        }
        this.mapped.force();
        if (SysProperties.NIO_CLEANER_HACK && MemoryUnmapper.unmap(this.mapped)) {
            this.mapped = null;
            return;
        }
        WeakReference<MappedByteBuffer> bufferWeakRef = new WeakReference<MappedByteBuffer>(this.mapped);
        this.mapped = null;
        long stopAt = System.nanoTime() + 10000000000L;
        while (bufferWeakRef.get() != null) {
            if (System.nanoTime() - stopAt > 0L) {
                throw new IOException("Timeout (10000 ms) reached while trying to GC mapped buffer");
            }
            System.gc();
            Thread.yield();
        }
    }

    private void reMap() throws IOException {
        if (this.mapped != null) {
            this.unMap();
        }
        this.fileLength = this.channel.size();
        FileNioMapped.checkFileSizeLimit(this.fileLength);
        this.mapped = this.channel.map(this.mode, 0L, this.fileLength);
        int limit = this.mapped.limit();
        int capacity = this.mapped.capacity();
        if ((long)limit < this.fileLength || (long)capacity < this.fileLength) {
            throw new IOException("Unable to map: length=" + limit + " capacity=" + capacity + " length=" + this.fileLength);
        }
        if (SysProperties.NIO_LOAD_MAPPED) {
            this.mapped.load();
        }
    }

    private static void checkFileSizeLimit(long length) throws IOException {
        if (length > Integer.MAX_VALUE) {
            throw new IOException("File over 2GB is not supported yet when using this file system");
        }
    }

    @Override
    public void implCloseChannel() throws IOException {
        if (this.channel != null) {
            this.unMap();
            this.channel.close();
            this.channel = null;
        }
    }

    public String toString() {
        return "nioMapped:" + this.name;
    }

    @Override
    public synchronized long size() throws IOException {
        return this.fileLength;
    }

    @Override
    public synchronized int read(ByteBuffer dst, long pos) throws IOException {
        int len;
        block5: {
            block4: {
                FileNioMapped.checkFileSizeLimit(pos);
                len = dst.remaining();
                if (len != 0) break block4;
                return 0;
            }
            len = (int)Math.min((long)len, this.fileLength - pos);
            if (len > 0) break block5;
            return -1;
        }
        try {
            this.mapped.position((int)pos);
            this.mapped.get(dst.array(), dst.arrayOffset() + dst.position(), len);
            dst.position(dst.position() + len);
            pos += (long)len;
            return len;
        }
        catch (IllegalArgumentException | BufferUnderflowException e) {
            EOFException e2 = new EOFException("EOF");
            e2.initCause(e);
            throw e2;
        }
    }

    @Override
    protected void implTruncate(long newLength) throws IOException {
        if (this.mode == FileChannel.MapMode.READ_ONLY) {
            throw new NonWritableChannelException();
        }
        if (newLength < this.size()) {
            this.setFileLength(newLength);
        }
    }

    public synchronized void setFileLength(long newLength) throws IOException {
        if (this.mode == FileChannel.MapMode.READ_ONLY) {
            throw new NonWritableChannelException();
        }
        FileNioMapped.checkFileSizeLimit(newLength);
        this.unMap();
        int i = 0;
        while (true) {
            try {
                long length = this.channel.size();
                if (length >= newLength) {
                    this.channel.truncate(newLength);
                    break;
                }
                this.channel.write(ByteBuffer.wrap(new byte[1]), newLength - 1L);
            }
            catch (IOException e) {
                if (i > 16 || !e.toString().contains("user-mapped section open")) {
                    throw e;
                }
                System.gc();
                ++i;
                continue;
            }
            break;
        }
        this.reMap();
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.mapped.force();
        this.channel.force(metaData);
    }

    @Override
    public synchronized int write(ByteBuffer src, long position) throws IOException {
        FileNioMapped.checkFileSizeLimit(position);
        int len = src.remaining();
        if ((long)this.mapped.capacity() < position + (long)len) {
            this.setFileLength(position + (long)len);
        }
        this.mapped.position((int)position);
        this.mapped.put(src);
        return len;
    }

    @Override
    public synchronized FileLock tryLock(long position, long size, boolean shared) throws IOException {
        return this.channel.tryLock(position, size, shared);
    }
}

