/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs.split;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FilePathWrapper;
import org.h2.store.fs.split.FileSplit;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class FilePathSplit
extends FilePathWrapper {
    private static final String PART_SUFFIX = ".part";

    @Override
    protected String getPrefix() {
        return this.getScheme() + ":" + this.parse(this.name)[0] + ":";
    }

    @Override
    public FilePath unwrap(String fileName) {
        return FilePath.get(this.parse(fileName)[1]);
    }

    @Override
    public boolean setReadOnly() {
        FilePath f;
        boolean result = false;
        int i = 0;
        while ((f = this.getBase(i)).exists()) {
            result = f.setReadOnly();
            ++i;
        }
        return result;
    }

    @Override
    public void delete() {
        FilePath f;
        int i = 0;
        while ((f = this.getBase(i)).exists()) {
            f.delete();
            ++i;
        }
    }

    @Override
    public long lastModified() {
        FilePath f;
        long lastModified = 0L;
        int i = 0;
        while ((f = this.getBase(i)).exists()) {
            long l = f.lastModified();
            lastModified = Math.max(lastModified, l);
            ++i;
        }
        return lastModified;
    }

    @Override
    public long size() {
        FilePath f;
        long length = 0L;
        int i = 0;
        while ((f = this.getBase(i)).exists()) {
            length += f.size();
            ++i;
        }
        return length;
    }

    public ArrayList<FilePath> newDirectoryStream() {
        List<FilePath> list = this.getBase().newDirectoryStream();
        ArrayList<FilePath> newList = new ArrayList<FilePath>();
        for (FilePath f : list) {
            if (f.getName().endsWith(PART_SUFFIX)) continue;
            newList.add(this.wrap(f));
        }
        return newList;
    }

    @Override
    public InputStream newInputStream() throws IOException {
        FilePath f;
        InputStream input = this.getBase().newInputStream();
        int i = 1;
        while ((f = this.getBase(i)).exists()) {
            InputStream i2 = f.newInputStream();
            input = new SequenceInputStream(input, i2);
            ++i;
        }
        return input;
    }

    @Override
    public FileChannel open(String mode) throws IOException {
        long maxLength;
        FilePath f;
        ArrayList<FileChannel> list = new ArrayList<FileChannel>();
        list.add(this.getBase().open(mode));
        int i = 1;
        while ((f = this.getBase(i)).exists()) {
            list.add(f.open(mode));
            ++i;
        }
        FileChannel[] array = list.toArray(new FileChannel[0]);
        long length = maxLength = array[0].size();
        if (array.length == 1) {
            long defaultMaxLength = this.getDefaultMaxLength();
            if (maxLength < defaultMaxLength) {
                maxLength = defaultMaxLength;
            }
        } else {
            if (maxLength == 0L) {
                this.closeAndThrow(0, array, array[0], maxLength);
            }
            int i2 = 1;
            while (i2 < array.length - 1) {
                FileChannel c = array[i2];
                long l = c.size();
                length += l;
                if (l != maxLength) {
                    this.closeAndThrow(i2, array, c, maxLength);
                }
                ++i2;
            }
            FileChannel c = array[array.length - 1];
            long l = c.size();
            length += l;
            if (l > maxLength) {
                this.closeAndThrow(array.length - 1, array, c, maxLength);
            }
        }
        return new FileSplit(this, mode, array, length, maxLength);
    }

    private long getDefaultMaxLength() {
        return 1L << Integer.decode(this.parse(this.name)[0]);
    }

    private void closeAndThrow(int id, FileChannel[] array, FileChannel o, long maxLength) throws IOException {
        String message = "Expected file length: " + maxLength + " got: " + o.size() + " for " + this.getName(id);
        FileChannel[] fileChannelArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            FileChannel f = fileChannelArray[n2];
            f.close();
            ++n2;
        }
        throw new IOException(message);
    }

    @Override
    public OutputStream newOutputStream(boolean append) throws IOException {
        return FilePathSplit.newFileChannelOutputStream(this.open("rw"), append);
    }

    @Override
    public void moveTo(FilePath path, boolean atomicReplace) {
        FilePathSplit newName = (FilePathSplit)path;
        int i = 0;
        while (true) {
            FilePath o;
            if ((o = this.getBase(i)).exists()) {
                o.moveTo(newName.getBase(i), atomicReplace);
            } else {
                if (!newName.getBase(i).exists()) break;
                newName.getBase(i).delete();
            }
            ++i;
        }
    }

    private String[] parse(String fileName) {
        String size;
        if (!fileName.startsWith(this.getScheme())) {
            throw DbException.getInternalError(fileName + " doesn't start with " + this.getScheme());
        }
        if ((fileName = fileName.substring(this.getScheme().length() + 1)).length() > 0 && Character.isDigit(fileName.charAt(0))) {
            int idx = fileName.indexOf(58);
            size = fileName.substring(0, idx);
            try {
                fileName = fileName.substring(idx + 1);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            size = Long.toString(SysProperties.SPLIT_FILE_SIZE_SHIFT);
        }
        return new String[]{size, fileName};
    }

    FilePath getBase(int id) {
        return FilePath.get(this.getName(id));
    }

    private String getName(int id) {
        return id > 0 ? this.getBase().name + "." + id + PART_SUFFIX : this.getBase().name;
    }

    @Override
    public String getScheme() {
        return "split";
    }
}

