/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import org.h2.command.QueryScope;
import org.h2.command.query.Query;
import org.h2.engine.SessionLocal;
import org.h2.expression.Parameter;
import org.h2.index.QueryExpressionIndex;
import org.h2.index.RecursiveIndex;
import org.h2.index.RegularQueryExpressionIndex;
import org.h2.result.ResultInterface;
import org.h2.table.Column;
import org.h2.table.QueryExpressionTable;
import org.h2.table.Table;
import org.h2.table.TableType;
import org.h2.util.ParserUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class CTE
extends QueryExpressionTable {
    private final String querySQL;
    private final boolean recursive;
    private final QueryScope queryScope;
    private final ArrayList<Parameter> originalParameters;
    private ResultInterface recursiveResult;

    public CTE(String name, Query query, String querySQL, ArrayList<Parameter> params, Column[] columnTemplates, SessionLocal session, boolean recursive, QueryScope queryScope) {
        super(session.getDatabase().getMainSchema(), 0, name);
        this.setTemporary(true);
        this.queryScope = queryScope;
        this.querySQL = querySQL;
        this.recursive = recursive;
        this.originalParameters = params;
        this.tables = new ArrayList<Table>(query.getTables());
        this.setColumns(this.initColumns(session, columnTemplates, query, false));
        this.viewQuery = query;
    }

    @Override
    protected QueryExpressionIndex createIndex(SessionLocal session, int[] masks) {
        return this.recursive ? new RecursiveIndex(this, this.querySQL, this.originalParameters, session) : new RegularQueryExpressionIndex(this, this.querySQL, this.originalParameters, session, masks);
    }

    @Override
    public Query getTopQuery() {
        return null;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public boolean canDrop() {
        return false;
    }

    @Override
    public TableType getTableType() {
        return null;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        return ParserUtil.quoteIdentifier(builder, this.getName(), sqlFlags);
    }

    public String getQuerySQL() {
        return this.querySQL;
    }

    @Override
    public QueryScope getQueryScope() {
        return this.queryScope;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    @Override
    public boolean isDeterministic() {
        if (this.recursive) {
            return false;
        }
        return super.isDeterministic();
    }

    public void setRecursiveResult(ResultInterface value) {
        if (this.recursiveResult != null) {
            this.recursiveResult.close();
        }
        this.recursiveResult = value;
    }

    public ResultInterface getRecursiveResult() {
        return this.recursiveResult;
    }
}

