/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import org.h2.engine.SessionLocal;
import org.h2.expression.function.table.TableFunction;
import org.h2.result.ResultInterface;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.VirtualConstructedTable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class FunctionTable
extends VirtualConstructedTable {
    private final TableFunction function;

    public FunctionTable(Schema schema, SessionLocal session, TableFunction function) {
        super(schema, 0, function.getName());
        this.function = function;
        function.optimize(session);
        ResultInterface result = function.getValueTemplate(session);
        int columnCount = result.getVisibleColumnCount();
        Column[] cols = new Column[columnCount];
        int i = 0;
        while (i < columnCount) {
            cols[i] = new Column(result.getColumnName(i), result.getColumnType(i));
            ++i;
        }
        this.setColumns(cols);
    }

    @Override
    public boolean canGetRowCount(SessionLocal session) {
        return false;
    }

    @Override
    public long getRowCount(SessionLocal session) {
        return Long.MAX_VALUE;
    }

    @Override
    public long getRowCountApproximation(SessionLocal session) {
        return Long.MAX_VALUE;
    }

    @Override
    public ResultInterface getResult(SessionLocal session) {
        return this.function.getValue(session);
    }

    @Override
    public String getSQL(int sqlFlags) {
        return this.function.getSQL(sqlFlags);
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        return builder.append(this.function.getSQL(sqlFlags));
    }

    @Override
    public boolean isDeterministic() {
        return this.function.isDeterministic();
    }
}

