/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import java.util.HashSet;
import org.h2.command.query.AllColumnsForPlan;
import org.h2.command.query.Query;
import org.h2.engine.DbObject;
import org.h2.engine.SessionLocal;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SortOrder;
import org.h2.schema.Schema;
import org.h2.table.IndexColumn;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.table.TableType;
import org.h2.util.StringUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class MaterializedView
extends Table {
    private Table table;
    private String querySQL;
    private Query query;

    public MaterializedView(Schema schema, int id, String name, Table table, Query query, String querySQL) {
        super(schema, id, name, false, true);
        this.table = table;
        this.query = query;
        this.querySQL = querySQL;
    }

    public void replace(Table table, Query query, String querySQL) {
        this.table = table;
        this.query = query;
        this.querySQL = querySQL;
    }

    public Table getUnderlyingTable() {
        return this.table;
    }

    public Query getSelect() {
        return this.query;
    }

    @Override
    public final void close(SessionLocal session) {
        this.table.close(session);
    }

    @Override
    public final Index addIndex(SessionLocal session, String indexName, int indexId, IndexColumn[] cols, int uniqueColumnCount, IndexType indexType, boolean create, String indexComment) {
        return this.table.addIndex(session, indexName, indexId, cols, uniqueColumnCount, indexType, create, indexComment);
    }

    @Override
    public final boolean isView() {
        return true;
    }

    @Override
    public final PlanItem getBestPlanItem(SessionLocal session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        return this.table.getBestPlanItem(session, masks, filters, filter, sortOrder, allColumnsSet);
    }

    @Override
    public boolean isQueryComparable() {
        return this.table.isQueryComparable();
    }

    @Override
    public final boolean isInsertable() {
        return false;
    }

    @Override
    public final void removeRow(SessionLocal session, Row row) {
        throw DbException.getUnsupportedException(this.getClass().getSimpleName() + ".removeRow");
    }

    @Override
    public final void addRow(SessionLocal session, Row row) {
        throw DbException.getUnsupportedException(this.getClass().getSimpleName() + ".addRow");
    }

    @Override
    public final void checkSupportAlter() {
        throw DbException.getUnsupportedException(this.getClass().getSimpleName() + ".checkSupportAlter");
    }

    @Override
    public final long truncate(SessionLocal session) {
        throw DbException.getUnsupportedException(this.getClass().getSimpleName() + ".truncate");
    }

    @Override
    public final long getRowCount(SessionLocal session) {
        return this.table.getRowCount(session);
    }

    @Override
    public final boolean canGetRowCount(SessionLocal session) {
        return this.table.canGetRowCount(session);
    }

    @Override
    public final long getRowCountApproximation(SessionLocal session) {
        return this.table.getRowCountApproximation(session);
    }

    @Override
    public final boolean canReference() {
        return false;
    }

    @Override
    public final ArrayList<Index> getIndexes() {
        return this.table.getIndexes();
    }

    @Override
    public final Index getScanIndex(SessionLocal session) {
        return this.getBestPlanItem(session, null, null, -1, null, null).getIndex();
    }

    @Override
    public Index getScanIndex(SessionLocal session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        return this.getBestPlanItem(session, masks, filters, filter, sortOrder, allColumnsSet).getIndex();
    }

    @Override
    public boolean isDeterministic() {
        return this.table.isDeterministic();
    }

    @Override
    public final void addDependencies(HashSet<DbObject> dependencies) {
        this.table.addDependencies(dependencies);
    }

    @Override
    public String getDropSQL() {
        return this.getSQL(new StringBuilder("DROP MATERIALIZED VIEW IF EXISTS "), 0).toString();
    }

    @Override
    public String getCreateSQLForCopy(Table table, String quotedName) {
        return this.getCreateSQL(false, true, quotedName);
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQL(false, true);
    }

    public String getCreateSQL(boolean orReplace, boolean force) {
        return this.getCreateSQL(orReplace, force, this.getSQL(0));
    }

    private String getCreateSQL(boolean orReplace, boolean force, String quotedName) {
        StringBuilder builder = new StringBuilder("CREATE ");
        if (orReplace) {
            builder.append("OR REPLACE ");
        }
        if (force) {
            builder.append("FORCE ");
        }
        builder.append("MATERIALIZED VIEW ");
        builder.append(quotedName);
        if (this.comment != null) {
            builder.append(" COMMENT ");
            StringUtils.quoteStringSQL(builder, this.comment);
        }
        return builder.append(" AS\n").append(this.querySQL).toString();
    }

    @Override
    public boolean canDrop() {
        return true;
    }

    @Override
    public TableType getTableType() {
        return TableType.MATERIALIZED_VIEW;
    }

    @Override
    public void removeChildrenAndResources(SessionLocal session) {
        this.table.removeChildrenAndResources(session);
        this.database.removeMeta(session, this.getId());
        this.querySQL = null;
        this.invalidate();
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        if (this.isTemporary() && this.querySQL != null) {
            builder.append("(\n");
            return StringUtils.indent(builder, this.querySQL, 4, true).append(')');
        }
        return super.getSQL(builder, sqlFlags);
    }

    public String getQuerySQL() {
        return this.querySQL;
    }

    @Override
    public long getMaxDataModificationId() {
        return this.table.getMaxDataModificationId();
    }
}

