/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.h2.command.query.AllColumnsForPlan;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.message.Trace;
import org.h2.table.PlanItem;
import org.h2.table.TableFilter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Plan {
    private final TableFilter[] filters;
    private final HashMap<TableFilter, PlanItem> planItems = new HashMap();
    private final Expression[] allConditions;
    private final TableFilter[] allFilters;

    public Plan(TableFilter[] filters, int count, Expression condition) {
        this.filters = new TableFilter[count];
        System.arraycopy(filters, 0, this.filters, 0, count);
        ArrayList<Expression> allCond = new ArrayList<Expression>();
        ArrayList all = new ArrayList();
        if (condition != null) {
            allCond.add(condition);
        }
        int i = 0;
        while (i < count) {
            TableFilter f = filters[i];
            f.visit(f1 -> {
                all.add(f1);
                if (f1.getJoinCondition() != null) {
                    allCond.add(f1.getJoinCondition());
                }
            });
            ++i;
        }
        this.allConditions = allCond.toArray(new Expression[0]);
        this.allFilters = all.toArray(new TableFilter[0]);
    }

    public PlanItem getItem(TableFilter filter) {
        return this.planItems.get(filter);
    }

    public TableFilter[] getFilters() {
        return this.filters;
    }

    public void removeUnusableIndexConditions() {
        int i = 0;
        while (i < this.allFilters.length) {
            TableFilter f = this.allFilters[i];
            this.setEvaluatable(f, true);
            if (i < this.allFilters.length - 1) {
                f.optimizeFullCondition();
            }
            f.removeUnusableIndexConditions();
            ++i;
        }
        TableFilter[] tableFilterArray = this.allFilters;
        int n = this.allFilters.length;
        int n2 = 0;
        while (n2 < n) {
            TableFilter f = tableFilterArray[n2];
            this.setEvaluatable(f, false);
            ++n2;
        }
    }

    public double calculateCost(SessionLocal session, AllColumnsForPlan allColumnsSet) {
        Trace t = session.getTrace();
        if (t.isDebugEnabled()) {
            t.debug("Plan       : calculate cost for plan {0}", Arrays.toString(this.allFilters));
        }
        double cost = 1.0;
        boolean invalidPlan = false;
        int i = 0;
        while (i < this.allFilters.length) {
            TableFilter tableFilter = this.allFilters[i];
            if (t.isDebugEnabled()) {
                t.debug("Plan       :   for table filter {0}", tableFilter);
            }
            PlanItem item = tableFilter.getBestPlanItem(session, this.allFilters, i, allColumnsSet);
            this.planItems.put(tableFilter, item);
            if (t.isDebugEnabled()) {
                t.debug("Plan       :   best plan item cost {0} index {1}", item.cost, item.getIndex().getPlanSQL());
            }
            cost += cost * item.cost;
            this.setEvaluatable(tableFilter, true);
            Expression on = tableFilter.getJoinCondition();
            if (on != null && !on.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR)) {
                invalidPlan = true;
                break;
            }
            ++i;
        }
        if (invalidPlan) {
            cost = Double.POSITIVE_INFINITY;
        }
        if (t.isDebugEnabled()) {
            session.getTrace().debug("Plan       : plan cost {0}", cost);
        }
        TableFilter[] tableFilterArray = this.allFilters;
        int n = this.allFilters.length;
        int n2 = 0;
        while (n2 < n) {
            TableFilter f = tableFilterArray[n2];
            this.setEvaluatable(f, false);
            ++n2;
        }
        return cost;
    }

    private void setEvaluatable(TableFilter filter, boolean b) {
        filter.setEvaluatable(filter, b);
        Expression[] expressionArray = this.allConditions;
        int n = this.allConditions.length;
        int n2 = 0;
        while (n2 < n) {
            Expression e = expressionArray[n2];
            e.setEvaluatable(filter, b);
            ++n2;
        }
    }
}

