/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.Collections;
import java.util.List;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.Database;
import org.h2.index.IndexType;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.util.StringUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class TableBase
extends Table {
    private final String tableEngine;
    private final List<String> tableEngineParams;
    private final boolean globalTemporary;

    public static int getMainIndexColumn(IndexType indexType, IndexColumn[] cols) {
        if (!indexType.isPrimaryKey() || cols.length != 1) {
            return -1;
        }
        IndexColumn first = cols[0];
        if ((first.sortType & 1) != 0) {
            return -1;
        }
        switch (first.column.getType().getValueType()) {
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return first.column.getColumnId();
            }
        }
        return -1;
    }

    public TableBase(CreateTableData data) {
        super(data.schema, data.id, data.tableName, data.persistIndexes, data.persistData);
        this.tableEngine = data.tableEngine;
        this.globalTemporary = data.globalTemporary;
        this.tableEngineParams = data.tableEngineParams != null ? data.tableEngineParams : Collections.emptyList();
        this.setTemporary(data.temporary);
        this.setColumns(data.columns.toArray(new Column[0]));
    }

    @Override
    public String getDropSQL() {
        StringBuilder builder = new StringBuilder("DROP TABLE IF EXISTS ");
        this.getSQL(builder, 0).append(" CASCADE");
        return builder.toString();
    }

    @Override
    public String getCreateSQLForMeta() {
        return this.getCreateSQL(true);
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQL(false);
    }

    private String getCreateSQL(boolean forMeta) {
        String d;
        Database db = this.getDatabase();
        if (db == null) {
            return null;
        }
        StringBuilder buff = new StringBuilder("CREATE ");
        if (this.isTemporary()) {
            if (this.isGlobalTemporary()) {
                buff.append("GLOBAL ");
            } else {
                buff.append("LOCAL ");
            }
            buff.append("TEMPORARY ");
        } else if (this.isPersistIndexes()) {
            buff.append("CACHED ");
        } else {
            buff.append("MEMORY ");
        }
        buff.append("TABLE ");
        this.getSQL(buff, 0);
        if (this.comment != null) {
            buff.append(" COMMENT ");
            StringUtils.quoteStringSQL(buff, this.comment);
        }
        buff.append("(\n    ");
        int i = 0;
        int l = this.columns.length;
        while (i < l) {
            if (i > 0) {
                buff.append(",\n    ");
            }
            buff.append(this.columns[i].getCreateSQL(forMeta));
            ++i;
        }
        buff.append("\n)");
        if (!(this.tableEngine == null || (d = db.getSettings().defaultTableEngine) != null && this.tableEngine.endsWith(d))) {
            buff.append("\nENGINE ");
            StringUtils.quoteIdentifier(buff, this.tableEngine);
        }
        if (!this.tableEngineParams.isEmpty()) {
            buff.append("\nWITH ");
            i = 0;
            l = this.tableEngineParams.size();
            while (i < l) {
                if (i > 0) {
                    buff.append(", ");
                }
                StringUtils.quoteIdentifier(buff, this.tableEngineParams.get(i));
                ++i;
            }
        }
        if (!this.isPersistIndexes() && !this.isPersistData()) {
            buff.append("\nNOT PERSISTENT");
        }
        return buff.toString();
    }

    @Override
    public boolean isGlobalTemporary() {
        return this.globalTemporary;
    }
}

