/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.Objects;
import java.util.SimpleTimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.h2.Driver;
import org.h2.engine.SessionLocal;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.mvstore.MVStoreException;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestAll;
import org.h2.test.utils.ResultVerifier;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

public abstract class TestBase {
    public static final String BASE_TEST_DIR = "./data";
    protected static int uniqueId;
    private static final String TEMP_DIR = "./data/temp";
    private static String baseDir;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    public TestAll config;
    protected long start;
    private final LinkedList<byte[]> memory = new LinkedList();
    private static final DateTimeFormatter timeFormat;

    static {
        baseDir = TestBase.getTestDir("");
        timeFormat = DateTimeFormatter.ofPattern("HH:mm:ss");
    }

    public static String getTestDir(String name) {
        return "./data/test" + name;
    }

    public TestBase init() throws Exception {
        return this.init(new TestAll());
    }

    public TestBase init(TestAll conf) throws Exception {
        baseDir = TestBase.getTestDir("");
        FileUtils.createDirectories(baseDir);
        System.setProperty("java.io.tmpdir", TEMP_DIR);
        this.config = conf;
        return this;
    }

    public void runTest(TestAll conf) {
        block5: {
            if (conf.abbaLockingDetector != null) {
                conf.abbaLockingDetector.reset();
            }
            try {
                this.init(conf);
                if (!this.isEnabled()) {
                    conf.executedTests.putIfAbsent(this.getClass(), false);
                    return;
                }
                conf.executedTests.put(this.getClass(), true);
                this.start = System.nanoTime();
                this.test();
                this.println("");
            }
            catch (Throwable e) {
                this.println("FAIL " + e.toString());
                TestBase.logError("FAIL (" + String.valueOf(conf) + ") " + e.toString(), e);
                if (this.config.stopOnError) {
                    throw new AssertionError((Object)"ERROR");
                }
                TestAll.atLeastOneTestFailed = true;
                if (!(e instanceof OutOfMemoryError)) break block5;
                throw (OutOfMemoryError)e;
            }
        }
    }

    protected String getPassword(String userPassword) {
        return this.config == null || this.config.cipher == null ? userPassword : this.getFilePassword() + " " + userPassword;
    }

    protected String getFilePassword() {
        return "filePassword";
    }

    protected String getPassword() {
        return this.getPassword("123");
    }

    public String getBaseDir() {
        Object dir = baseDir;
        if (this.config != null) {
            if (this.config.reopen) {
                dir = "rec:memFS:" + (String)dir;
            }
            if (this.config.splitFileSystem) {
                dir = "split:16:" + (String)dir;
            }
        }
        return dir;
    }

    protected int getSize(int small, int big) {
        return this.config.endless ? Integer.MAX_VALUE : (this.config.big ? big : small);
    }

    protected String getUser() {
        return "sa";
    }

    protected void trace(int x) {
        this.trace("" + x);
    }

    public void trace(String s) {
        if (this.config.traceTest) {
            this.println(s);
        }
    }

    protected void traceMemory() {
        if (this.config.traceTest) {
            this.trace("mem=" + TestBase.getMemoryUsed());
        }
    }

    public void printTimeMemory(String s, long time) {
        if (this.config.big) {
            Runtime rt = Runtime.getRuntime();
            long memNow = rt.totalMemory() - rt.freeMemory();
            this.println(memNow / 1024L / 1024L + " MB: " + s + " ms: " + time);
        }
    }

    public static int getMemoryUsed() {
        return (int)(TestBase.getMemoryUsedBytes() / 1024L / 1024L);
    }

    public static long getMemoryUsedBytes() {
        Runtime rt = Runtime.getRuntime();
        long memory = Long.MAX_VALUE;
        int i = 0;
        while (i < 8) {
            rt.gc();
            long memNow = rt.totalMemory() - rt.freeMemory();
            if (memNow >= memory) break;
            memory = memNow;
            ++i;
        }
        return memory;
    }

    public void fail() {
        this.fail("Failure");
    }

    protected void fail(String string) {
        if (string.length() > 100) {
            char[] data = string.toCharArray();
            int i = 0;
            while (i < data.length) {
                char c = data[i];
                if (c >= '\u0080' || c < ' ') {
                    data[i] = (char)(97 + (c & 0xF));
                    string = null;
                }
                ++i;
            }
            if (string == null) {
                string = new String(data);
            }
        }
        this.println(string);
        throw new AssertionError((Object)string);
    }

    public static void logErrorMessage(String s) {
        System.out.flush();
        System.err.println("ERROR: " + s + "------------------------------");
        TestBase.logThrowable(s, null);
    }

    public static void logError(String s, Throwable e) {
        if (e == null) {
            e = new Exception(s);
        }
        System.out.flush();
        System.err.println("ERROR: " + s + " " + e.toString() + " ------------------------------");
        e.printStackTrace();
        TestBase.logThrowable(null, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logThrowable(String s, Throwable e) {
        Class<TestBase> clazz = TestBase.class;
        synchronized (TestBase.class) {
            try {
                FileLock lock;
                FileChannel fc = FilePath.get("error.lock").open("rw");
                while ((lock = fc.tryLock()) == null) {
                    Thread.sleep(10L);
                }
                FileWriter fw = new FileWriter("error.txt", true);
                if (s != null) {
                    fw.write(s);
                }
                if (e != null) {
                    PrintWriter pw = new PrintWriter(fw);
                    e.printStackTrace(pw);
                    pw.close();
                }
                fw.close();
                lock.release();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            System.err.flush();
            return;
        }
    }

    public void println(String s) {
        long now = System.nanoTime();
        long time = TimeUnit.NANOSECONDS.toMillis(now - this.start);
        TestBase.printlnWithTime(time, this.getClass().getName() + " " + s);
    }

    static synchronized void printlnWithTime(long millis, String s) {
        StringBuilder builder = new StringBuilder(s.length() + 19);
        timeFormat.formatTo(LocalTime.now(), builder);
        System.out.println(TestBase.formatTime(builder.append(' '), millis).append(' ').append(s).toString());
    }

    protected void printTime(String s) {
        StringBuilder builder = new StringBuilder(s.length() + 9);
        timeFormat.formatTo(LocalTime.now(), builder);
        this.println(builder.append(' ').append(s).toString());
    }

    static StringBuilder formatTime(StringBuilder builder, long millis) {
        int s = (int)(millis / 1000L);
        int m = s / 60;
        s %= 60;
        int h = m / 60;
        if (h != 0) {
            builder.append(h).append(':');
            m %= 60;
        }
        StringUtils.appendTwoDigits(builder, m).append(':');
        StringUtils.appendTwoDigits(builder, s).append('.');
        StringUtils.appendZeroPadded(builder, 3, (int)(millis % 1000L));
        return builder;
    }

    public boolean isEnabled() {
        return true;
    }

    public abstract void test() throws Exception;

    public final void testFromMain() throws Exception {
        this.config.beforeTest();
        this.test();
        this.config.afterTest();
    }

    public void assertEquals(String message, int expected, int actual) {
        if (expected != actual) {
            this.fail("Expected: " + expected + " actual: " + actual + " message: " + message);
        }
    }

    public void assertEquals(int expected, int actual) {
        if (expected != actual) {
            this.fail("Expected: " + expected + " actual: " + actual);
        }
    }

    public void assertEquals(byte[] expected, byte[] actual) {
        if (expected == null || actual == null) {
            this.assertTrue(expected == actual);
            return;
        }
        this.assertEquals(expected.length, actual.length);
        int i = 0;
        while (i < expected.length) {
            if (expected[i] != actual[i]) {
                this.fail("[" + i + "]: expected: " + expected[i] + " actual: " + actual[i]);
            }
            ++i;
        }
    }

    public void assertEquals(Date expected, Date actual) {
        if (!Objects.equals(expected, actual)) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            SimpleTimeZone gmt = new SimpleTimeZone(0, "Z");
            df.setTimeZone(gmt);
            this.fail("Expected: " + (expected != null ? df.format(expected) : "null") + " actual: " + (actual != null ? df.format(actual) : "null"));
        }
    }

    public void assertEquals(Object[] expected, Object[] actual) {
        if (expected == null || actual == null) {
            this.assertTrue(expected == actual);
            return;
        }
        this.assertEquals(expected.length, actual.length);
        int i = 0;
        while (i < expected.length) {
            if (expected[i] == null || actual[i] == null) {
                if (expected[i] != actual[i]) {
                    this.fail("[" + i + "]: expected: " + String.valueOf(expected[i]) + " actual: " + String.valueOf(actual[i]));
                }
            } else if (expected[i] instanceof Object[] && actual[i] instanceof Object[]) {
                this.assertEquals((Object[])expected[i], (Object[])actual[i]);
            } else if (!expected[i].equals(actual[i])) {
                this.fail("[" + i + "]: expected: " + String.valueOf(expected[i]) + " actual: " + String.valueOf(actual[i]));
            }
            ++i;
        }
    }

    public void assertEquals(Object expected, Object actual) {
        if (!Objects.equals(expected, actual)) {
            this.fail(" expected: " + String.valueOf(expected) + " actual: " + String.valueOf(actual));
        }
    }

    protected void assertEqualReaders(Reader expected, Reader actual, int len) throws IOException {
        int i = 0;
        while (len < 0 || i < len) {
            int ce = expected.read();
            int ca = actual.read();
            this.assertEquals("pos:" + i, ce, ca);
            if (ce == -1) break;
            ++i;
        }
        expected.close();
        actual.close();
    }

    protected void assertEqualStreams(InputStream expected, InputStream actual, int len) throws IOException {
        actual.read(new byte[0]);
        expected.read(new byte[0]);
        actual.read(new byte[10], 3, 0);
        expected.read(new byte[10], 0, 0);
        int i = 0;
        while (len < 0 || i < len) {
            int ca = actual.read();
            actual.read(new byte[0]);
            int ce = expected.read();
            if (ca != ce) {
                this.assertEquals("Error at index " + i, ce, ca);
            }
            if (ca == -1) break;
            ++i;
        }
        actual.read(new byte[10], 3, 0);
        expected.read(new byte[10], 0, 0);
        actual.read(new byte[0]);
        expected.read(new byte[0]);
        actual.close();
        expected.close();
    }

    protected void assertEquals(String message, String expected, String actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            this.fail("Expected: " + (String)expected + " Actual: " + actual + " " + message);
        } else if (!((String)expected).equals(actual)) {
            int al = ((String)expected).length();
            int bl = actual.length();
            int i = 0;
            while (i < ((String)expected).length()) {
                String s = ((String)expected).substring(0, i);
                if (!actual.startsWith(s)) {
                    expected = ((String)expected).substring(0, i) + "<*>" + ((String)expected).substring(i);
                    if (al <= 20) break;
                    expected = "@" + i + " " + (String)expected;
                    break;
                }
                ++i;
            }
            if (al > 4000) {
                expected = ((String)expected).substring(0, 4000);
            }
            if (bl > 4000) {
                actual = actual.substring(0, 4000);
            }
            this.fail("Expected: " + (String)expected + " (" + al + ") actual: " + actual + " (" + bl + ") " + message);
        }
    }

    protected void assertEquals(String expected, String actual) {
        this.assertEquals("", expected, actual);
    }

    protected void assertEquals(String message, ResultSet rs0, ResultSet rs1) throws SQLException {
        ResultSetMetaData meta = rs0.getMetaData();
        int columns = meta.getColumnCount();
        this.assertEquals(columns, rs1.getMetaData().getColumnCount());
        while (rs0.next()) {
            this.assertTrue(message, rs1.next());
            int i = 0;
            while (i < columns) {
                this.assertEquals(message, rs0.getString(i + 1), rs1.getString(i + 1));
                ++i;
            }
        }
        this.assertFalse(message, rs0.next());
        this.assertFalse(message, rs1.next());
    }

    public void assertSame(Object expected, Object actual) {
        if (expected != actual) {
            this.fail(" expected: " + String.valueOf(expected) + " != actual: " + String.valueOf(actual));
        }
    }

    protected void assertSmaller(long a, long b) {
        if (a >= b) {
            this.fail("a: " + a + " is not smaller than b: " + b);
        }
    }

    protected void assertContains(String result, String contains) {
        if (!result.contains(contains)) {
            this.fail(result + " does not contain: " + contains);
        }
    }

    protected void assertNotContaining(String result, String shallNotContain) {
        if (result.contains(shallNotContain)) {
            this.fail(result + " still contains: " + shallNotContain);
        }
    }

    protected void assertStartsWith(String text, String expectedStart) {
        if (!text.startsWith(expectedStart)) {
            this.fail("[" + text + "] does not start with: [" + expectedStart + "]");
        }
    }

    protected void assertEquals(long expected, long actual) {
        if (expected != actual) {
            this.fail("Expected: " + expected + " actual: " + actual);
        }
    }

    protected void assertEquals(double expected, double actual) {
        if (!(expected == actual || Double.isNaN(expected) && Double.isNaN(actual))) {
            this.fail("Expected: " + expected + " actual: " + actual);
        }
    }

    protected void assertEquals(float expected, float actual) {
        if (!(expected == actual || Float.isNaN(expected) && Float.isNaN(actual))) {
            this.fail("Expected: " + expected + " actual: " + actual);
        }
    }

    protected void assertEquals(boolean expected, boolean actual) {
        if (expected != actual) {
            this.fail("Boolean expected: " + expected + " actual: " + actual);
        }
    }

    public void assertTrue(boolean condition) {
        if (!condition) {
            this.fail("Expected: true got: false");
        }
    }

    public void assertNull(Object obj) {
        if (obj != null) {
            this.fail("Expected: null got: " + String.valueOf(obj));
        }
    }

    public void assertEmpty(String s) {
        if (s != null && !s.isEmpty()) {
            this.fail("Expected: empty String but got: " + s);
        }
    }

    public void assertNotNull(Object obj) {
        if (obj == null) {
            this.fail("Expected: not null got: null");
        }
    }

    public void assertNotNull(String message, Object obj) {
        if (obj == null) {
            this.fail(message);
        }
    }

    public void assertTrue(String message, boolean condition) {
        if (!condition) {
            this.fail(message);
        }
    }

    protected void assertFalse(boolean value) {
        if (value) {
            this.fail("Expected: false got: true");
        }
    }

    protected void assertFalse(String message, boolean value) {
        if (value) {
            this.fail(message);
        }
    }

    protected void assertResultRowCount(int expected, ResultSet rs) throws SQLException {
        int i = 0;
        while (rs.next()) {
            ++i;
        }
        this.assertEquals(expected, i);
    }

    protected void assertSingleValue(Statement stat, String sql, int expected) throws SQLException {
        ResultSet rs = stat.executeQuery(sql);
        this.assertTrue(rs.next());
        this.assertEquals(expected, rs.getInt(1));
        this.assertFalse(rs.next());
    }

    protected void assertResult(String expected, Statement stat, String sql) throws SQLException {
        ResultSet rs = stat.executeQuery(sql);
        if (rs.next()) {
            String actual = rs.getString(1);
            this.assertEquals(expected, actual);
        } else {
            this.assertEquals(expected, null);
        }
    }

    protected void assertThrows(int expectedErrorCode, Statement stat, String sql) {
        try {
            this.execute(stat, sql);
            this.fail("Expected error: " + expectedErrorCode);
        }
        catch (SQLException ex) {
            this.assertEquals(expectedErrorCode, ex.getErrorCode());
        }
    }

    public void execute(PreparedStatement stat) throws SQLException {
        this.execute(stat, null);
    }

    protected void execute(Statement stat, String sql) throws SQLException {
        boolean query;
        boolean bl = query = sql == null ? ((PreparedStatement)stat).execute() : stat.execute(sql);
        if (query && this.config.lazy) {
            Throwable throwable = null;
            Object var5_6 = null;
            try (ResultSet rs = stat.getResultSet();){
                while (rs.next()) {
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    protected void assertResultSetMeta(ResultSet rs, int columnCount, String[] labels, int[] datatypes, int[] precision, int[] scale) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int cc = meta.getColumnCount();
        if (cc != columnCount) {
            this.fail("result set contains " + cc + " columns not " + columnCount);
        }
        int i = 0;
        while (i < columnCount) {
            int s;
            int p;
            String l;
            if (labels != null && !labels[i].equals(l = meta.getColumnLabel(i + 1))) {
                this.fail("column label " + i + " is " + l + " not " + labels[i]);
            }
            if (datatypes != null) {
                int t = meta.getColumnType(i + 1);
                if (datatypes[i] != t) {
                    this.fail("column datatype " + i + " is " + t + " not " + datatypes[i] + " (prec=" + meta.getPrecision(i + 1) + " scale=" + meta.getScale(i + 1) + ")");
                }
                String typeName = meta.getColumnTypeName(i + 1);
                String className = meta.getColumnClassName(i + 1);
                switch (t) {
                    case 4: {
                        this.assertEquals("INTEGER", typeName);
                        this.assertEquals("java.lang.Integer", className);
                        break;
                    }
                    case 12: {
                        this.assertEquals("CHARACTER VARYING", typeName);
                        this.assertEquals("java.lang.String", className);
                        break;
                    }
                    case 5: {
                        this.assertEquals("SMALLINT", typeName);
                        this.assertEquals("java.lang.Integer", className);
                        break;
                    }
                    case 93: {
                        this.assertEquals("TIMESTAMP", typeName);
                        this.assertEquals("java.sql.Timestamp", className);
                        break;
                    }
                    case 2: {
                        this.assertEquals("NUMERIC", typeName);
                        this.assertEquals("java.math.BigDecimal", className);
                    }
                }
            }
            if (precision != null && precision[i] != (p = meta.getPrecision(i + 1))) {
                this.fail("column precision " + i + " is " + p + " not " + precision[i]);
            }
            if (scale != null && scale[i] != (s = meta.getScale(i + 1))) {
                this.fail("column scale " + i + " is " + s + " not " + scale[i]);
            }
            ++i;
        }
    }

    protected void assertResultSetOrdered(ResultSet rs, String[][] data, int[] ignoreColumns) throws SQLException {
        this.assertResultSet(true, rs, data, ignoreColumns);
    }

    protected void assertResultSetOrdered(ResultSet rs, String[][] data) throws SQLException {
        this.assertResultSet(true, rs, data, null);
    }

    private void assertResultSet(boolean ordered, ResultSet rs, String[][] data, int[] ignoreColumns) throws SQLException {
        int len2;
        int len = rs.getMetaData().getColumnCount();
        int rows = data.length;
        if (rows == 0 && rs.next()) {
            this.fail("testResultSet expected rowCount:" + rows + " got:0");
        }
        if (len < (len2 = data[0].length)) {
            this.fail("testResultSet expected columnCount:" + len2 + " got:" + len);
        }
        int i = 0;
        while (i < rows) {
            if (!rs.next()) {
                this.fail("testResultSet expected rowCount:" + rows + " got:" + i);
            }
            String[] row = TestBase.getData(rs, len);
            if (ordered) {
                String[] good = data[i];
                if (!TestBase.testRow(good, row, good.length, ignoreColumns)) {
                    this.fail("testResultSet row not equal, got:\n" + TestBase.formatRow(row) + "\n" + TestBase.formatRow(good));
                }
            } else {
                boolean found = false;
                int j = 0;
                while (j < rows) {
                    String[] good = data[i];
                    if (TestBase.testRow(good, row, good.length, ignoreColumns)) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    this.fail("testResultSet no match for row:" + TestBase.formatRow(row));
                }
            }
            ++i;
        }
        if (rs.next()) {
            String[] row = TestBase.getData(rs, len);
            this.fail("testResultSet expected rowcount:" + rows + " got:>=" + (rows + 1) + " data:" + TestBase.formatRow(row));
        }
    }

    private static boolean testRow(String[] a, String[] b, int len, int[] ignoreColumns) {
        int i = 0;
        while (i < len) {
            if (ignoreColumns != null) {
                int[] nArray = ignoreColumns;
                int n = ignoreColumns.length;
                int n2 = 0;
                while (n2 < n) {
                    int c = nArray[n2];
                    if (c != i) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            } else {
                String sa = a[i];
                String sb = b[i];
                if (sa == null || sb == null ? sa != sb : !sa.equals(sb)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private static String[] getData(ResultSet rs, int len) throws SQLException {
        String[] data = new String[len];
        int i = 0;
        while (i < len) {
            data[i] = rs.getString(i + 1);
            rs.getObject(i + 1);
            ++i;
        }
        return data;
    }

    private static String formatRow(String[] row) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        String[] stringArray = row;
        int n = row.length;
        int n2 = 0;
        while (n2 < n) {
            String r = stringArray[n2];
            sb.append("{").append(r).append("}");
            ++n2;
        }
        sb.append("}");
        return sb.toString();
    }

    protected void crash(Connection conn) {
        TestBase.setPowerOffCount(conn, 1);
        try {
            conn.createStatement().execute("SET WRITE_DELAY 0");
            conn.createStatement().execute("CREATE TABLE TEST_A(ID INT)");
            this.fail("should be crashed already");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void setPowerOffCount(Connection conn, int i) {
        SessionLocal session = (SessionLocal)((JdbcConnection)conn).getSession();
        if (session != null) {
            session.getDatabase().setPowerOffCount(i);
        }
    }

    protected static int getPowerOffCount(Connection conn) {
        SessionLocal session = (SessionLocal)((JdbcConnection)conn).getSession();
        return session != null && !session.isClosed() ? session.getDatabase().getPowerOffCount() : 0;
    }

    protected String readString(Reader reader) {
        if (reader == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        try {
            int c;
            while ((c = reader.read()) != -1) {
                buffer.append((char)c);
            }
            return buffer.toString();
        }
        catch (Exception e) {
            this.assertTrue(false);
            return null;
        }
    }

    public void assertKnownException(SQLException e) {
        this.assertKnownException("", e);
    }

    protected void assertKnownException(String message, SQLException e) {
        if (e != null && e.getSQLState().startsWith("HY000")) {
            TestBase.logError("Unexpected General error " + message, e);
        }
    }

    protected void assertEquals(Integer expected, Integer actual) {
        if (expected == null || actual == null) {
            if (expected != actual) {
                this.assertEquals(String.valueOf(expected), String.valueOf(actual));
            }
        } else {
            this.assertEquals((int)expected, (int)actual);
        }
    }

    protected void assertEqualDatabases(Statement stat1, Statement stat2) throws SQLException {
        int analyzeAuto;
        ResultSet rs = stat1.executeQuery("SELECT SETTING_VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE SETTING_NAME = 'ANALYZE_AUTO'");
        int n = analyzeAuto = rs.next() ? rs.getInt(1) : 0;
        if (analyzeAuto > 0) {
            stat1.execute("analyze");
            stat2.execute("analyze");
        }
        ResultSet rs1 = stat1.executeQuery("SCRIPT simple NOPASSWORDS");
        ResultSet rs2 = stat2.executeQuery("SCRIPT simple NOPASSWORDS");
        ArrayList<String> list1 = new ArrayList<String>();
        ArrayList<String> list2 = new ArrayList<String>();
        while (rs1.next()) {
            String s1 = rs1.getString(1);
            s1 = TestBase.removeRowCount(s1);
            if (!rs2.next()) {
                this.fail("expected: " + s1);
            }
            String s2 = rs2.getString(1);
            if (s1.equals(s2 = TestBase.removeRowCount(s2))) continue;
            list1.add(s1);
            list2.add(s2);
        }
        for (String s : list1) {
            if (list2.remove(s)) continue;
            this.fail("only found in first: " + s + " remaining: " + String.valueOf(list2));
        }
        this.assertEquals("remaining: " + String.valueOf(list2), 0, list2.size());
        this.assertFalse(rs2.next());
    }

    private static String removeRowCount(String scriptLine) {
        int index = scriptLine.indexOf("+/-");
        if (index >= 0) {
            scriptLine = scriptLine.substring(index);
        }
        return scriptLine;
    }

    public static TestBase createCaller() {
        Driver.load();
        try {
            return (TestBase)new SecurityManager(){
                Class<?> clazz = this.getClassContext()[2];
            }.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getClassPath() {
        return System.getProperty("java.class.path");
    }

    public static String getJVM() {
        return System.getProperty("java.home") + File.separatorChar + "bin" + File.separator + "java";
    }

    protected void eatMemory(int remainingKB) {
        block3: {
            try {
                long memoryFreeKB;
                while ((memoryFreeKB = Utils.getMemoryFree()) > (long)remainingKB) {
                    long blockSize = Math.max((memoryFreeKB - (long)remainingKB) / 16L, 16L) * 1024L;
                    this.memory.add(new byte[blockSize > 0x7FFFFFF7L ? 0x7FFFFFF7 : (int)blockSize]);
                }
            }
            catch (OutOfMemoryError e) {
                if (remainingKB < 3000) break block3;
                this.memory.clear();
                throw e;
            }
        }
    }

    protected void freeMemory() {
        this.memory.clear();
        int i = 0;
        while (i < 5) {
            System.gc();
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
    }

    protected <T> T assertThrows(Class<?> expectedExceptionClass, T obj) {
        return this.assertThrows((Object returnValue, Throwable t, Method m, Object[] args) -> {
            if (t == null) {
                throw new AssertionError((Object)("Expected an exception of type " + expectedExceptionClass.getSimpleName() + " to be thrown, but the method returned " + String.valueOf(returnValue) + " for " + TestBase.formatMethodCall(m, args)));
            }
            if (!expectedExceptionClass.isAssignableFrom(t.getClass())) {
                throw new AssertionError("Expected an exception of type\n" + expectedExceptionClass.getSimpleName() + " to be thrown, but the method under test threw an exception of type\n" + t.getClass().getSimpleName() + " (see in the 'Caused by' for the exception that was thrown) for " + TestBase.formatMethodCall(m, args), t);
            }
            return false;
        }, obj);
    }

    private static String formatMethodCall(Method m, Object ... args) {
        StringBuilder builder = new StringBuilder();
        builder.append(m.getName()).append('(');
        int i = 0;
        while (i < args.length) {
            Object a = args[i];
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(a == null ? "null" : a.toString());
            ++i;
        }
        builder.append(")");
        return builder.toString();
    }

    protected <T> T assertThrows(int expectedErrorCode, T obj) {
        return this.assertThrows((Object returnValue, Throwable t, Method m, Object[] args) -> {
            TestBase.checkErrorCode(expectedErrorCode, t);
            return false;
        }, obj);
    }

    protected <T> T assertThrows(final ResultVerifier verifier, final T obj) {
        Class<?> c = obj.getClass();
        InvocationHandler ih = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
                try {
                    Object ret = method.invoke(obj, args);
                    verifier.verify(ret, null, method, args);
                    return ret;
                }
                catch (InvocationTargetException e) {
                    verifier.verify(null, e.getTargetException(), method, args);
                    Class<?> retClass = method.getReturnType();
                    if (!retClass.isPrimitive()) {
                        return null;
                    }
                    if (retClass == Boolean.TYPE) {
                        return false;
                    }
                    if (retClass == Byte.TYPE) {
                        return (byte)0;
                    }
                    if (retClass == Character.TYPE) {
                        return Character.valueOf('\u0000');
                    }
                    if (retClass == Short.TYPE) {
                        return (short)0;
                    }
                    if (retClass == Integer.TYPE) {
                        return 0;
                    }
                    if (retClass == Long.TYPE) {
                        return 0L;
                    }
                    if (retClass == Float.TYPE) {
                        return Float.valueOf(0.0f);
                    }
                    if (retClass == Double.TYPE) {
                        return 0.0;
                    }
                    return null;
                }
            }
        };
        Class<?>[] interfaces = c.getInterfaces();
        if (interfaces.length == 0) {
            throw new RuntimeException("Can not create a proxy for the class " + c.getSimpleName() + " because it doesn't implement any interfaces and is final");
        }
        return (T)Proxy.newProxyInstance(c.getClassLoader(), interfaces, ih);
    }

    protected void assertThrows(Class<?> expectedExceptionClass, Callable<?> c) {
        try {
            Object returnValue = c.call();
            throw new AssertionError((Object)("Expected an exception of type " + expectedExceptionClass.getSimpleName() + " to be thrown, but the method returned " + String.valueOf(returnValue)));
        }
        catch (Throwable t) {
            TestBase.checkException(expectedExceptionClass, t);
            return;
        }
    }

    protected void assertThrows(Class<?> expectedExceptionClass, VoidCallable c) {
        try {
            c.call();
            throw new AssertionError((Object)("Expected an exception of type " + expectedExceptionClass.getSimpleName() + " to be thrown, but the method returned successfully"));
        }
        catch (Throwable t) {
            TestBase.checkException(expectedExceptionClass, t);
            return;
        }
    }

    protected void assertThrows(int expectedErrorCode, Callable<?> c) {
        try {
            Object returnValue = c.call();
            throw new AssertionError((Object)("Expected an SQLException or DbException with error code " + expectedErrorCode + " to be thrown, but the method returned " + String.valueOf(returnValue)));
        }
        catch (Throwable t) {
            TestBase.checkErrorCode(expectedErrorCode, t);
            return;
        }
    }

    protected void assertThrows(int expectedErrorCode, VoidCallable c) {
        try {
            c.call();
            throw new AssertionError((Object)("Expected an SQLException or DbException with error code " + expectedErrorCode + " to be thrown, but the method returned successfully"));
        }
        catch (Throwable t) {
            TestBase.checkErrorCode(expectedErrorCode, t);
            return;
        }
    }

    private static void checkException(Class<?> expectedExceptionClass, Throwable t) throws AssertionError {
        if (!expectedExceptionClass.isAssignableFrom(t.getClass())) {
            throw new AssertionError("Expected an exception of type\n" + expectedExceptionClass.getSimpleName() + " to be thrown, but an exception of type\n" + t.getClass().getSimpleName() + " was thrown", t);
        }
    }

    public static void checkErrorCode(int expectedErrorCode, Throwable t) throws AssertionError {
        int errorCode = t instanceof DbException ? ((DbException)t).getErrorCode() : (t instanceof SQLException ? ((SQLException)t).getErrorCode() : (t instanceof MVStoreException ? ((MVStoreException)t).getErrorCode() : 0));
        if (errorCode != expectedErrorCode) {
            throw new AssertionError("Expected an SQLException or DbException with error code " + expectedErrorCode + ", but got a " + (String)(t == null ? "null" : t.getClass().getName() + " exception  with error code " + errorCode), t);
        }
    }

    public static ByteArrayInputStream createFailingStream(final Exception e) {
        return new ByteArrayInputStream(new byte[20480]){

            @Override
            public int read(byte[] buffer, int off, int len) {
                if (this.pos > 10240) {
                    TestBase.throwException(e);
                }
                return super.read(buffer, off, len);
            }
        };
    }

    public static void throwException(Throwable e) {
        TestBase.throwThis(e);
    }

    private static <E extends Throwable> void throwThis(Throwable e) throws E {
        throw e;
    }

    public String getTestName() {
        return this.getClass().getSimpleName();
    }

    @FunctionalInterface
    protected static interface VoidCallable {
        public void call() throws Exception;
    }
}

