/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.ap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public class TestAnnotationProcessor
extends AbstractProcessor {
    public static final String MESSAGES_KEY = TestAnnotationProcessor.class.getName() + "-messages";

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        for (OutputMessage outputMessage : TestAnnotationProcessor.findMessages()) {
            this.processingEnv.getMessager().printMessage(outputMessage.kind, outputMessage.message);
        }
        return Collections.emptySet();
    }

    private static List<OutputMessage> findMessages() {
        String messagesStr = System.getProperty(MESSAGES_KEY);
        if (messagesStr == null || messagesStr.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<OutputMessage> outputMessages = new ArrayList<OutputMessage>();
        String[] stringArray = messagesStr.split("\\|");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String msg = stringArray[n2];
            String[] split = msg.split(",");
            if (split.length != 2) {
                throw new IllegalStateException("Unable to parse messages definition for: '" + messagesStr + "'");
            }
            outputMessages.add(new OutputMessage(Diagnostic.Kind.valueOf(split[0]), split[1]));
            ++n2;
        }
        return outputMessages;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return false;
    }

    private static class OutputMessage {
        public final Diagnostic.Kind kind;
        public final String message;

        OutputMessage(Diagnostic.Kind kind, String message) {
            this.kind = kind;
            this.message = message;
        }
    }
}

