/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.bench;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Random;
import org.h2.test.bench.Bench;
import org.h2.test.bench.Database;

public class BenchB
implements Bench,
Runnable {
    private static final int SCALE = 4;
    private static final int BRANCHES = 10;
    private static final int TELLERS = 100;
    private static final int ACCOUNTS = 100000;
    private int threadCount = 10;
    private Database database;
    private int transactionPerClient;
    private BenchB master;
    private Connection conn;
    private PreparedStatement selectAccount;
    private PreparedStatement updateAccount;
    private PreparedStatement updateTeller;
    private PreparedStatement updateBranch;
    private PreparedStatement insertHistory;
    private Random random;

    public BenchB() {
    }

    private BenchB(BenchB master, int seed) throws SQLException {
        this.master = master;
        this.random = new Random(seed);
        this.conn = master.database.openNewConnection();
        this.conn.setAutoCommit(false);
        try {
            this.selectAccount = this.conn.prepareStatement("SELECT ABALANCE FROM ACCOUNTS WHERE AID=? FOR UPDATE");
        }
        catch (SQLException ignored) {
            this.selectAccount = this.conn.prepareStatement("SELECT ABALANCE FROM ACCOUNTS WHERE AID=?");
        }
        this.updateAccount = this.conn.prepareStatement("UPDATE ACCOUNTS SET ABALANCE=ABALANCE+? WHERE AID=?");
        this.updateTeller = this.conn.prepareStatement("UPDATE TELLERS SET TBALANCE=TBALANCE+? WHERE TID=?");
        this.updateBranch = this.conn.prepareStatement("UPDATE BRANCHES SET BBALANCE=BBALANCE+? WHERE BID=?");
        this.insertHistory = this.conn.prepareStatement("INSERT INTO HISTORY(TID, BID, AID, DELTA) VALUES(?, ?, ?, ?)");
    }

    @Override
    public void init(Database db, int size) throws SQLException {
        String[] create;
        this.database = db;
        this.transactionPerClient = this.getTransactionsPerClient(size);
        db.start(this, "Init");
        db.openConnection();
        db.dropTable("BRANCHES");
        db.dropTable("TELLERS");
        db.dropTable("ACCOUNTS");
        db.dropTable("HISTORY");
        String[] stringArray = create = new String[]{"CREATE TABLE BRANCHES(BID INT NOT NULL PRIMARY KEY, BBALANCE INT, FILLER VARCHAR(88))", "CREATE TABLE TELLERS(TID INT NOT NULL PRIMARY KEY, BID INT, TBALANCE INT, FILLER VARCHAR(84))", "CREATE TABLE ACCOUNTS(AID INT NOT NULL PRIMARY KEY, BID INT, ABALANCE INT, FILLER VARCHAR(84))", "CREATE TABLE HISTORY(TID INT, BID INT, AID INT, DELTA INT, HTIME DATETIME, FILLER VARCHAR(22))"};
        int n = create.length;
        int n2 = 0;
        while (n2 < n) {
            String sql = stringArray[n2];
            db.update(sql);
            ++n2;
        }
        db.setAutoCommit(false);
        int commitEvery = 1000;
        PreparedStatement prep = db.prepare("INSERT INTO BRANCHES(BID, BBALANCE) VALUES(?, 0)");
        int i = 0;
        while (i < 40) {
            prep.setInt(1, i);
            db.update(prep, "insertBranches");
            if ((i + 1) % commitEvery == 0) {
                db.commit();
            }
            ++i;
        }
        db.commit();
        prep = db.prepare("INSERT INTO TELLERS(TID, BID, TBALANCE) VALUES(?, ?, 0)");
        i = 0;
        while (i < 400) {
            prep.setInt(1, i);
            prep.setInt(2, i / 100);
            db.update(prep, "insertTellers");
            if ((i + 1) % commitEvery == 0) {
                db.commit();
            }
            ++i;
        }
        db.commit();
        int len = 400000;
        prep = db.prepare("INSERT INTO ACCOUNTS(AID, BID, ABALANCE) VALUES(?, ?, 0)");
        int i2 = 0;
        while (i2 < len) {
            prep.setInt(1, i2);
            prep.setInt(2, i2 / 100000);
            db.update(prep, "insertAccounts");
            if ((i2 + 1) % commitEvery == 0) {
                db.commit();
            }
            ++i2;
        }
        db.commit();
        db.closeConnection();
        db.end();
    }

    protected int getTransactionsPerClient(int size) {
        return size / 8;
    }

    @Override
    public void run() {
        int accountsPerBranch = 10000;
        int i = 0;
        while (i < this.master.transactionPerClient) {
            try {
                int branch = this.random.nextInt(10);
                int teller = this.random.nextInt(100);
                int account = this.random.nextInt(100) < 85 ? this.random.nextInt(accountsPerBranch) + branch * accountsPerBranch : this.random.nextInt(100000);
                int delta = this.random.nextInt(1000);
                this.doOne(branch, teller, account, -delta);
                try {
                    this.conn.commit();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            catch (SQLException ignore) {
                try {
                    this.conn.rollback();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        try {
            this.conn.setAutoCommit(true);
            this.conn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void doOne(int branch, int teller, int account, int delta) throws SQLException {
        this.selectAccount.setInt(1, account);
        this.master.database.queryReadResult(this.selectAccount);
        this.updateAccount.setInt(1, delta);
        this.updateAccount.setInt(2, account);
        this.master.database.update(this.updateAccount, "UpdateAccounts");
        this.updateTeller.setInt(1, delta);
        this.updateTeller.setInt(2, teller);
        this.master.database.update(this.updateTeller, "UpdateTeller");
        this.updateBranch.setInt(1, delta);
        this.updateBranch.setInt(2, branch);
        this.master.database.update(this.updateBranch, "UpdateBranch");
        this.insertHistory.setInt(1, teller);
        this.insertHistory.setInt(2, branch);
        this.insertHistory.setInt(3, account);
        this.insertHistory.setInt(4, delta);
        this.master.database.update(this.insertHistory, "InsertHistory");
    }

    private void clearHistory() throws SQLException {
        this.database.update("DELETE FROM HISTORY");
    }

    @Override
    public void runTest() throws Exception {
        Database db = this.database;
        db.openConnection();
        db.start(this, "Transactions");
        this.processTransactions();
        db.end();
        db.logMemory(this, "Memory Usage");
        this.clearHistory();
        db.closeConnection();
    }

    private void processTransactions() throws Exception {
        Thread[] threads = new Thread[this.threadCount];
        int i = 0;
        while (i < this.threadCount) {
            threads[i] = new Thread((Runnable)new BenchB(this, i), "BenchB-" + i);
            ++i;
        }
        Thread[] threadArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread t = threadArray[n2];
            t.start();
            ++n2;
        }
        threadArray = threads;
        n = threads.length;
        n2 = 0;
        while (n2 < n) {
            Thread t = threadArray[n2];
            t.join();
            ++n2;
        }
    }

    @Override
    public String getName() {
        return "BenchB";
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }
}

