/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.bench;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.h2.test.bench.BenchC;
import org.h2.test.bench.BenchCRandom;
import org.h2.test.bench.Database;

public class BenchCThread {
    private static final int OP_NEW_ORDER = 0;
    private static final int OP_PAYMENT = 1;
    private static final int OP_ORDER_STATUS = 2;
    private static final int OP_DELIVERY = 3;
    private static final int OP_STOCK_LEVEL = 4;
    private static final BigDecimal ONE = new BigDecimal("1");
    private final Database db;
    private final int warehouseId;
    private final int terminalId;
    private final HashMap<String, PreparedStatement> prepared = new HashMap();
    private final BenchCRandom random;
    private final BenchC bench;

    BenchCThread(Database db, BenchC bench, BenchCRandom random, int terminal) throws SQLException {
        this.db = db;
        this.bench = bench;
        this.terminalId = terminal;
        db.setAutoCommit(false);
        this.random = random;
        this.warehouseId = random.getInt(1, bench.warehouses);
    }

    void process() throws SQLException {
        int[] nArray = new int[23];
        nArray[10] = 1;
        nArray[11] = 1;
        nArray[12] = 1;
        nArray[13] = 1;
        nArray[14] = 1;
        nArray[15] = 1;
        nArray[16] = 1;
        nArray[17] = 1;
        nArray[18] = 1;
        nArray[19] = 1;
        nArray[20] = 2;
        nArray[21] = 3;
        nArray[22] = 4;
        int[] deck = nArray;
        int len = deck.length;
        int i = 0;
        while (i < len) {
            int temp = deck[i];
            int j = this.random.getInt(0, len);
            deck[i] = deck[j];
            deck[j] = temp;
            ++i;
        }
        int[] nArray2 = deck;
        int n = deck.length;
        int n2 = 0;
        while (n2 < n) {
            int op = nArray2[n2];
            switch (op) {
                case 0: {
                    this.processNewOrder();
                    break;
                }
                case 1: {
                    this.processPayment();
                    break;
                }
                case 2: {
                    this.processOrderStatus();
                    break;
                }
                case 3: {
                    this.processDelivery();
                    break;
                }
                case 4: {
                    this.processStockLevel();
                    break;
                }
                default: {
                    throw new AssertionError((Object)("op=" + op));
                }
            }
            ++n2;
        }
    }

    private void processNewOrder() throws SQLException {
        int dId = this.random.getInt(1, this.bench.districtsPerWarehouse);
        int cId = this.random.getNonUniform(1023, 1, this.bench.customersPerDistrict);
        int olCnt = this.random.getInt(5, 15);
        boolean rollback = this.random.getInt(1, 100) == 1;
        int[] supplyId = new int[olCnt];
        int[] itemId = new int[olCnt];
        int[] quantity = new int[olCnt];
        int allLocal = 1;
        int i = 0;
        while (i < olCnt) {
            int w;
            if (this.bench.warehouses > 1 && this.random.getInt(1, 100) == 1) {
                while ((w = this.random.getInt(1, this.bench.warehouses)) != this.warehouseId) {
                }
                allLocal = 0;
            } else {
                w = this.warehouseId;
            }
            supplyId[i] = w;
            int item = rollback && i == olCnt - 1 ? -1 : this.random.getNonUniform(8191, 1, this.bench.items);
            itemId[i] = item;
            quantity[i] = this.random.getInt(1, 10);
            ++i;
        }
        char[] bg = new char[olCnt];
        int[] stock = new int[olCnt];
        BigDecimal[] amt = new BigDecimal[olCnt];
        Timestamp datetime = new Timestamp(System.currentTimeMillis());
        PreparedStatement prep = this.prepare("UPDATE DISTRICT SET D_NEXT_O_ID=D_NEXT_O_ID+1 WHERE D_ID=? AND D_W_ID=?");
        prep.setInt(1, dId);
        prep.setInt(2, this.warehouseId);
        this.db.update(prep, "updateDistrict");
        prep = this.prepare("SELECT D_NEXT_O_ID, D_TAX FROM DISTRICT WHERE D_ID=? AND D_W_ID=?");
        prep.setInt(1, dId);
        prep.setInt(2, this.warehouseId);
        ResultSet rs = this.db.query(prep);
        rs.next();
        int oId = rs.getInt(1) - 1;
        BigDecimal tax = rs.getBigDecimal(2);
        rs.close();
        prep = this.prepare("SELECT C_DISCOUNT, C_LAST, C_CREDIT, W_TAX FROM CUSTOMER, WAREHOUSE WHERE C_ID=? AND W_ID=? AND C_W_ID=W_ID AND C_D_ID=?");
        prep.setInt(1, cId);
        prep.setInt(2, this.warehouseId);
        prep.setInt(3, dId);
        rs = this.db.query(prep);
        rs.next();
        BigDecimal discount = rs.getBigDecimal(1);
        rs.getString(2);
        rs.getString(3);
        BigDecimal wTax = rs.getBigDecimal(4);
        rs.close();
        BigDecimal total = new BigDecimal("0");
        int number = 1;
        while (number <= olCnt) {
            int olId = itemId[number - 1];
            int olSupplyId = supplyId[number - 1];
            int olQuantity = quantity[number - 1];
            prep = this.prepare("SELECT I_PRICE, I_NAME, I_DATA FROM ITEM WHERE I_ID=?");
            prep.setInt(1, olId);
            rs = this.db.query(prep);
            if (!rs.next()) {
                if (rollback) {
                    this.db.rollback();
                    return;
                }
                throw new SQLException("item not found: " + olId + " " + olSupplyId);
            }
            BigDecimal price = rs.getBigDecimal(1);
            rs.getString(2);
            String data = rs.getString(3);
            rs.close();
            prep = this.prepare("SELECT S_QUANTITY, S_DATA, S_DIST_01, S_DIST_02, S_DIST_03, S_DIST_04, S_DIST_05, S_DIST_06, S_DIST_07, S_DIST_08, S_DIST_09, S_DIST_10 FROM STOCK WHERE S_I_ID=? AND S_W_ID=?");
            prep.setInt(1, olId);
            prep.setInt(2, olSupplyId);
            rs = this.db.query(prep);
            if (!rs.next()) {
                if (rollback) {
                    this.db.rollback();
                    return;
                }
                throw new SQLException("item not found: " + olId + " " + olSupplyId);
            }
            int sQuantity = rs.getInt(1);
            String sData = rs.getString(2);
            String[] dist = new String[10];
            int i2 = 0;
            while (i2 < 10) {
                dist[i2] = rs.getString(3 + i2);
                ++i2;
            }
            rs.close();
            String distInfo = dist[(dId - 1) % 10];
            stock[number - 1] = sQuantity;
            bg[number - 1] = data.contains("original") && sData.contains("original") ? 66 : 71;
            sQuantity = sQuantity > olQuantity ? (sQuantity -= olQuantity) : sQuantity - olQuantity + 91;
            prep = this.prepare("UPDATE STOCK SET S_QUANTITY=? WHERE S_W_ID=? AND S_I_ID=?");
            prep.setInt(1, sQuantity);
            prep.setInt(2, olSupplyId);
            prep.setInt(3, olId);
            this.db.update(prep, "updateStock");
            BigDecimal olAmount = new BigDecimal(olQuantity).multiply(price).multiply(ONE.add(wTax).add(tax)).multiply(ONE.subtract(discount));
            amt[number - 1] = olAmount = olAmount.setScale(2, RoundingMode.HALF_UP);
            total = total.add(olAmount);
            prep = this.prepare("INSERT INTO ORDER_LINE (OL_O_ID, OL_D_ID, OL_W_ID, OL_NUMBER, OL_I_ID, OL_SUPPLY_W_ID, OL_QUANTITY, OL_AMOUNT, OL_DIST_INFO) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            prep.setInt(1, oId);
            prep.setInt(2, dId);
            prep.setInt(3, this.warehouseId);
            prep.setInt(4, number);
            prep.setInt(5, olId);
            prep.setInt(6, olSupplyId);
            prep.setInt(7, olQuantity);
            prep.setBigDecimal(8, olAmount);
            prep.setString(9, distInfo);
            this.db.update(prep, "insertOrderLine");
            ++number;
        }
        prep = this.prepare("INSERT INTO ORDERS (O_ID, O_D_ID, O_W_ID, O_C_ID, O_ENTRY_D, O_OL_CNT, O_ALL_LOCAL) VALUES (?, ?, ?, ?, ?, ?, ?)");
        prep.setInt(1, oId);
        prep.setInt(2, dId);
        prep.setInt(3, this.warehouseId);
        prep.setInt(4, cId);
        prep.setTimestamp(5, datetime);
        prep.setInt(6, olCnt);
        prep.setInt(7, allLocal);
        this.db.update(prep, "insertOrders");
        prep = this.prepare("INSERT INTO NEW_ORDER (NO_O_ID, NO_D_ID, NO_W_ID) VALUES (?, ?, ?)");
        prep.setInt(1, oId);
        prep.setInt(2, dId);
        prep.setInt(3, this.warehouseId);
        this.db.update(prep, "insertNewOrder");
        this.db.commit();
    }

    private void processPayment() throws SQLException {
        BigDecimal balance;
        String credit;
        String last;
        boolean byName;
        int cdId;
        int wId;
        int dId = this.random.getInt(1, this.bench.districtsPerWarehouse);
        if (this.bench.warehouses > 1 && this.random.getInt(1, 100) <= 15) {
            while ((wId = this.random.getInt(1, this.bench.warehouses)) != this.warehouseId) {
            }
            cdId = this.random.getInt(1, this.bench.districtsPerWarehouse);
        } else {
            wId = this.warehouseId;
            cdId = dId;
        }
        int cId = 1;
        if (this.random.getInt(1, 100) <= 60) {
            byName = true;
            last = this.random.getLastname(this.random.getNonUniform(255, 0, 999));
        } else {
            byName = false;
            last = "";
            cId = this.random.getNonUniform(1023, 1, this.bench.customersPerDistrict);
        }
        BigDecimal amount = this.random.getBigDecimal(this.random.getInt(100, 500000), 2);
        Timestamp datetime = new Timestamp(System.currentTimeMillis());
        PreparedStatement prep = this.prepare("UPDATE DISTRICT SET D_YTD = D_YTD+? WHERE D_ID=? AND D_W_ID=?");
        prep.setBigDecimal(1, amount);
        prep.setInt(2, dId);
        prep.setInt(3, this.warehouseId);
        this.db.update(prep, "updateDistrict");
        prep = this.prepare("UPDATE WAREHOUSE SET W_YTD=W_YTD+? WHERE W_ID=?");
        prep.setBigDecimal(1, amount);
        prep.setInt(2, this.warehouseId);
        this.db.update(prep, "updateWarehouse");
        prep = this.prepare("SELECT W_STREET_1, W_STREET_2, W_CITY, W_STATE, W_ZIP, W_NAME FROM WAREHOUSE WHERE W_ID=?");
        prep.setInt(1, this.warehouseId);
        ResultSet rs = this.db.query(prep);
        rs.next();
        rs.getString(1);
        rs.getString(2);
        rs.getString(3);
        rs.getString(4);
        rs.getString(5);
        String wName = rs.getString(6);
        rs.close();
        prep = this.prepare("SELECT D_STREET_1, D_STREET_2, D_CITY, D_STATE, D_ZIP, D_NAME FROM DISTRICT WHERE D_ID=? AND D_W_ID=?");
        prep.setInt(1, dId);
        prep.setInt(2, this.warehouseId);
        rs = this.db.query(prep);
        rs.next();
        rs.getString(1);
        rs.getString(2);
        rs.getString(3);
        rs.getString(4);
        rs.getString(5);
        String dName = rs.getString(6);
        rs.close();
        if (byName) {
            prep = this.prepare("SELECT COUNT(C_ID) FROM CUSTOMER WHERE C_LAST=? AND C_D_ID=? AND C_W_ID=?");
            prep.setString(1, last);
            prep.setInt(2, cdId);
            prep.setInt(3, wId);
            rs = this.db.query(prep);
            rs.next();
            int namecnt = rs.getInt(1);
            rs.close();
            if (namecnt == 0) {
                this.db.rollback();
                return;
            }
            prep = this.prepare("SELECT C_FIRST, C_MIDDLE, C_ID, C_STREET_1, C_STREET_2, C_CITY, C_STATE, C_ZIP, C_PHONE, C_CREDIT, C_CREDIT_LIM, C_DISCOUNT, C_BALANCE, C_SINCE FROM CUSTOMER WHERE C_LAST=? AND C_D_ID=? AND C_W_ID=? ORDER BY C_FIRST");
            prep.setString(1, last);
            prep.setInt(2, cdId);
            prep.setInt(3, wId);
            rs = this.db.query(prep);
            if (namecnt % 2 != 0) {
                ++namecnt;
            }
            int n = 0;
            while (n < namecnt / 2) {
                rs.next();
                ++n;
            }
            rs.getString(1);
            rs.getString(2);
            cId = rs.getInt(3);
            rs.getString(4);
            rs.getString(5);
            rs.getString(6);
            rs.getString(7);
            rs.getString(8);
            rs.getString(9);
            credit = rs.getString(10);
            rs.getString(11);
            rs.getBigDecimal(12);
            balance = rs.getBigDecimal(13);
            rs.getTimestamp(14);
            rs.close();
        } else {
            prep = this.prepare("SELECT C_FIRST, C_MIDDLE, C_LAST, C_STREET_1, C_STREET_2, C_CITY, C_STATE, C_ZIP, C_PHONE, C_CREDIT, C_CREDIT_LIM, C_DISCOUNT, C_BALANCE, C_SINCE FROM CUSTOMER WHERE C_ID=? AND C_D_ID=? AND C_W_ID=?");
            prep.setInt(1, cId);
            prep.setInt(2, cdId);
            prep.setInt(3, wId);
            rs = this.db.query(prep);
            rs.next();
            rs.getString(1);
            rs.getString(2);
            rs.getString(3);
            rs.getString(4);
            rs.getString(5);
            rs.getString(6);
            rs.getString(7);
            rs.getString(8);
            rs.getString(9);
            credit = rs.getString(10);
            rs.getString(11);
            rs.getBigDecimal(12);
            balance = rs.getBigDecimal(13);
            rs.getTimestamp(14);
            rs.close();
        }
        balance = balance.add(amount);
        if (credit.equals("BC")) {
            prep = this.prepare("SELECT C_DATA INTO FROM CUSTOMER WHERE C_ID=? AND C_D_ID=? AND C_W_ID=?");
            prep.setInt(1, cId);
            prep.setInt(2, cdId);
            prep.setInt(3, wId);
            rs = this.db.query(prep);
            rs.next();
            String cData = rs.getString(1);
            rs.close();
            Object cNewData = "| " + cId + " " + cdId + " " + wId + " " + dId + " " + this.warehouseId + " " + String.valueOf(amount) + " " + cData;
            if (((String)cNewData).length() > 500) {
                cNewData = ((String)cNewData).substring(0, 500);
            }
            prep = this.prepare("UPDATE CUSTOMER SET C_BALANCE=?, C_DATA=? WHERE C_ID=? AND C_D_ID=? AND C_W_ID=?");
            prep.setBigDecimal(1, balance);
            prep.setString(2, (String)cNewData);
            prep.setInt(3, cId);
            prep.setInt(4, cdId);
            prep.setInt(5, wId);
            this.db.update(prep, "updateCustomer");
        } else {
            prep = this.prepare("UPDATE CUSTOMER SET C_BALANCE=? WHERE C_ID=? AND C_D_ID=? AND C_W_ID=?");
            prep.setBigDecimal(1, balance);
            prep.setInt(2, cId);
            prep.setInt(3, cdId);
            prep.setInt(4, wId);
            this.db.update(prep, "updateCustomer");
        }
        String hData = wName + " " + dName;
        prep = this.prepare("INSERT INTO HISTORY (H_C_D_ID, H_C_W_ID, H_C_ID, H_D_ID, H_W_ID, H_DATE, H_AMOUNT, H_DATA) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        prep.setInt(1, cdId);
        prep.setInt(2, wId);
        prep.setInt(3, cId);
        prep.setInt(4, dId);
        prep.setInt(5, this.warehouseId);
        prep.setTimestamp(6, datetime);
        prep.setBigDecimal(7, amount);
        prep.setString(8, hData);
        this.db.update(prep, "insertHistory");
        this.db.commit();
    }

    private void processOrderStatus() throws SQLException {
        ResultSet rs;
        boolean byName;
        int dId = this.random.getInt(1, this.bench.districtsPerWarehouse);
        String last = null;
        int cId = -1;
        if (this.random.getInt(1, 100) <= 60) {
            byName = true;
            last = this.random.getLastname(this.random.getNonUniform(255, 0, 999));
        } else {
            byName = false;
            cId = this.random.getNonUniform(1023, 1, this.bench.customersPerDistrict);
        }
        PreparedStatement prep = this.prepare("UPDATE DISTRICT SET D_NEXT_O_ID=-1 WHERE D_ID=-1");
        this.db.update(prep, "updateDistrict");
        if (byName) {
            prep = this.prepare("SELECT COUNT(C_ID) FROM CUSTOMER WHERE C_LAST=? AND C_D_ID=? AND C_W_ID=?");
            prep.setString(1, last);
            prep.setInt(2, dId);
            prep.setInt(3, this.warehouseId);
            rs = this.db.query(prep);
            rs.next();
            int namecnt = rs.getInt(1);
            rs.close();
            if (namecnt == 0) {
                this.db.rollback();
                return;
            }
            prep = this.prepare("SELECT C_BALANCE, C_FIRST, C_MIDDLE, C_ID FROM CUSTOMER WHERE C_LAST=? AND C_D_ID=? AND C_W_ID=? ORDER BY C_FIRST");
            prep.setString(1, last);
            prep.setInt(2, dId);
            prep.setInt(3, this.warehouseId);
            rs = this.db.query(prep);
            if (namecnt % 2 != 0) {
                ++namecnt;
            }
            int n = 0;
            while (n < namecnt / 2) {
                rs.next();
                ++n;
            }
            rs.getBigDecimal(1);
            rs.getString(2);
            rs.getString(3);
            rs.close();
        } else {
            prep = this.prepare("SELECT C_BALANCE, C_FIRST, C_MIDDLE, C_LAST FROM CUSTOMER WHERE C_ID=? AND C_D_ID=? AND C_W_ID=?");
            prep.setInt(1, cId);
            prep.setInt(2, dId);
            prep.setInt(3, this.warehouseId);
            rs = this.db.query(prep);
            rs.next();
            rs.getBigDecimal(1);
            rs.getString(2);
            rs.getString(3);
            rs.getString(4);
            rs.close();
        }
        prep = this.prepare("SELECT MAX(O_ID) FROM ORDERS WHERE O_C_ID=? AND O_D_ID=? AND O_W_ID=?");
        prep.setInt(1, cId);
        prep.setInt(2, dId);
        prep.setInt(3, this.warehouseId);
        rs = this.db.query(prep);
        int oId = -1;
        if (rs.next()) {
            oId = rs.getInt(1);
            if (rs.wasNull()) {
                oId = -1;
            }
        }
        rs.close();
        if (oId != -1) {
            prep = this.prepare("SELECT O_ID, O_CARRIER_ID, O_ENTRY_D FROM ORDERS WHERE O_ID=?");
            prep.setInt(1, oId);
            rs = this.db.query(prep);
            rs.next();
            oId = rs.getInt(1);
            rs.getInt(2);
            rs.getTimestamp(3);
            rs.close();
            prep = this.prepare("SELECT OL_I_ID, OL_SUPPLY_W_ID, OL_QUANTITY, OL_AMOUNT, OL_DELIVERY_D FROM ORDER_LINE WHERE OL_O_ID=? AND OL_D_ID=? AND OL_W_ID=?");
            prep.setInt(1, oId);
            prep.setInt(2, dId);
            prep.setInt(3, this.warehouseId);
            rs = this.db.query(prep);
            while (rs.next()) {
                rs.getInt(1);
                rs.getInt(2);
                rs.getInt(3);
                rs.getBigDecimal(4);
                rs.getTimestamp(5);
            }
            rs.close();
        }
        this.db.commit();
    }

    private void processDelivery() throws SQLException {
        int carrierId = this.random.getInt(1, 10);
        Timestamp datetime = new Timestamp(System.currentTimeMillis());
        PreparedStatement prep = this.prepare("UPDATE DISTRICT SET D_NEXT_O_ID=-1 WHERE D_ID=-1");
        this.db.update(prep, "updateDistrict");
        int dId = 1;
        while (dId <= this.bench.districtsPerWarehouse) {
            prep = this.prepare("SELECT MIN(NO_O_ID) FROM NEW_ORDER WHERE NO_D_ID=? AND NO_W_ID=?");
            prep.setInt(1, dId);
            prep.setInt(2, this.warehouseId);
            ResultSet rs = this.db.query(prep);
            int noId = -1;
            if (rs.next()) {
                noId = rs.getInt(1);
                if (rs.wasNull()) {
                    noId = -1;
                }
            }
            rs.close();
            if (noId != -1) {
                prep = this.prepare("DELETE FROM NEW_ORDER WHERE NO_O_ID=? AND NO_D_ID=? AND NO_W_ID=?");
                prep.setInt(1, noId);
                prep.setInt(2, dId);
                prep.setInt(3, this.warehouseId);
                this.db.update(prep, "deleteNewOrder");
                prep = this.prepare("SELECT O_C_ID FROM ORDERS WHERE O_ID=? AND O_D_ID=? AND O_W_ID=?");
                prep.setInt(1, noId);
                prep.setInt(2, dId);
                prep.setInt(3, this.warehouseId);
                rs = this.db.query(prep);
                rs.next();
                rs.getInt(1);
                rs.close();
                prep = this.prepare("UPDATE ORDERS SET O_CARRIER_ID=? WHERE O_ID=? AND O_D_ID=? AND O_W_ID=?");
                prep.setInt(1, carrierId);
                prep.setInt(2, noId);
                prep.setInt(3, dId);
                prep.setInt(4, this.warehouseId);
                this.db.update(prep, "updateOrders");
                prep = this.prepare("UPDATE ORDER_LINE SET OL_DELIVERY_D=? WHERE OL_O_ID=? AND OL_D_ID=? AND OL_W_ID=?");
                prep.setTimestamp(1, datetime);
                prep.setInt(2, noId);
                prep.setInt(3, dId);
                prep.setInt(4, this.warehouseId);
                this.db.update(prep, "updateOrderLine");
                prep = this.prepare("SELECT SUM(OL_AMOUNT) FROM ORDER_LINE WHERE OL_O_ID=? AND OL_D_ID=? AND OL_W_ID=?");
                prep.setInt(1, noId);
                prep.setInt(2, dId);
                prep.setInt(3, this.warehouseId);
                rs = this.db.query(prep);
                rs.next();
                BigDecimal amount = rs.getBigDecimal(1);
                rs.close();
                prep = this.prepare("UPDATE CUSTOMER SET C_BALANCE=C_BALANCE+? WHERE C_ID=? AND C_D_ID=? AND C_W_ID=?");
                prep.setBigDecimal(1, amount);
                prep.setInt(2, noId);
                prep.setInt(3, dId);
                prep.setInt(4, this.warehouseId);
                this.db.update(prep, "updateCustomer");
            }
            ++dId;
        }
        this.db.commit();
    }

    private void processStockLevel() throws SQLException {
        int dId = this.terminalId % this.bench.districtsPerWarehouse + 1;
        int threshold = this.random.getInt(10, 20);
        PreparedStatement prep = this.prepare("UPDATE DISTRICT SET D_NEXT_O_ID=-1 WHERE D_ID=-1");
        this.db.update(prep, "updateDistrict");
        prep = this.prepare("SELECT D_NEXT_O_ID FROM DISTRICT WHERE D_ID=? AND D_W_ID=?");
        prep.setInt(1, dId);
        prep.setInt(2, this.warehouseId);
        ResultSet rs = this.db.query(prep);
        rs.next();
        int oId = rs.getInt(1);
        rs.close();
        prep = this.prepare("SELECT COUNT(DISTINCT S_I_ID) FROM ORDER_LINE, STOCK WHERE OL_W_ID=? AND OL_D_ID=? AND OL_O_ID<? AND OL_O_ID>=?-20 AND S_W_ID=? AND S_I_ID=OL_I_ID AND S_QUANTITY<?");
        prep.setInt(1, this.warehouseId);
        prep.setInt(2, dId);
        prep.setInt(3, oId);
        prep.setInt(4, oId);
        prep.setInt(5, this.warehouseId);
        prep.setInt(6, threshold);
        rs = this.db.query(prep);
        rs.next();
        rs.getInt(1);
        rs.close();
        this.db.commit();
    }

    private PreparedStatement prepare(String sql) throws SQLException {
        PreparedStatement prep = this.prepared.get(sql);
        if (prep == null) {
            prep = this.db.prepare(sql);
            this.prepared.put(sql, prep);
        }
        return prep;
    }
}

