/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.bench;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.h2.Driver;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.bench.Bench;
import org.h2.test.bench.Database;
import org.h2.util.JdbcUtils;

public class TestPerformance
implements Database.DatabaseTest {
    boolean collect;
    boolean trace;

    public static void main(String ... args) throws Exception {
        new TestPerformance().test(args);
    }

    private static Connection getResultConnection() throws SQLException {
        Driver.load();
        return DriverManager.getConnection("jdbc:h2:./data/results");
    }

    private static void openResults() throws SQLException {
        Connection conn = null;
        Statement stat = null;
        try {
            conn = TestPerformance.getResultConnection();
            stat = conn.createStatement();
            stat.execute("CREATE TABLE IF NOT EXISTS RESULTS(TESTID INT, TEST VARCHAR, UNIT VARCHAR, DBID INT, DB VARCHAR, RESULT VARCHAR)");
        }
        catch (Throwable throwable) {
            JdbcUtils.closeSilently(stat);
            JdbcUtils.closeSilently(conn);
            throw throwable;
        }
        JdbcUtils.closeSilently(stat);
        JdbcUtils.closeSilently(conn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void test(String ... args) throws Exception {
        boolean exit;
        block54: {
            int dbId = -1;
            exit = false;
            String out = "benchmark.html";
            Properties prop = this.loadProperties();
            int size = Integer.parseInt(prop.getProperty("size"));
            int i = 0;
            while (true) {
                if (i >= args.length) break;
                String arg = args[i];
                if ("-db".equals(arg)) {
                    dbId = Integer.parseInt(args[++i]);
                } else if ("-init".equals(arg)) {
                    FileUtils.deleteRecursive("data", true);
                } else if ("-out".equals(arg)) {
                    out = args[++i];
                } else if ("-trace".equals(arg)) {
                    this.trace = true;
                } else if ("-exit".equals(arg)) {
                    exit = true;
                } else if ("-size".equals(arg)) {
                    size = Integer.parseInt(args[++i]);
                }
                ++i;
            }
            ArrayList<Database> dbs = new ArrayList<Database>();
            int i2 = 0;
            while (true) {
                Database db;
                String dbString;
                if (i2 >= 100) break;
                if ((dbId == -1 || i2 == dbId) && (dbString = prop.getProperty("db" + i2)) != null && (db = Database.parse(this, i2, dbString, prop)) != null) {
                    dbs.add(db);
                }
                ++i2;
            }
            ArrayList<Bench> tests = new ArrayList<Bench>();
            int i3 = 0;
            while (true) {
                if (i3 >= 100) {
                    this.testAll(dbs, tests, size);
                    this.collect = false;
                    if (!dbs.isEmpty()) break;
                    return;
                }
                String testString = prop.getProperty("test" + i3);
                if (testString != null) {
                    Bench bench = (Bench)Class.forName(testString).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    tests.add(bench);
                }
                ++i3;
            }
            ArrayList<Database.Measurement> results = dbs.get(0).getResults();
            Throwable throwable = null;
            Object var11_17 = null;
            try (Connection conn = TestPerformance.getResultConnection();){
                TestPerformance.openResults();
                Throwable throwable2 = null;
                Object var14_23 = null;
                try (PreparedStatement prep = conn.prepareStatement("INSERT INTO RESULTS(TESTID, TEST, UNIT, DBID, DB, RESULT) VALUES(?, ?, ?, ?, ?, ?)");){
                    int i4 = 0;
                    block22: while (i4 < results.size()) {
                        Database.Measurement res = results.get(i4);
                        prep.setInt(1, i4);
                        prep.setString(2, res.name);
                        prep.setString(3, res.unit);
                        Iterator<Database> iterator = dbs.iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                ++i4;
                                continue block22;
                            }
                            Database db = iterator.next();
                            prep.setInt(4, db.getId());
                            prep.setString(5, db.getName());
                            Database.Measurement measurement = db.getResults().get(i4);
                            prep.setString(6, String.valueOf(measurement.value));
                            prep.execute();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                        throw throwable2;
                    }
                    if (throwable2 == throwable3) throw throwable2;
                    throwable2.addSuppressed(throwable3);
                    throw throwable2;
                }
                throwable2 = null;
                var14_23 = null;
                try {
                    Statement stat = conn.createStatement();
                    try {
                        PrintWriter writer = new PrintWriter(new FileWriter(out));
                        try {
                            try (ResultSet rs = stat.executeQuery("CALL '<table><tr><th>Test Case</th><th>Unit</th>' || (SELECT GROUP_CONCAT('<th>' || DB || '</th>' ORDER BY DBID SEPARATOR '') FROM (SELECT DISTINCT DBID, DB FROM RESULTS))|| '</tr>' || CHAR(10) || (SELECT GROUP_CONCAT('<tr><td>' || TEST || '</td><td>' || UNIT || '</td>' || ( SELECT GROUP_CONCAT('<td>' || RESULT || '</td>' ORDER BY DBID SEPARATOR '') FROM RESULTS R2 WHERE R2.TESTID = R1.TESTID) || '</tr>' ORDER BY TESTID SEPARATOR CHAR(10)) FROM (SELECT DISTINCT TESTID, TEST, UNIT FROM RESULTS) R1)|| '</table>'");){
                                rs.next();
                                String result = rs.getString(1);
                                writer.println(result);
                            }
                            if (writer != null) {
                                writer.close();
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            if (writer == null) throw throwable2;
                            writer.close();
                            throw throwable2;
                        }
                        if (stat == null) break block54;
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        if (stat == null) throw throwable2;
                        stat.close();
                        throw throwable2;
                    }
                    stat.close();
                }
                catch (Throwable throwable6) {
                    if (throwable2 == null) {
                        throwable2 = throwable6;
                        throw throwable2;
                    }
                    if (throwable2 == throwable6) throw throwable2;
                    throwable2.addSuppressed(throwable6);
                    throw throwable2;
                }
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                    throw throwable;
                }
                if (throwable == throwable7) throw throwable;
                throwable.addSuppressed(throwable7);
                throw throwable;
            }
        }
        if (!exit) return;
        System.exit(0);
    }

    private void testAll(ArrayList<Database> dbs, ArrayList<Bench> tests, int size) throws Exception {
        int i = 0;
        while (i < dbs.size()) {
            if (i > 0) {
                Thread.sleep(1000L);
            }
            TestBase.getMemoryUsed();
            Database db = dbs.get(i);
            System.out.println();
            System.out.println("Testing the performance of " + db.getName());
            db.startServer();
            Connection conn = db.openNewConnection();
            DatabaseMetaData meta = conn.getMetaData();
            System.out.println("Database: " + meta.getDatabaseProductName() + " " + meta.getDatabaseProductVersion());
            System.out.println("Driver: " + meta.getDriverName() + " " + meta.getDriverVersion());
            TestPerformance.runDatabase(db, tests, 1);
            TestPerformance.runDatabase(db, tests, 1);
            db.reset();
            this.collect = true;
            TestPerformance.runDatabase(db, tests, size);
            conn.close();
            db.log("Executed statements", "#", db.getExecutedStatements());
            db.log("Total time", "ms", db.getTotalTime());
            System.out.println("Total time: " + db.getTotalTime() + " ms");
            int statPerSec = (int)((long)db.getExecutedStatements() * 1000L / (long)db.getTotalTime());
            db.log("Statements per second", "#/s", statPerSec);
            System.out.println("Statements per second: " + statPerSec);
            System.out.println("GC overhead: " + 100 * db.getTotalGCTime() / db.getTotalTime() + "%");
            this.collect = false;
            db.stopServer();
            ++i;
        }
    }

    private static void runDatabase(Database db, ArrayList<Bench> tests, int size) throws Exception {
        for (Bench bench : tests) {
            TestPerformance.runTest(db, bench, size);
        }
    }

    private static void runTest(Database db, Bench bench, int size) throws Exception {
        bench.init(db, size);
        bench.runTest();
    }

    @Override
    public void trace(String msg) {
        if (this.trace) {
            System.out.println(msg);
        }
    }

    @Override
    public boolean isCollect() {
        return this.collect;
    }
}

