/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.bench;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.h2.Driver;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.bench.BenchB;
import org.h2.test.bench.Database;

public class TestScalability
implements Database.DatabaseTest {
    boolean collect;
    boolean trace;

    public static void main(String ... args) throws Exception {
        new TestScalability().test(args);
    }

    private static Connection getResultConnection() throws SQLException {
        Driver.load();
        return DriverManager.getConnection("jdbc:h2:./data/results");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void openResults() throws SQLException {
        Throwable throwable = null;
        Object var1_2 = null;
        try {
            Connection conn = TestScalability.getResultConnection();
            try {
                try (Statement stat = conn.createStatement();){
                    stat.execute("CREATE TABLE IF NOT EXISTS RESULTS(TESTID INT, TEST VARCHAR, UNIT VARCHAR, DBID INT, DB VARCHAR, TCNT INT, RESULT VARCHAR)");
                }
                if (conn == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            conn.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void test(String ... args) throws Exception {
        dbId = -1;
        exit = false;
        out = "scalability.html";
        size = 400;
        i = 0;
        while (i < args.length) {
            arg = args[i];
            if ("-db".equals(arg)) {
                dbId = Integer.parseInt(args[++i]);
            } else if ("-init".equals(arg)) {
                FileUtils.deleteRecursive("data", true);
            } else if ("-out".equals(arg)) {
                out = args[++i];
            } else if ("-trace".equals(arg)) {
                this.trace = true;
            } else if ("-exit".equals(arg)) {
                exit = true;
            } else if ("-size".equals(arg)) {
                size = Integer.parseInt(args[++i]);
            }
            ++i;
        }
        prop = this.loadProperties();
        dbs = new ArrayList<RunSequence>();
        id = 0;
        while (id < 100) {
            if ((dbId == -1 || id == dbId) && (dbString = prop.getProperty("db" + id)) != null && (db = Database.parse(this, id, dbString, prop)) != null) {
                runCount = 8;
                valueStr = prop.getProperty("runCount" + id);
                if (valueStr != null) {
                    runCount = Integer.parseInt(valueStr);
                }
                dbs.add(new RunSequence(db, runCount));
            }
            ++id;
        }
        test = new BenchB(){

            @Override
            protected int getTransactionsPerClient(int size) {
                return size * 8;
            }
        };
        this.testAll(dbs, test, size);
        results = dbs.get((int)0).results.get(0);
        var10_12 = null;
        var11_15 = null;
        try {
            conn = TestScalability.getResultConnection();
            try {
                TestScalability.openResults();
                var13_18 = null;
                var14_21 = null;
                try {
                    prep = conn.prepareStatement("INSERT INTO RESULTS(TESTID, TEST, UNIT, DBID, DB, TCNT, RESULT) VALUES(?, ?, ?, ?, ?, ?, ?)");
                    try {
                        i = 0;
                        while (i < results.size()) {
                            res = results.get(i);
                            prep.setInt(1, i);
                            prep.setString(2, res.name);
                            prep.setString(3, res.unit);
                            for (RunSequence runSequence : dbs) {
                                db = runSequence.database;
                                threadCount = 1;
                                for (List<Database.Measurement> result : runSequence.results) {
                                    if (result.size() <= i) continue;
                                    measurement = result.get(i);
                                    prep.setInt(4, db.getId());
                                    prep.setString(5, db.getName());
                                    prep.setInt(6, threadCount);
                                    prep.setString(7, String.valueOf(measurement.value));
                                    prep.execute();
                                    threadCount <<= 1;
                                }
                            }
                            ++i;
                        }
                    }
                    finally {
                        if (prep != null) {
                            prep.close();
                        }
                    }
                }
                catch (Throwable var14_22) {
                    if (var13_18 == null) {
                        var13_18 = var14_22;
                    } else if (var13_18 != var14_22) {
                        var13_18.addSuppressed(var14_22);
                    }
                    throw var13_18;
                }
                var13_18 = null;
                var14_21 = null;
                try {
                    stat = conn.createStatement();
                    try {
                        writer = new PrintWriter(new FileWriter(out));
                        try {
                            rs = stat.executeQuery("CALL '<table border=\"1\"><tr><th rowspan=\"2\">Test Case</th><th rowspan=\"2\">Unit</th>' || (SELECT GROUP_CONCAT('<th colspan=\"' || COLSPAN || '\">' || TCNT || '</th>' ORDER BY TCNT SEPARATOR '') FROM (SELECT TCNT, COUNT(*) COLSPAN FROM (SELECT DISTINCT DB, TCNT FROM RESULTS) GROUP BY TCNT))|| '</tr>' || CHAR(10) || '<tr>' || (SELECT GROUP_CONCAT('<th>' || DB || '</th>' ORDER BY TCNT, DB SEPARATOR '') FROM (SELECT DISTINCT DB, TCNT FROM RESULTS)) || '</tr>' || CHAR(10) || (SELECT GROUP_CONCAT('<tr><td>' || TEST || '</td><td>' || UNIT || '</td>' || ( SELECT GROUP_CONCAT('<td>' || RESULT || '</td>' ORDER BY TCNT,DB SEPARATOR '') FROM RESULTS R2 WHERE R2.TESTID = R1.TESTID) || '</tr>' ORDER BY TESTID SEPARATOR CHAR(10)) FROM (SELECT DISTINCT TESTID, TEST, UNIT FROM RESULTS) R1)|| '</table>'");
                            try {
                                rs.next();
                                result = rs.getString(1);
                                writer.println(result);
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                            if (writer != null) {
                                writer.close();
                            }
                        }
                        catch (Throwable var14_23) {
                            if (var13_18 == null) {
                                var13_18 = var14_23;
                            } else if (var13_18 != var14_23) {
                                var13_18.addSuppressed(var14_23);
                            }
                            if (writer != null) {
                                writer.close();
                            }
                            throw var13_18;
                        }
                        ** if (stat == null) goto lbl-1000
                    }
                    catch (Throwable var14_24) {
                        if (var13_18 == null) {
                            var13_18 = var14_24;
                        } else if (var13_18 != var14_24) {
                            var13_18.addSuppressed(var14_24);
                        }
                        if (stat != null) {
                            stat.close();
                        }
                        throw var13_18;
                    }
lbl-1000:
                    // 1 sources

                    {
                        stat.close();
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
                catch (Throwable var14_25) {
                    if (var13_18 == null) {
                        var13_18 = var14_25;
                    } else if (var13_18 != var14_25) {
                        var13_18.addSuppressed(var14_25);
                    }
                    throw var13_18;
                }
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable var11_16) {
            if (var10_12 == null) {
                var10_12 = var11_16;
            } else if (var10_12 != var11_16) {
                var10_12.addSuppressed(var11_16);
            }
            throw var10_12;
        }
        if (exit) {
            System.exit(0);
        }
    }

    private void testAll(ArrayList<RunSequence> runSequences, BenchB test, int size) throws Exception {
        Database lastDb = null;
        Connection conn = null;
        for (RunSequence runSequence : runSequences) {
            Database db = runSequence.database;
            try {
                try {
                    if (lastDb != null) {
                        conn.close();
                        lastDb.stopServer();
                        Thread.sleep(1000L);
                        TestBase.getMemoryUsed();
                    }
                    String dbName = db.getName();
                    System.out.println("------------------");
                    System.out.println("Testing the performance of " + dbName);
                    db.startServer();
                    conn = db.openNewConnection();
                    test.init(db, size);
                    int runNo = 0;
                    int threadCount = 1;
                    while (runNo < runSequence.runCount) {
                        System.out.println("Testing the performance of " + dbName + " (" + threadCount + " threads)");
                        DatabaseMetaData meta = conn.getMetaData();
                        System.out.println(" " + meta.getDatabaseProductName() + " " + meta.getDatabaseProductVersion());
                        test.setThreadCount(threadCount);
                        test.runTest();
                        test.runTest();
                        db.reset();
                        this.collect = true;
                        test.runTest();
                        int executedStatements = db.getExecutedStatements();
                        int totalTime = db.getTotalTime();
                        int totalGCTime = db.getTotalGCTime();
                        db.log("Executed statements", "#", executedStatements);
                        db.log("Total time", "ms", totalTime);
                        int statPerSec = (int)((long)executedStatements * 1000L / (long)totalTime);
                        db.log("Statements per second", "#/s", statPerSec);
                        this.collect = false;
                        System.out.println("Statements per second: " + statPerSec);
                        System.out.println("GC overhead: " + 100 * totalGCTime / totalTime + "%");
                        ArrayList<Database.Measurement> measurements = db.reset();
                        runSequence.results.add(measurements);
                        ++runNo;
                        threadCount <<= 1;
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    lastDb = db;
                    continue;
                }
            }
            catch (Throwable throwable) {
                lastDb = db;
                throw throwable;
            }
            lastDb = db;
        }
        if (lastDb != null) {
            conn.close();
            lastDb.stopServer();
        }
    }

    @Override
    public void trace(String s) {
        if (this.trace) {
            System.out.println(s);
        }
    }

    @Override
    public boolean isCollect() {
        return this.collect;
    }

    private static final class RunSequence {
        final Database database;
        final int runCount;
        final List<List<Database.Measurement>> results = new ArrayList<List<Database.Measurement>>();

        public RunSequence(Database dataBase, int runCount) {
            this.database = dataBase;
            this.runCount = runCount;
        }
    }
}

