/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.coverage;

import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.concurrent.TimeUnit;
import org.h2.util.IOUtils;

public class Profile
extends Thread {
    private static final boolean LIST_UNVISITED = false;
    private static final boolean TRACE = false;
    private static final Profile MAIN = new Profile();
    private static int top = 15;
    private int[] count;
    private int[] time;
    private boolean stop;
    private int maxIndex;
    private int lastIndex;
    private long lastTimeNs;
    private BufferedWriter trace;

    static {
        try {
            String s = System.getProperty("profile.top");
            if (s != null) {
                top = Integer.parseInt(s);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Profile() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (LineNumberReader r = new LineNumberReader(new FileReader("profile.txt"));){
                while (r.readLine() != null) {
                }
                this.maxIndex = r.getLineNumber();
                this.count = new int[this.maxIndex];
                this.time = new int[this.maxIndex];
                this.lastTimeNs = System.nanoTime();
                Runtime.getRuntime().addShutdownHook(this);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void visit(int i) {
        MAIN.addVisit(i);
    }

    @Override
    public void run() {
        Profile.list();
    }

    public static void startCollecting() {
        Profile.MAIN.stop = false;
        Profile.MAIN.lastTimeNs = System.nanoTime();
    }

    public static void stopCollecting() {
        Profile.MAIN.stop = true;
    }

    public static void list() {
        if (Profile.MAIN.lastIndex == 0) {
            return;
        }
        try {
            MAIN.listUnvisited();
            MAIN.listTop("MOST CALLED", Profile.MAIN.count, top);
            MAIN.listTop("MOST TIME USED", Profile.MAIN.time, top);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addVisit(int i) {
        if (this.stop) {
            return;
        }
        long now = System.nanoTime();
        int n = i;
        this.count[n] = this.count[n] + 1;
        int n2 = this.lastIndex;
        this.time[n2] = this.time[n2] + (int)TimeUnit.NANOSECONDS.toMillis(now - this.lastTimeNs);
        this.lastTimeNs = now;
        this.lastIndex = i;
    }

    private void listUnvisited() throws IOException {
        Profile.printLine('=');
        Profile.print("NOT COVERED");
        Profile.printLine('-');
        LineNumberReader r = null;
        BufferedWriter writer = null;
        try {
            r = new LineNumberReader(new FileReader("profile.txt"));
            writer = new BufferedWriter(new FileWriter("notCovered.txt"));
            int unvisited = 0;
            int unvisitedThrow = 0;
            int i = 0;
            while (i < this.maxIndex) {
                String line = r.readLine();
                if (this.count[i] == 0) {
                    if (!line.endsWith("throw")) {
                        writer.write(line + "\r\n");
                        ++unvisited;
                    } else {
                        ++unvisitedThrow;
                    }
                }
                ++i;
            }
            int percent = 100 * unvisited / this.maxIndex;
            Profile.print("Not covered: " + percent + " %  (" + unvisited + " of " + this.maxIndex + "; throw=" + unvisitedThrow + ")");
        }
        catch (Throwable throwable) {
            IOUtils.closeSilently(writer);
            IOUtils.closeSilently(r);
            throw throwable;
        }
        IOUtils.closeSilently(writer);
        IOUtils.closeSilently(r);
    }

    private void listTop(String title, int[] list, int max) throws IOException {
        Profile.printLine('-');
        int total = 0;
        int totalLines = 0;
        int j = 0;
        while (j < this.maxIndex) {
            int l = list[j];
            if (l > 0) {
                total += list[j];
                ++totalLines;
            }
            ++j;
        }
        if (max == 0) {
            max = totalLines;
        }
        Profile.print(title);
        Profile.print("Total: " + total);
        Profile.printLine('-');
        String[] text = new String[max];
        int[] index = new int[max];
        int i = 0;
        while (i < max) {
            int big = list[0];
            int bigIndex = 0;
            int j2 = 1;
            while (j2 < this.maxIndex) {
                int l = list[j2];
                if (l > big) {
                    big = l;
                    bigIndex = j2;
                }
                ++j2;
            }
            list[bigIndex] = -(big + 1);
            index[i] = bigIndex;
            ++i;
        }
        Throwable throwable = null;
        Object var9_14 = null;
        try (LineNumberReader r = new LineNumberReader(new FileReader("profile.txt"));){
            int i2 = 0;
            while (i2 < this.maxIndex) {
                String line = r.readLine();
                int k = list[i2];
                if (k < 0) {
                    list[i2] = k = -(k + 1);
                    int j3 = 0;
                    while (j3 < max) {
                        if (index[j3] == i2) {
                            int percent = 100 * k / total;
                            text[j3] = k + " " + percent + "%: " + line;
                        }
                        ++j3;
                    }
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < max) {
                Profile.print(text[i2]);
                ++i2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void print(String s) {
        System.out.println(s);
    }

    private static void printLine(char c) {
        int i = 0;
        while (i < 60) {
            System.out.print(c);
            ++i;
        }
        Profile.print("");
    }
}

