/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.coverage;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;

public class Tokenizer {
    static final int TYPE_EOF = -1;
    private static final int TYPE_WORD = -2;
    private static final int TYPE_NOTHING = -3;
    private static final byte WHITESPACE = 1;
    private static final byte ALPHA = 4;
    private static final byte QUOTE = 8;
    private StringBuilder buffer;
    private Reader reader;
    private char[] chars = new char[20];
    private int peekChar;
    private int line = 1;
    private byte[] charTypes = new byte[256];
    private int type = -3;
    private String value;

    private Tokenizer() {
        this.wordChars(97, 122);
        this.wordChars(65, 90);
        this.wordChars(48, 57);
        this.wordChars(46, 46);
        this.wordChars(43, 43);
        this.wordChars(45, 45);
        this.wordChars(95, 95);
        this.wordChars(160, 255);
        this.whitespaceChars(0, 32);
        this.charTypes[34] = 8;
        this.charTypes[39] = 8;
    }

    Tokenizer(Reader r) {
        this();
        this.reader = r;
    }

    String getString() {
        return this.value;
    }

    private void wordChars(int low, int hi) {
        while (low <= hi) {
            int n = low++;
            this.charTypes[n] = (byte)(this.charTypes[n] | 4);
        }
    }

    private void whitespaceChars(int low, int hi) {
        while (low <= hi) {
            this.charTypes[low++] = 1;
        }
    }

    private int read() throws IOException {
        int i = this.reader.read();
        if (i != -1) {
            this.append(i);
        }
        return i;
    }

    void initToken() {
        this.buffer = new StringBuilder();
    }

    String getToken() {
        this.buffer.setLength(this.buffer.length() - 1);
        return this.buffer.toString();
    }

    private void append(int i) {
        this.buffer.append((char)i);
    }

    int nextToken() throws IOException {
        int c;
        byte[] ct = this.charTypes;
        this.value = null;
        if (this.type == -3) {
            c = this.read();
            if (c >= 0) {
                this.type = c;
            }
        } else {
            c = this.peekChar;
            if (c < 0) {
                try {
                    c = this.read();
                    if (c >= 0) {
                        this.type = c;
                    }
                }
                catch (EOFException e) {
                    c = -1;
                }
            }
        }
        if (c < 0) {
            this.type = -1;
            return -1;
        }
        int charType = c < 256 ? ct[c] : 4;
        while ((charType & 1) != 0) {
            if (c == 13) {
                ++this.line;
                c = this.read();
                if (c == 10) {
                    c = this.read();
                }
            } else {
                if (c == 10) {
                    ++this.line;
                }
                c = this.read();
            }
            if (c < 0) {
                this.type = -1;
                return -1;
            }
            int n = charType = c < 256 ? ct[c] : 4;
        }
        if ((charType & 4) != 0) {
            this.initToken();
            this.append(c);
            int i = 0;
            do {
                if (i >= this.chars.length) {
                    this.chars = Arrays.copyOf(this.chars, this.chars.length * 2);
                }
                this.chars[i++] = (char)c;
            } while (((charType = (c = this.read()) < 0 ? 1 : (c < 256 ? ct[c] : 4)) & 4) != 0);
            this.peekChar = c;
            this.value = String.copyValueOf(this.chars, 0, i);
            this.type = -2;
            return -2;
        }
        if ((charType & 8) != 0) {
            this.initToken();
            this.append(c);
            this.type = c;
            int i = 0;
            this.peekChar = this.read();
            while (this.peekChar >= 0 && this.peekChar != this.type && this.peekChar != 10 && this.peekChar != 13) {
                if (this.peekChar == 92) {
                    int first = c = this.read();
                    if (c >= 48 && c <= 55) {
                        c -= 48;
                        int c2 = this.read();
                        if (48 <= c2 && c2 <= 55) {
                            c = (c << 3) + (c2 - 48);
                            c2 = this.read();
                            if (48 <= c2 && c2 <= 55 && first <= 51) {
                                c = (c << 3) + (c2 - 48);
                                this.peekChar = this.read();
                            } else {
                                this.peekChar = c2;
                            }
                        } else {
                            this.peekChar = c2;
                        }
                    } else {
                        switch (c) {
                            case 98: {
                                c = 8;
                                break;
                            }
                            case 102: {
                                c = 12;
                                break;
                            }
                            case 110: {
                                c = 10;
                                break;
                            }
                            case 114: {
                                c = 13;
                                break;
                            }
                            case 116: {
                                c = 9;
                            }
                        }
                        this.peekChar = this.read();
                    }
                } else {
                    c = this.peekChar;
                    this.peekChar = this.read();
                }
                if (i >= this.chars.length) {
                    this.chars = Arrays.copyOf(this.chars, this.chars.length * 2);
                }
                this.chars[i++] = (char)c;
            }
            if (this.peekChar == this.type) {
                this.peekChar = this.read();
            }
            this.value = String.copyValueOf(this.chars, 0, i);
            return this.type;
        }
        if (c == 47) {
            c = this.read();
            if (c == 42) {
                int prevChar = 0;
                while ((c = this.read()) != 47 || prevChar != 42) {
                    if (c == 13) {
                        ++this.line;
                        c = this.read();
                        if (c == 10) {
                            c = this.read();
                        }
                    } else if (c == 10) {
                        ++this.line;
                        c = this.read();
                    }
                    if (c < 0) {
                        this.type = -1;
                        return -1;
                    }
                    prevChar = c;
                }
                this.peekChar = this.read();
                return this.nextToken();
            }
            if (c == 47) {
                while ((c = this.read()) != 10 && c != 13 && c >= 0) {
                }
                this.peekChar = c;
                return this.nextToken();
            }
            this.peekChar = c;
            this.type = 47;
            return 47;
        }
        this.peekChar = this.read();
        this.type = c;
        return this.type;
    }

    int getLine() {
        return this.line;
    }
}

