/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Db {
    private Connection conn;
    private Statement stat;
    private final HashMap<String, PreparedStatement> prepared = new HashMap();

    public Db(Connection conn) {
        try {
            this.conn = conn;
            this.stat = conn.createStatement();
        }
        catch (SQLException e) {
            throw Db.convert(e);
        }
    }

    public Prepared prepare(String sql) {
        try {
            PreparedStatement prep = this.prepared.get(sql);
            if (prep == null) {
                prep = this.conn.prepareStatement(sql);
                this.prepared.put(sql, prep);
            }
            return new Prepared(this.conn.prepareStatement(sql));
        }
        catch (SQLException e) {
            throw Db.convert(e);
        }
    }

    public void execute(String sql) {
        try {
            this.stat.execute(sql);
        }
        catch (SQLException e) {
            throw Db.convert(e);
        }
    }

    static List<Map<String, Object>> query(ResultSet rs) throws SQLException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        while (rs.next()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            int i = 0;
            while (i < columnCount) {
                map.put(meta.getColumnLabel(i + 1), rs.getObject(i + 1));
                ++i;
            }
            list.add(map);
        }
        return list;
    }

    public List<Map<String, Object>> query(String sql) {
        try {
            return Db.query(this.stat.executeQuery(sql));
        }
        catch (SQLException e) {
            throw Db.convert(e);
        }
    }

    public void close() {
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            throw Db.convert(e);
        }
    }

    static RuntimeException convert(Exception e) {
        return new RuntimeException(e.toString(), e);
    }

    public void setAutoCommit(boolean autoCommit) {
        try {
            this.conn.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            throw Db.convert(e);
        }
    }

    public void commit() {
        try {
            this.conn.commit();
        }
        catch (SQLException e) {
            throw Db.convert(e);
        }
    }

    public static class Prepared {
        private final PreparedStatement prep;
        private int index;

        Prepared(PreparedStatement prep) {
            this.prep = prep;
        }

        public Prepared set(int x) {
            try {
                this.prep.setInt(++this.index, x);
                return this;
            }
            catch (SQLException e) {
                throw Db.convert(e);
            }
        }

        public Prepared set(String x) {
            try {
                this.prep.setString(++this.index, x);
                return this;
            }
            catch (SQLException e) {
                throw Db.convert(e);
            }
        }

        public Prepared set(byte[] x) {
            try {
                this.prep.setBytes(++this.index, x);
                return this;
            }
            catch (SQLException e) {
                throw Db.convert(e);
            }
        }

        public Prepared set(InputStream x) {
            try {
                this.prep.setBinaryStream(++this.index, x, -1);
                return this;
            }
            catch (SQLException e) {
                throw Db.convert(e);
            }
        }

        public void execute() {
            try {
                this.prep.execute();
            }
            catch (SQLException e) {
                throw Db.convert(e);
            }
        }

        public List<Map<String, Object>> query() {
            try {
                return Db.query(this.prep.executeQuery());
            }
            catch (SQLException e) {
                throw Db.convert(e);
            }
        }
    }
}

