/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import org.h2.test.TestBase;
import org.h2.test.db.TaskDef;
import org.h2.test.utils.SelfDestructor;
import org.h2.util.StringUtils;
import org.h2.util.Task;

public class TaskProcess {
    private final TaskDef taskDef;
    private Process process;
    private BufferedReader reader;
    private BufferedWriter writer;

    public TaskProcess(TaskDef taskDef) {
        this.taskDef = taskDef;
    }

    public void start(String ... args) {
        try {
            String selfDestruct = SelfDestructor.getPropertyString(60);
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(TestBase.getJVM());
            list.add(selfDestruct);
            list.add("-cp");
            list.add("bin" + File.pathSeparator + ".");
            list.add(TaskDef.class.getName());
            list.add(this.taskDef.getClass().getName());
            if (args != null && args.length > 0) {
                list.addAll(Arrays.asList(args));
            }
            String[] procDef = list.toArray(new String[0]);
            this.process = Runtime.getRuntime().exec(procDef);
            TaskProcess.copyInThread(this.process.getErrorStream(), System.err);
            this.reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            this.writer = new BufferedWriter(new OutputStreamWriter(this.process.getOutputStream()));
            String line = this.reader.readLine();
            if (line == null) {
                throw new RuntimeException("No reply from process, command: " + StringUtils.arrayCombine(procDef, ' '));
            }
            if (!line.startsWith("running") && line.startsWith("init error")) {
                throw new RuntimeException(line);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Error starting task", t);
        }
    }

    private static void copyInThread(final InputStream in, final OutputStream out) {
        new Task(){

            @Override
            public void call() throws IOException {
                int x;
                while ((x = in.read()) >= 0) {
                    if (out == null) continue;
                    out.write(x);
                }
                return;
            }
        }.execute();
    }

    public String receive() {
        try {
            return this.reader.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading", e);
        }
    }

    public void send(String message) {
        try {
            this.writer.write(message + "\n");
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing " + message, e);
        }
    }

    public void destroy() {
        this.process.destroy();
    }
}

