/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestAlterSchemaRename
extends TestDb {
    private Connection conn;
    private Statement stat;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.deleteDb(this.getTestName());
        this.conn = this.getConnection(this.getTestName());
        this.stat = this.conn.createStatement();
        this.testTryToRenameSystemSchemas();
        this.testSimpleRename();
        this.testRenameToExistingSchema();
        this.testCrossSchemaViews();
        this.testAlias();
        this.conn.close();
        this.deleteDb(this.getTestName());
    }

    private void testTryToRenameSystemSchemas() throws SQLException {
        this.assertThrows(90090, this.stat).execute("alter schema information_schema rename to test_info");
        this.stat.execute("create sequence test_sequence");
        this.assertThrows(90090, this.stat).execute("alter schema public rename to test_schema");
    }

    private void testSimpleRename() throws SQLException {
        this.stat.execute("create schema s1");
        this.stat.execute("create table s1.tab(val int)");
        this.stat.execute("insert into s1.tab(val) values (3)");
        ResultSet rs = this.stat.executeQuery("select * from s1.tab");
        this.assertTrue(rs.next());
        this.assertEquals(3, rs.getInt(1));
        this.stat.execute("alter schema s1 rename to s2");
        rs = this.stat.executeQuery("select * from s2.tab");
        this.assertTrue(rs.next());
        this.assertEquals(3, rs.getInt(1));
        this.stat.execute("drop schema s2 cascade");
    }

    private void testRenameToExistingSchema() throws SQLException {
        this.stat.execute("create schema s1");
        this.stat.execute("create schema s2");
        this.assertThrows(90078, this.stat).execute("alter schema s1 rename to s2");
        this.stat.execute("drop schema s1");
        this.stat.execute("drop schema s2");
    }

    private void testCrossSchemaViews() throws SQLException {
        this.stat.execute("create schema s1");
        this.stat.execute("create schema s2");
        this.stat.execute("create table s1.tab(val int)");
        this.stat.execute("insert into s1.tab(val) values (3)");
        this.stat.execute("create view s1.v1 as select * from s1.tab");
        this.stat.execute("create view s2.v1 as select val * 2 from s1.tab");
        this.stat.execute("alter schema s2 rename to s2_new");
        ResultSet rs = this.stat.executeQuery("select * from s1.v1");
        this.assertTrue(rs.next());
        this.assertEquals(3, rs.getInt(1));
        rs = this.stat.executeQuery("select * from s2_new.v1");
        this.assertTrue(rs.next());
        this.assertEquals(6, rs.getInt(1));
        if (!this.config.memory) {
            this.conn.close();
            this.conn = this.getConnection(this.getTestName());
            this.stat = this.conn.createStatement();
            this.stat.executeQuery("select * from s2_new.v1");
        }
        this.stat.execute("drop schema s1 cascade");
        this.stat.execute("drop schema s2_new cascade");
    }

    private void testAlias() throws SQLException {
        this.stat.execute("create schema s1");
        this.stat.execute("CREATE ALIAS S1.REVERSE AS $$ String reverse(String s) {   return new StringBuilder(s).reverse().toString();} $$;");
        this.stat.execute("alter schema s1 rename to s2");
        ResultSet rs = this.stat.executeQuery("CALL S2.REVERSE('1234')");
        this.assertTrue(rs.next());
        this.assertEquals("4321", rs.getString(1));
        if (!this.config.memory) {
            this.conn.close();
            this.conn = this.getConnection(this.getTestName());
            this.stat = this.conn.createStatement();
            this.stat.executeQuery("CALL S2.REVERSE('1234')");
        }
        this.stat.execute("drop schema s2 cascade");
    }
}

