/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestAlterTableNotFound
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testWithoutAnyCandidate();
        this.testWithoutAnyCandidateWhenDatabaseToLower();
        this.testWithoutAnyCandidateWhenDatabaseToUpper();
        this.testWithoutAnyCandidateWhenCaseInsensitiveIdentifiers();
        this.testWithOneCandidate();
        this.testWithOneCandidateWhenDatabaseToLower();
        this.testWithOneCandidateWhenDatabaseToUpper();
        this.testWithOneCandidateWhenCaseInsensitiveIdentifiers();
        this.testWithTwoCandidates();
    }

    private void testWithoutAnyCandidate() throws SQLException {
        this.deleteDb(this.getTestName());
        Connection conn = this.getConnectionWithSettings("DATABASE_TO_UPPER=FALSE");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE T2 ( ID INT GENERATED BY DEFAULT AS IDENTITY )");
        try {
            stat.execute("ALTER TABLE t1 DROP COLUMN ID");
            this.fail("Table `t1` was accessible but should not have been.");
        }
        catch (SQLException e) {
            String message = e.getMessage();
            this.assertContains(message, "Table \"t1\" not found;");
        }
        conn.close();
        this.deleteDb(this.getTestName());
    }

    private void testWithoutAnyCandidateWhenDatabaseToLower() throws SQLException {
        this.deleteDb(this.getTestName());
        Connection conn = this.getConnectionWithSettings("DATABASE_TO_LOWER=TRUE");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE T2 ( ID INT GENERATED BY DEFAULT AS IDENTITY )");
        try {
            stat.execute("ALTER TABLE T1 DROP COLUMN ID");
            this.fail("Table `t1` was accessible but should not have been.");
        }
        catch (SQLException e) {
            String message = e.getMessage();
            this.assertContains(message, "Table \"t1\" not found;");
        }
        conn.close();
        this.deleteDb(this.getTestName());
    }

    private void testWithoutAnyCandidateWhenDatabaseToUpper() throws SQLException {
        this.deleteDb(this.getTestName());
        Connection conn = this.getConnectionWithSettings("DATABASE_TO_LOWER=FALSE;DATABASE_TO_UPPER=TRUE");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE T2 ( ID INT GENERATED BY DEFAULT AS IDENTITY )");
        try {
            stat.execute("ALTER TABLE t1 DROP COLUMN ID");
            this.fail("Table `T1` was accessible but should not have been.");
        }
        catch (SQLException e) {
            String message = e.getMessage();
            this.assertContains(message, "Table \"T1\" not found;");
        }
        conn.close();
        this.deleteDb(this.getTestName());
    }

    private void testWithoutAnyCandidateWhenCaseInsensitiveIdentifiers() throws SQLException {
        this.deleteDb(this.getTestName());
        Connection conn = this.getConnectionWithSettings("DATABASE_TO_UPPER=FALSE;CASE_INSENSITIVE_IDENTIFIERS=TRUE");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE T2 ( ID INT GENERATED BY DEFAULT AS IDENTITY )");
        try {
            stat.execute("ALTER TABLE t1 DROP COLUMN ID");
            this.fail("Table `t1` was accessible but should not have been.");
        }
        catch (SQLException e) {
            String message = e.getMessage();
            this.assertContains(message, "Table \"t1\" not found;");
        }
        conn.close();
        this.deleteDb(this.getTestName());
    }

    private void testWithOneCandidate() throws SQLException {
        this.deleteDb(this.getTestName());
        Connection conn = this.getConnectionWithSettings("DATABASE_TO_UPPER=FALSE");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE T1 ( ID INT GENERATED BY DEFAULT AS IDENTITY )");
        try {
            stat.execute("ALTER TABLE t1 DROP COLUMN ID");
            this.fail("Table `t1` was accessible but should not have been.");
        }
        catch (SQLException e) {
            String message = e.getMessage();
            this.assertContains(message, "Table \"t1\" not found (candidates are: \"T1\")");
        }
        conn.close();
        this.deleteDb(this.getTestName());
    }

    private void testWithOneCandidateWhenDatabaseToLower() throws SQLException {
        this.deleteDb(this.getTestName());
        Connection conn = this.getConnectionWithSettings("DATABASE_TO_LOWER=TRUE");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE t1 ( ID INT GENERATED BY DEFAULT AS IDENTITY, PAYLOAD INT )");
        stat.execute("ALTER TABLE T1 DROP COLUMN PAYLOAD");
        conn.close();
        this.deleteDb(this.getTestName());
    }

    private void testWithOneCandidateWhenDatabaseToUpper() throws SQLException {
        this.deleteDb(this.getTestName());
        Connection conn = this.getConnectionWithSettings("DATABASE_TO_UPPER=TRUE");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE T1 ( ID INT GENERATED BY DEFAULT AS IDENTITY, PAYLOAD INT )");
        stat.execute("ALTER TABLE t1 DROP COLUMN PAYLOAD");
        conn.close();
        this.deleteDb(this.getTestName());
    }

    private void testWithOneCandidateWhenCaseInsensitiveIdentifiers() throws SQLException {
        this.deleteDb(this.getTestName());
        Connection conn = this.getConnectionWithSettings("DATABASE_TO_UPPER=FALSE;CASE_INSENSITIVE_IDENTIFIERS=TRUE");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE T1 ( ID INT GENERATED BY DEFAULT AS IDENTITY, PAYLOAD INT )");
        stat.execute("ALTER TABLE t1 DROP COLUMN PAYLOAD");
        conn.close();
        this.deleteDb(this.getTestName());
    }

    private void testWithTwoCandidates() throws SQLException {
        this.deleteDb(this.getTestName());
        Connection conn = this.getConnectionWithSettings("DATABASE_TO_UPPER=FALSE");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE Toast ( ID INT GENERATED BY DEFAULT AS IDENTITY )");
        stat.execute("CREATE TABLE TOAST ( ID INT GENERATED BY DEFAULT AS IDENTITY )");
        try {
            stat.execute("ALTER TABLE toast DROP COLUMN ID");
            this.fail("Table `toast` was accessible but should not have been.");
        }
        catch (SQLException e) {
            String message = e.getMessage();
            this.assertContains(message, "Table \"toast\" not found (candidates are: \"TOAST, Toast\")");
        }
        conn.close();
        this.deleteDb(this.getTestName());
    }

    private Connection getConnectionWithSettings(String settings) throws SQLException {
        return this.getConnection(this.getTestName() + ";" + settings);
    }
}

