/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestAutoRecompile
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws SQLException {
        this.deleteDb("autoRecompile");
        Connection conn = this.getConnection("autoRecompile");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY)");
        PreparedStatement prep = conn.prepareStatement("SELECT * FROM TEST");
        this.assertEquals(1, prep.executeQuery().getMetaData().getColumnCount());
        stat.execute("ALTER TABLE TEST ADD COLUMN NAME VARCHAR(255)");
        this.assertEquals(2, prep.executeQuery().getMetaData().getColumnCount());
        stat.execute("DROP TABLE TEST");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, X INT, Y INT)");
        this.assertEquals(3, prep.executeQuery().getMetaData().getColumnCount());
        prep = conn.prepareStatement("INSERT INTO TEST VALUES(1, 2, 3)");
        stat.execute("ALTER TABLE TEST ADD COLUMN Z INT");
        this.assertThrows(21002, prep).execute();
        this.assertThrows(21002, prep).execute();
        conn.close();
        this.deleteDb("autoRecompile");
    }
}

