/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import org.h2.store.FileLister;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestBigResult
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public boolean isEnabled() {
        return !this.config.memory;
    }

    @Override
    public void test() throws SQLException {
        this.testLargeSubquery();
        this.testSortingAndDistinct();
        this.testLOB();
        this.testLargeUpdateDelete();
        this.testCloseConnectionDelete();
        this.testOrderGroup();
        this.testLimitBufferedResult();
        this.deleteDb("bigResult");
    }

    private void testLargeSubquery() throws SQLException {
        this.deleteDb("bigResult");
        Connection conn = this.getConnection("bigResult");
        Statement stat = conn.createStatement();
        int len = this.getSize(1000, 4000);
        stat.execute("SET MAX_MEMORY_ROWS " + len / 10);
        stat.execute("CREATE TABLE RECOVERY(TRANSACTION_ID INT, SQL_STMT VARCHAR)");
        stat.execute("INSERT INTO RECOVERY SELECT X, CASE MOD(X, 2) WHEN 0 THEN 'commit' ELSE 'begin' END FROM SYSTEM_RANGE(1, " + len + ")");
        ResultSet rs = stat.executeQuery("SELECT * FROM RECOVERY WHERE SQL_STMT LIKE 'begin%' AND TRANSACTION_ID NOT IN(SELECT TRANSACTION_ID FROM RECOVERY WHERE SQL_STMT='commit' OR SQL_STMT='rollback')");
        int count = 0;
        int last = 1;
        while (rs.next()) {
            this.assertEquals(last, rs.getInt(1));
            last += 2;
            ++count;
        }
        this.assertEquals(len / 2, count);
        conn.close();
    }

    private void testSortingAndDistinct() throws SQLException {
        this.deleteDb("bigResult");
        Connection conn = this.getConnection("bigResult");
        Statement stat = conn.createStatement();
        int count = this.getSize(1000, 4000);
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, V INT NOT NULL)");
        PreparedStatement ps = conn.prepareStatement("INSERT INTO TEST VALUES (?, ?)");
        int i = 0;
        while (i < count) {
            ps.setInt(1, i);
            ps.setInt(2, count - i);
            ps.executeUpdate();
            ++i;
        }
        this.testSortingAndDistinct1(stat, count, count);
        this.testSortingAndDistinct1(stat, 10, count);
        stat.execute("DROP TABLE TEST");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, VALUE1 INT NOT NULL, VALUE2 INT NOT NULL)");
        ps = conn.prepareStatement("INSERT INTO TEST VALUES (?, ?, ?)");
        int partCount = count / 10;
        int i2 = 0;
        while (i2 < count) {
            ps.setInt(1, i2);
            int a = i2 / 10;
            int b = i2 % 10;
            ps.setInt(2, partCount - a);
            ps.setInt(3, 10 - b);
            ps.executeUpdate();
            ++i2;
        }
        String sql = "SELECT VALUE2, VALUE1 FROM (SELECT ID, VALUE2, VALUE1 FROM TEST ORDER BY VALUE2)";
        this.testSortingAndDistinct2(stat, sql, count, partCount);
        this.testSortingAndDistinct2(stat, sql, 10, partCount);
        sql = "SELECT VALUE2, VALUE1 FROM (SELECT DISTINCT ID, VALUE2, VALUE1 FROM TEST)";
        this.testSortingAndDistinct2DistinctOnly(stat, sql, count, partCount);
        this.testSortingAndDistinct2DistinctOnly(stat, sql, 10, partCount);
        sql = "SELECT VALUE2, VALUE1 FROM (SELECT DISTINCT ID, VALUE2, VALUE1 FROM TEST ORDER BY VALUE2)";
        this.testSortingAndDistinct2(stat, sql, count, partCount);
        this.testSortingAndDistinct2(stat, sql, 10, partCount);
        sql = "SELECT VALUE1 FROM (SELECT DISTINCT VALUE1 FROM TEST)";
        this.testSortingAndDistinct3DistinctOnly(stat, sql, count, partCount);
        this.testSortingAndDistinct3DistinctOnly(stat, sql, 1, partCount);
        sql = "SELECT VALUE1 FROM (SELECT DISTINCT VALUE1 FROM TEST ORDER BY VALUE1)";
        this.testSortingAndDistinct3(stat, sql, count, partCount);
        this.testSortingAndDistinct3(stat, sql, 1, partCount);
        stat.execute("DROP TABLE TEST");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, V INT)");
        ps = conn.prepareStatement("INSERT INTO TEST VALUES (?, ?)");
        int i3 = 0;
        while (i3 < count) {
            ps.setInt(1, i3);
            int j = i3 / 10;
            if (j == 0) {
                ps.setNull(2, 4);
            } else {
                ps.setInt(2, j);
            }
            ps.executeUpdate();
            ++i3;
        }
        sql = "SELECT DISTINCT V FROM TEST ORDER BY V";
        this.testSortingAndDistinct4(stat, sql, count, partCount);
        this.testSortingAndDistinct4(stat, sql, 1, partCount);
        sql = "SELECT DISTINCT V FROM TEST";
        this.testSortingAndDistinct4DistinctOnly(stat, sql, count, partCount);
        this.testSortingAndDistinct4DistinctOnly(stat, sql, 1, partCount);
        sql = "SELECT V FROM TEST ORDER BY V";
        this.testSortingAndDistinct4SortingOnly(stat, sql, count, partCount);
        this.testSortingAndDistinct4SortingOnly(stat, sql, 1, partCount);
        conn.close();
    }

    private void testSortingAndDistinct1(Statement stat, int maxRows, int count) throws SQLException {
        stat.execute("SET MAX_MEMORY_ROWS " + maxRows);
        ResultSet rs = stat.executeQuery("SELECT V FROM (SELECT DISTINCT ID, V FROM TEST ORDER BY V)");
        int i = 1;
        while (i <= count) {
            this.assertTrue(rs.next());
            this.assertEquals(rs.getInt(1), i);
            ++i;
        }
        this.assertFalse(rs.next());
    }

    private void testSortingAndDistinct2(Statement stat, String sql, int maxRows, int partCount) throws SQLException {
        stat.execute("SET MAX_MEMORY_ROWS " + maxRows);
        ResultSet rs = stat.executeQuery(sql);
        BitSet set = new BitSet(partCount);
        int i = 1;
        while (i <= 10) {
            set.clear();
            int j = 1;
            while (j <= partCount) {
                this.assertTrue(rs.next());
                this.assertEquals(i, rs.getInt(1));
                set.set(rs.getInt(2));
                ++j;
            }
            this.assertEquals(partCount + 1, set.nextClearBit(1));
            ++i;
        }
        this.assertFalse(rs.next());
    }

    private void testSortingAndDistinct2DistinctOnly(Statement stat, String sql, int maxRows, int partCount) throws SQLException {
        stat.execute("SET MAX_MEMORY_ROWS " + maxRows);
        ResultSet rs = stat.executeQuery(sql);
        BitSet set = new BitSet(partCount * 10);
        int i = 1;
        while (i <= 10) {
            int j = 1;
            while (j <= partCount) {
                this.assertTrue(rs.next());
                set.set(rs.getInt(1) * partCount + rs.getInt(2));
                ++j;
            }
            ++i;
        }
        this.assertEquals(partCount * 11 + 1, set.nextClearBit(partCount + 1));
        this.assertFalse(rs.next());
    }

    private void testSortingAndDistinct3(Statement stat, String sql, int maxRows, int partCount) throws SQLException {
        stat.execute("SET MAX_MEMORY_ROWS " + maxRows);
        ResultSet rs = stat.executeQuery(sql);
        int i = 1;
        while (i <= partCount) {
            this.assertTrue(rs.next());
            this.assertEquals(i, rs.getInt(1));
            ++i;
        }
        this.assertFalse(rs.next());
    }

    private void testSortingAndDistinct3DistinctOnly(Statement stat, String sql, int maxRows, int partCount) throws SQLException {
        stat.execute("SET MAX_MEMORY_ROWS " + maxRows);
        ResultSet rs = stat.executeQuery(sql);
        BitSet set = new BitSet(partCount);
        int i = 1;
        while (i <= partCount) {
            this.assertTrue(rs.next());
            set.set(rs.getInt(1));
            ++i;
        }
        this.assertEquals(partCount + 1, set.nextClearBit(1));
        this.assertFalse(rs.next());
    }

    private void testSortingAndDistinct4(Statement stat, String sql, int maxRows, int count) throws SQLException {
        stat.execute("SET MAX_MEMORY_ROWS " + maxRows);
        ResultSet rs = stat.executeQuery(sql);
        int i = 0;
        while (i < count) {
            this.assertTrue(rs.next());
            this.assertEquals(i, rs.getInt(1));
            if (i == 0) {
                this.assertTrue(rs.wasNull());
            }
            ++i;
        }
        this.assertFalse(rs.next());
    }

    private void testSortingAndDistinct4DistinctOnly(Statement stat, String sql, int maxRows, int count) throws SQLException {
        stat.execute("SET MAX_MEMORY_ROWS " + maxRows);
        ResultSet rs = stat.executeQuery(sql);
        BitSet set = new BitSet();
        int i = 0;
        while (i < count) {
            this.assertTrue(rs.next());
            int v = rs.getInt(1);
            if (v == 0) {
                this.assertTrue(rs.wasNull());
            }
            this.assertFalse(set.get(v));
            set.set(v);
            ++i;
        }
        this.assertFalse(rs.next());
        this.assertEquals(count, set.nextClearBit(0));
    }

    private void testSortingAndDistinct4SortingOnly(Statement stat, String sql, int maxRows, int count) throws SQLException {
        stat.execute("SET MAX_MEMORY_ROWS " + maxRows);
        ResultSet rs = stat.executeQuery(sql);
        int i = 0;
        while (i < count) {
            int j = 0;
            while (j < 10) {
                this.assertTrue(rs.next());
                this.assertEquals(i, rs.getInt(1));
                if (i == 0) {
                    this.assertTrue(rs.wasNull());
                }
                ++j;
            }
            ++i;
        }
        this.assertFalse(rs.next());
    }

    private void testLOB() throws SQLException {
        if (this.config.traceLevelFile == 3) {
            return;
        }
        this.deleteDb("bigResult");
        Connection conn = this.getConnection("bigResult");
        Statement stat = conn.createStatement();
        stat.execute("SET MAX_MEMORY_ROWS 1");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, V BLOB NOT NULL)");
        PreparedStatement ps = conn.prepareStatement("INSERT INTO TEST VALUES (?, ?)");
        int length = 1000000;
        byte[] data = new byte[length];
        int i = 1;
        while (i <= 10) {
            ps.setInt(1, i);
            Arrays.fill(data, (byte)i);
            ps.setBytes(2, data);
            ps.executeUpdate();
            ++i;
        }
        Blob[] blobs = new Blob[10];
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST");
        int i2 = 1;
        while (i2 <= 10) {
            this.assertTrue(rs.next());
            this.assertEquals(i2, rs.getInt(1));
            blobs[i2 - 1] = rs.getBlob(2);
            ++i2;
        }
        this.assertFalse(rs.next());
        rs.close();
        i2 = 1;
        while (i2 <= 10) {
            Blob b = blobs[i2 - 1];
            byte[] bytes = b.getBytes(1L, (int)b.length());
            Arrays.fill(data, (byte)i2);
            this.assertEquals(data, bytes);
            b.free();
            ++i2;
        }
        stat.execute("DROP TABLE TEST");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, V CLOB NOT NULL)");
        ps = conn.prepareStatement("INSERT INTO TEST VALUES (?, ?)");
        char[] cdata = new char[length];
        int i3 = 1;
        while (i3 <= 10) {
            ps.setInt(1, i3);
            Arrays.fill(cdata, (char)i3);
            ps.setString(2, new String(cdata));
            ps.executeUpdate();
            ++i3;
        }
        Clob[] clobs = new Clob[10];
        rs = stat.executeQuery("SELECT * FROM TEST");
        int i4 = 1;
        while (i4 <= 10) {
            this.assertTrue(rs.next());
            this.assertEquals(i4, rs.getInt(1));
            clobs[i4 - 1] = rs.getClob(2);
            ++i4;
        }
        this.assertFalse(rs.next());
        rs.close();
        i4 = 1;
        while (i4 <= 10) {
            Clob c = clobs[i4 - 1];
            String string = c.getSubString(1L, (int)c.length());
            Arrays.fill(cdata, (char)i4);
            this.assertEquals(new String(cdata), string);
            c.free();
            ++i4;
        }
        conn.close();
    }

    private void testLargeUpdateDelete() throws SQLException {
        this.deleteDb("bigResult");
        Connection conn = this.getConnection("bigResult");
        Statement stat = conn.createStatement();
        int len = this.getSize(10000, 100000);
        stat.execute("SET MAX_OPERATION_MEMORY 4096");
        stat.execute("CREATE TABLE TEST AS SELECT * FROM SYSTEM_RANGE(1, " + len + ")");
        stat.execute("UPDATE TEST SET X=X+1");
        stat.execute("DELETE FROM TEST");
        conn.close();
    }

    private void testCloseConnectionDelete() throws SQLException {
        this.deleteDb("bigResult");
        Connection conn = this.getConnection("bigResult");
        Statement stat = conn.createStatement();
        stat.execute("SET MAX_MEMORY_ROWS 2");
        ResultSet rs = stat.executeQuery("SELECT * FROM SYSTEM_RANGE(1, 100)");
        while (rs.next()) {
        }
        conn.close();
        this.deleteDb("bigResult");
        ArrayList<String> files = FileLister.getDatabaseFiles(this.getBaseDir(), "bigResult", true);
        if (files.size() > 0) {
            this.fail("file not deleted: " + files.get(0));
        }
    }

    private void testLimitBufferedResult() throws SQLException {
        this.deleteDb("bigResult");
        Connection conn = this.getConnection("bigResult");
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(ID INT)");
        int i = 0;
        while (i < 200) {
            stat.execute("INSERT INTO TEST(ID) VALUES(" + i + ")");
            ++i;
        }
        stat.execute("SET MAX_MEMORY_ROWS 100");
        ResultSet rs = stat.executeQuery("select id from test order by id limit 10 offset 85");
        int i2 = 85;
        while (rs.next()) {
            this.assertEquals(i2, rs.getInt(1));
            ++i2;
        }
        rs = stat.executeQuery("select id from test order by id limit 10 offset 95");
        i2 = 95;
        while (rs.next()) {
            this.assertEquals(i2, rs.getInt(1));
            ++i2;
        }
        rs = stat.executeQuery("select id from test order by id limit 10 offset 105");
        i2 = 105;
        while (rs.next()) {
            this.assertEquals(i2, rs.getInt(1));
            ++i2;
        }
        conn.close();
    }

    private void testOrderGroup() throws SQLException {
        this.deleteDb("bigResult");
        Connection conn = this.getConnection("bigResult");
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, Name VARCHAR(255), FirstName VARCHAR(255), Points INT,LicenseID INT)");
        int len = this.getSize(10, 5000);
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?, ?, ?, ?, ?)");
        int i = 0;
        while (i < len) {
            prep.setInt(1, i);
            prep.setString(2, "Name " + i);
            prep.setString(3, "First Name " + i);
            prep.setInt(4, i * 10);
            prep.setInt(5, i * i);
            prep.execute();
            ++i;
        }
        conn.close();
        conn = this.getConnection("bigResult");
        stat = conn.createStatement();
        stat.setMaxRows(len + 1);
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        int i2 = 0;
        while (i2 < len) {
            rs.next();
            this.assertEquals(i2, rs.getInt(1));
            this.assertEquals("Name " + i2, rs.getString(2));
            this.assertEquals("First Name " + i2, rs.getString(3));
            this.assertEquals(i2 * 10, rs.getInt(4));
            this.assertEquals(i2 * i2, rs.getInt(5));
            ++i2;
        }
        stat.setMaxRows(len + 1);
        rs = stat.executeQuery("SELECT * FROM TEST WHERE ID >= 1000 ORDER BY ID");
        i2 = 1000;
        while (i2 < len) {
            rs.next();
            this.assertEquals(i2, rs.getInt(1));
            this.assertEquals("Name " + i2, rs.getString(2));
            this.assertEquals("First Name " + i2, rs.getString(3));
            this.assertEquals(i2 * 10, rs.getInt(4));
            this.assertEquals(i2 * i2, rs.getInt(5));
            ++i2;
        }
        stat.execute("SET MAX_MEMORY_ROWS 2");
        rs = stat.executeQuery("SELECT Name, SUM(ID) FROM TEST GROUP BY NAME");
        while (rs.next()) {
            rs.getString(1);
            rs.getInt(2);
        }
        conn.setAutoCommit(false);
        stat.setMaxRows(0);
        stat.execute("SET MAX_MEMORY_ROWS 0");
        stat.execute("CREATE TABLE DATA(ID INT, NAME VARCHAR_IGNORECASE(255))");
        prep = conn.prepareStatement("INSERT INTO DATA VALUES(?, ?)");
        i2 = 0;
        while (i2 < len) {
            prep.setInt(1, i2);
            prep.setString(2, "" + i2 / 200);
            prep.execute();
            ++i2;
        }
        Statement s2 = conn.createStatement(1004, 1008);
        rs = s2.executeQuery("SELECT NAME FROM DATA");
        rs.last();
        conn.setAutoCommit(true);
        rs = s2.executeQuery("SELECT NAME FROM DATA ORDER BY ID");
        while (rs.next()) {
        }
        conn.close();
    }
}

