/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestCases
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testMinimalCoveringIndexPlan();
        this.testMinMaxDirectLookupIndex();
        this.testReferenceLaterTable();
        this.testAutoCommitInDatabaseURL();
        this.testReferenceableIndexUsage();
        this.testClearSyntaxException();
        this.testEmptyStatements();
        this.testViewParameters();
        this.testLargeKeys();
        this.testExtraSemicolonInDatabaseURL();
        this.testGroupSubquery();
        this.testCountDistinctNotNull();
        this.testDependencies();
        this.testConvertType();
        this.testSortedSelect();
        this.testMaxMemoryRows();
        this.testLikeExpressions();
        this.testUnicode();
        this.testOuterJoin();
        this.testCommentOnColumnWithSchemaEqualDatabase();
        this.testColumnWithConstraintAndComment();
        this.testTruncateConstraintsDisabled();
        this.testPreparedSubquery2();
        this.testPreparedSubquery();
        this.testCompareDoubleWithIntColumn();
        this.testDeleteIndexOutOfBounds();
        this.testOrderByWithSubselect();
        this.testInsertDeleteRollback();
        this.testLargeRollback();
        this.testConstraintAlterTable();
        this.testJoinWithView();
        this.testLobDecrypt();
        this.testInvalidDatabaseName();
        this.testReuseSpace();
        this.testDeleteGroup();
        this.testDisconnect();
        this.testExecuteTrace();
        this.testExplain();
        this.testExplainAnalyze();
        this.testDataChangeDeltaTable();
        this.testGroupSortedReset();
        this.testShowColumns();
        if (this.config.memory) {
            return;
        }
        this.testCheckConstraintWithFunction();
        this.testDeleteAndDropTableWithLobs(true);
        this.testDeleteAndDropTableWithLobs(false);
        this.testEmptyBtreeIndex();
        this.testReservedKeywordReconnect();
        this.testSpecialSQL();
        this.testUpperCaseLowerCaseDatabase();
        this.testManualCommitSet();
        this.testSchemaIdentityReconnect();
        this.testAlterTableReconnect();
        this.testPersistentSettings();
        this.testInsertSelectUnion();
        this.testViewReconnect();
        this.testDefaultQueryReconnect();
        this.testBigString();
        this.testRenameReconnect();
        this.testCreateDrop();
        this.testPolePos();
        this.testQuick();
        this.testMutableObjects();
        this.testSelectForUpdate();
        this.testDoubleRecovery();
        this.testConstraintReconnect();
        this.testCollation();
        this.deleteDb("cases");
    }

    private void testReferenceLaterTable() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("create table a(id int)");
        stat.execute("create table b(id int)");
        stat.execute("drop table a");
        this.assertThrows(50100, stat).execute("create table a(id int check id < select max(id) from b)");
        stat.execute("drop table b");
        stat.execute("create table b(id int)");
        stat.execute("create table a(id int check id < select max(id) from b)");
        conn.close();
        conn = this.getConnection("cases");
        conn.close();
    }

    private void testAutoCommitInDatabaseURL() throws SQLException {
        Connection conn = this.getConnection("cases;autocommit=false");
        this.assertFalse(conn.getAutoCommit());
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("call autocommit()");
        rs.next();
        this.assertFalse(rs.getBoolean(1));
        conn.close();
    }

    private void testReferenceableIndexUsage() throws SQLException {
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("drop table if exists a, b");
        stat.execute("create table a(id int, x int) as select 1, 100");
        stat.execute("create index idx1 on a(id, x)");
        stat.execute("alter table a add unique(id)");
        stat.execute("create table b(id int primary key, a_id int) as select 1, 1");
        stat.execute("alter table b add constraint x foreign key(a_id) references a(id)");
        stat.execute("update a set x=200");
        stat.execute("drop table if exists a, b cascade");
        conn.close();
    }

    private void testClearSyntaxException() throws SQLException {
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        this.assertThrows(42000, stat).execute("select t.x, t.x t.y from dual t");
        conn.close();
    }

    private void testEmptyStatements() throws SQLException {
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;");
        stat.execute("");
        stat.execute(";");
        stat.execute(" ;");
        conn.close();
    }

    private void testViewParameters() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("create view test as select 0 v, 'x' name from dual");
        PreparedStatement prep = conn.prepareStatement("select 1 from test where name=? and v=? and v<=?");
        prep.setString(1, "x");
        prep.setInt(2, 0);
        prep.setInt(3, 1);
        prep.executeQuery();
        conn.close();
    }

    private void testLargeKeys() throws SQLException {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, name varchar)");
        stat.execute("create index on test(name)");
        stat.execute("insert into test values(1, '1' || space(1500))");
        conn.close();
        conn = this.getConnection("cases");
        stat = conn.createStatement();
        stat.execute("insert into test values(2, '2' || space(1500))");
        conn.close();
        conn = this.getConnection("cases");
        stat = conn.createStatement();
        stat.executeQuery("select name from test order by name");
        conn.close();
    }

    private void testExtraSemicolonInDatabaseURL() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases;");
        conn.close();
        conn = this.getConnection("cases;;mode=mysql;");
        conn.close();
    }

    private void testGroupSubquery() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("create table test(a int, b int)");
        stat.execute("create index idx on test(a)");
        stat.execute("insert into test values (1, 9), (2, 9), (3, 9)");
        ResultSet rs = stat.executeQuery("select (select count(*) from test where a = t.a and b = 0) from test t group by a");
        rs.next();
        this.assertEquals(0, rs.getInt(1));
        conn.close();
    }

    private void testCountDistinctNotNull() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int not null) as select 1 from system_range(1, 10)");
        ResultSet rs = stat.executeQuery("select count(distinct id) from test");
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        conn.close();
    }

    private void testDependencies() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, parent int)");
        stat.execute("alter table test add constraint test check (select count(*) from test) < 10");
        stat.execute("create table b()");
        stat.execute("drop table b");
        stat.execute("drop table test");
        stat.execute("create alias is_positive as 'boolean isPositive(int x) { return x > 0; }'");
        stat.execute("create table a(a integer, constraint test check is_positive(a))");
        this.assertThrows(90107, stat).execute("drop alias is_positive");
        stat.execute("drop table a");
        stat.execute("drop alias is_positive");
        stat.execute("create table test(id int primary key)");
        this.assertThrows(90083, stat).execute("alter table test alter column id set default ifnull((select max(id) from test)+1, 0)");
        stat.execute("drop table test");
        conn.close();
    }

    private void testConvertType() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("create table test as select cast(0 as dec(10, 2)) x");
        ResultSetMetaData meta = stat.executeQuery("select * from test").getMetaData();
        this.assertEquals(10, meta.getPrecision(1));
        this.assertEquals(2, meta.getScale(1));
        stat.execute("alter table test add column y int");
        stat.execute("drop table test");
        conn.close();
    }

    private void testSortedSelect() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("create memory temporary table test(id int) not persistent");
        stat.execute("insert into test(id) direct sorted select 1");
        stat.execute("drop table test");
        conn.close();
    }

    private void testMaxMemoryRows() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases;MAX_MEMORY_ROWS=1");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key)");
        stat.execute("insert into test values(1), (2)");
        stat.execute("select * from system_range(1, 1) where x not in (select id from test order by id)");
        stat.execute("select * from system_range(1, 1) where x not in (select id from test union select id from test)");
        stat.execute("(select id from test order by id) intersect (select id from test order by id)");
        conn.close();
    }

    private void testUnicode() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id identity, name text)");
        String[] data = new String[]{"\uff1e", "\ud848\udf1e"};
        PreparedStatement prep = conn.prepareStatement("insert into test(name) values(?)");
        int i = 0;
        while (i < data.length) {
            prep.setString(1, data[i]);
            prep.execute();
            ++i;
        }
        prep = conn.prepareStatement("select * from test order by id");
        ResultSet rs = prep.executeQuery();
        int i2 = 0;
        while (i2 < data.length) {
            this.assertTrue(rs.next());
            this.assertEquals(data[i2], rs.getString(2));
            ++i2;
        }
        stat.execute("drop table test");
        rs = stat.executeQuery("select floor(\u3000 1.2) \ud835\udca9");
        rs.next();
        this.assertEquals(BigDecimal.ONE, rs.getBigDecimal(1));
        this.assertEquals("\ud835\udca9", rs.getMetaData().getColumnLabel(1));
        conn.close();
    }

    private void testCheckConstraintWithFunction() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("create alias is_email as 'boolean isEmail(String x) { return x != null && x.indexOf(''@'') > 0; }'");
        stat.execute("create domain email as varchar check is_email(value)");
        stat.execute("create table test(e email)");
        conn.close();
        conn = this.getConnection("cases");
        conn.close();
    }

    private void testOuterJoin() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("create table parent(p int primary key) as select 1");
        stat.execute("create table child(c int primary key, pc int) as select 2, 1");
        ResultSet rs = stat.executeQuery("select * from parent left outer join child on p = pc where c is null");
        this.assertFalse(rs.next());
        stat.execute("drop all objects");
        conn.close();
    }

    private void testCommentOnColumnWithSchemaEqualDatabase() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("create schema cases");
        stat.execute("create table cases.cases(cases int)");
        stat.execute("comment on column cases.cases.cases is 'schema.table.column'");
        stat.execute("comment on column cases.cases.cases.cases is 'db.schema.table.column'");
        conn.close();
    }

    private void testColumnWithConstraintAndComment() throws SQLException {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int check id < 500)");
        stat.execute("comment on column test.id is 'comment'");
        conn.close();
        conn = this.getConnection("cases");
        conn.close();
    }

    private void testTruncateConstraintsDisabled() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("create table parent(id identity) as select 0");
        stat.execute("create table child(id identity, parent int references parent(id)) as select 0, 0");
        this.assertThrows(90106, stat).execute("truncate table parent");
        this.assertThrows(23503, stat).execute("delete from parent");
        stat.execute("alter table parent set referential_integrity false");
        stat.execute("delete from parent");
        stat.execute("truncate table parent");
        stat.execute("alter table parent set referential_integrity true");
        this.assertThrows(90106, stat).execute("truncate table parent");
        stat.execute("set referential_integrity false");
        stat.execute("truncate table parent");
        conn.close();
    }

    private void testPreparedSubquery2() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, name varchar(255))");
        stat.execute("insert into test values(1, 'Hello')");
        stat.execute("insert into test values(2, 'World')");
        PreparedStatement ps = conn.prepareStatement("select name from test where id in (select id from test where name = ?)");
        ps.setString(1, "Hello");
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            if (!rs.getString("name").equals("Hello")) {
                this.fail("'" + rs.getString("name") + "' must be 'Hello'");
            }
        } else {
            this.fail("Must have a result!");
        }
        rs.close();
        ps.setString(1, "World");
        rs = ps.executeQuery();
        if (rs.next()) {
            if (!rs.getString("name").equals("World")) {
                this.fail("'" + rs.getString("name") + "' must be 'World'");
            }
        } else {
            this.fail("Must have a result!");
        }
        rs.close();
        conn.close();
    }

    private void testPreparedSubquery() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int)");
        stat.execute("insert into test values(1)");
        String sql = "select ?, ?, (select count(*) from test inner join (select id from test where 0=?) as t2 on t2.id=test.id) from test";
        ResultSet rs = stat.executeQuery(sql.replace('?', '0'));
        rs.next();
        this.assertEquals(1, rs.getInt(3));
        PreparedStatement prep = conn.prepareStatement(sql);
        prep.setInt(1, 0);
        prep.setInt(2, 0);
        prep.setInt(3, 0);
        rs = prep.executeQuery();
        rs.next();
        this.assertEquals(1, rs.getInt(3));
        conn.close();
    }

    private void testCompareDoubleWithIntColumn() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        this.testCompareDoubleWithIntColumn(stat, false, 0.1, false);
        this.testCompareDoubleWithIntColumn(stat, false, 0.1, true);
        this.testCompareDoubleWithIntColumn(stat, false, 0.9, false);
        this.testCompareDoubleWithIntColumn(stat, false, 0.9, true);
        this.testCompareDoubleWithIntColumn(stat, true, 0.1, false);
        this.testCompareDoubleWithIntColumn(stat, true, 0.1, true);
        this.testCompareDoubleWithIntColumn(stat, true, 0.9, false);
        this.testCompareDoubleWithIntColumn(stat, true, 0.9, true);
        conn.close();
    }

    private void testCompareDoubleWithIntColumn(Statement stat, boolean pk, double x, boolean prepared) throws SQLException {
        ResultSet rs;
        if (pk) {
            stat.execute("create table test(id int primary key)");
        } else {
            stat.execute("create table test(id int)");
        }
        stat.execute("insert into test values(1)");
        if (prepared) {
            PreparedStatement prep = stat.getConnection().prepareStatement("select * from test where id > ?");
            prep.setDouble(1, x);
            rs = prep.executeQuery();
        } else {
            rs = stat.executeQuery("select * from test where id > " + x);
        }
        this.assertTrue(rs.next());
        stat.execute("drop table test");
    }

    private void testDeleteIndexOutOfBounds() throws SQLException {
        if (this.config.memory || !this.config.big) {
            return;
        }
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE IF NOT EXISTS test (rowid INTEGER PRIMARY KEY AUTO_INCREMENT, txt VARCHAR(64000));");
        PreparedStatement prep = conn.prepareStatement("insert into test (txt) values(space(?))");
        int i = 0;
        while (i < 3000) {
            prep.setInt(1, i * 3);
            prep.execute();
            ++i;
        }
        stat.execute("DELETE FROM test;");
        conn.close();
    }

    private void testInsertDeleteRollback() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("set cache_size 1");
        stat.execute("SET MAX_MEMORY_ROWS 2147483647");
        stat.execute("SET MAX_MEMORY_UNDO 2147483647");
        stat.execute("SET MAX_OPERATION_MEMORY 2147483647");
        stat.execute("create table test(id identity)");
        conn.setAutoCommit(false);
        stat.execute("insert into test select x from system_range(1, 11)");
        stat.execute("delete from test");
        conn.rollback();
        conn.close();
    }

    private void testLargeRollback() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("set max_operation_memory 1");
        stat.execute("create table test(id int)");
        stat.execute("insert into test values(1), (2)");
        stat.execute("create index idx on test(id)");
        conn.setAutoCommit(false);
        stat.execute("update test set id = id where id=2");
        stat.execute("update test set id = id");
        conn.rollback();
        conn.close();
        this.deleteDb("cases");
        conn = this.getConnection("cases");
        conn.createStatement().execute("set MAX_MEMORY_UNDO 1");
        conn.createStatement().execute("create table test(id number primary key)");
        conn.createStatement().execute("insert into test(id) select x from system_range(1, 2)");
        Connection conn2 = this.getConnection("cases");
        conn2.setAutoCommit(false);
        this.assertEquals(2, conn2.createStatement().executeUpdate("delete from test"));
        conn2.close();
        conn.close();
        this.deleteDb("cases");
        conn = this.getConnection("cases");
        conn.createStatement().execute("set MAX_MEMORY_UNDO 8");
        conn.createStatement().execute("create table test(id number primary key)");
        conn.setAutoCommit(false);
        conn.createStatement().execute("insert into test select x from system_range(1, 10)");
        conn.createStatement().execute("delete from test");
        conn.rollback();
        conn.close();
    }

    private void testConstraintAlterTable() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("create table parent (pid int primary key)");
        stat.execute("create table child (cid int primary key, pid int)");
        stat.execute("alter table child add foreign key (pid) references parent(pid)");
        stat.execute("alter table child add column c2 int");
        stat.execute("alter table parent add column p2 varchar");
        conn.close();
    }

    private void testEmptyBtreeIndex() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        conn.createStatement().execute("CREATE TABLE test(id int PRIMARY KEY);");
        conn.createStatement().execute("INSERT INTO test SELECT X FROM SYSTEM_RANGE(1, 77)");
        conn.createStatement().execute("DELETE from test");
        conn.close();
        conn = this.getConnection("cases");
        conn.createStatement().execute("INSERT INTO test (id) VALUES (1)");
        conn.close();
        conn = this.getConnection("cases");
        conn.createStatement().execute("DELETE from test");
        conn.createStatement().execute("drop table test");
        conn.close();
    }

    private void testJoinWithView() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        conn.createStatement().execute("create table t(i identity, n varchar) as select 1, 'x'");
        PreparedStatement prep = conn.prepareStatement("select 1 from dual inner join(select n from t where i=?) a on a.n='x' inner join(select n from t where i=?) b on b.n='x'");
        prep.setInt(1, 1);
        prep.setInt(2, 1);
        prep.execute();
        conn.close();
    }

    private void testLobDecrypt() throws SQLException {
        Connection conn = this.getConnection("cases");
        String key = "key";
        String value = "Hello World";
        PreparedStatement prep = conn.prepareStatement("CALL ENCRYPT('AES', RAWTOHEX(?), STRINGTOUTF8(?))");
        prep.setCharacterStream(1, (Reader)new StringReader(key), -1);
        prep.setCharacterStream(2, (Reader)new StringReader(value), -1);
        ResultSet rs = prep.executeQuery();
        rs.next();
        byte[] encrypted = rs.getBytes(1);
        PreparedStatement prep2 = conn.prepareStatement("CALL TRIM(CHAR(0) FROM UTF8TOSTRING(DECRYPT('AES', RAWTOHEX(?), ?)))");
        prep2.setCharacterStream(1, (Reader)new StringReader(key), -1);
        prep2.setBinaryStream(2, (InputStream)new ByteArrayInputStream(encrypted), -1);
        ResultSet rs2 = prep2.executeQuery();
        rs2.first();
        String decrypted = rs2.getString(1);
        prep2.close();
        this.assertEquals(value, decrypted);
        conn.close();
    }

    private void testReservedKeywordReconnect() throws SQLException {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("create table \"UNIQUE\"(\"UNIQUE\" int)");
        conn.close();
        conn = this.getConnection("cases");
        stat = conn.createStatement();
        stat.execute("select \"UNIQUE\" from \"UNIQUE\"");
        stat.execute("drop table \"UNIQUE\"");
        conn.close();
    }

    private void testInvalidDatabaseName() {
        if (this.config.memory) {
            return;
        }
        this.assertThrows(90138, () -> this.getConnection("cases/"));
    }

    private void testReuseSpace() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        int tableCount = this.getSize(2, 5);
        int i = 0;
        while (i < tableCount) {
            stat.execute("create table t" + i + "(data varchar)");
            ++i;
        }
        Random random = new Random(1L);
        int len = this.getSize(50, 500);
        int i2 = 0;
        while (i2 < len) {
            String table = "t" + random.nextInt(tableCount);
            String sql = random.nextBoolean() ? "insert into " + table + " values(space(100000))" : "delete from " + table;
            stat.execute(sql);
            stat.execute("script to '" + this.getBaseDir() + "/test.sql'");
            ++i2;
        }
        conn.close();
        FileUtils.delete(this.getBaseDir() + "/test.sql");
    }

    private void testDeleteGroup() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("set max_memory_rows 2");
        stat.execute("create table test(id int primary key, x int)");
        stat.execute("insert into test values(0, 0), (1, 1), (2, 2)");
        stat.execute("delete from test where id not in (select min(x) from test group by id)");
        conn.close();
    }

    private void testSpecialSQL() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        this.assertThrows(42001, stat).execute("create table address(id identity, name varchar check? instr(value, '@') > 1)");
        stat.execute("SET AUTOCOMMIT OFF; \n//create sequence if not exists object_id;\n");
        stat.execute("SET AUTOCOMMIT OFF;\n//create sequence if not exists object_id;\n");
        stat.execute("SET AUTOCOMMIT OFF; //create sequence if not exists object_id;");
        stat.execute("SET AUTOCOMMIT OFF;//create sequence if not exists object_id;");
        stat.execute("SET AUTOCOMMIT OFF \n//create sequence if not exists object_id;");
        stat.execute("SET AUTOCOMMIT OFF\n//create sequence if not exists object_id;");
        stat.execute("SET AUTOCOMMIT OFF //create sequence if not exists object_id;");
        stat.execute("SET AUTOCOMMIT OFF//create sequence if not exists object_id;");
        stat.execute("SET AUTOCOMMIT OFF; \n///create sequence if not exists object_id;");
        stat.execute("SET AUTOCOMMIT OFF;\n///create sequence if not exists object_id;");
        stat.execute("SET AUTOCOMMIT OFF; ///create sequence if not exists object_id;");
        stat.execute("SET AUTOCOMMIT OFF;///create sequence if not exists object_id;");
        stat.execute("SET AUTOCOMMIT OFF \n///create sequence if not exists object_id;");
        stat.execute("SET AUTOCOMMIT OFF\n///create sequence if not exists object_id;");
        stat.execute("SET AUTOCOMMIT OFF ///create sequence if not exists object_id;");
        stat.execute("SET AUTOCOMMIT OFF///create sequence if not exists object_id;");
        conn.close();
    }

    private void testUpperCaseLowerCaseDatabase() throws SQLException {
        if (File.separatorChar != '\\' || this.config.googleAppEngine) {
            return;
        }
        this.deleteDb("cases");
        this.deleteDb("CaSeS");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("CHECKPOINT");
        stat.execute("CREATE TABLE TEST(ID INT)");
        stat.execute("INSERT INTO TEST VALUES(1)");
        stat.execute("CHECKPOINT");
        Connection conn2 = this.getConnection("CaSeS");
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM TEST");
        this.assertTrue(rs.next());
        conn2.close();
        conn.close();
        conn = this.getConnection("cases");
        rs = conn.createStatement().executeQuery("SELECT * FROM TEST");
        this.assertTrue(rs.next());
        conn.close();
        conn = this.getConnection("CaSeS");
        rs = conn.createStatement().executeQuery("SELECT * FROM TEST");
        this.assertTrue(rs.next());
        conn.close();
        this.deleteDb("cases");
        this.deleteDb("CaSeS");
    }

    private void testManualCommitSet() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Connection conn2 = this.getConnection("cases");
        conn.setAutoCommit(false);
        conn2.setAutoCommit(false);
        conn.createStatement().execute("SET MODE REGULAR");
        conn2.createStatement().execute("SET MODE REGULAR");
        conn.close();
        conn2.close();
    }

    private void testSchemaIdentityReconnect() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("create schema s authorization sa");
        stat.execute("create table s.test(id identity)");
        conn.close();
        conn = this.getConnection("cases");
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM S.TEST");
        while (rs.next()) {
        }
        conn.close();
    }

    private void testDisconnect() throws Exception {
        if (this.config.networked || this.config.codeCoverage) {
            return;
        }
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID IDENTITY)");
        int i = 0;
        while (i < 1000) {
            stat.execute("INSERT INTO TEST() VALUES()");
            ++i;
        }
        SQLException[] stopped = new SQLException[1];
        Thread t = new Thread(() -> {
            try {
                long time = System.nanoTime();
                ResultSet rs = stat.executeQuery("SELECT MAX(T.ID) FROM TEST T, TEST, TEST, TEST, TEST, TEST, TEST, TEST, TEST, TEST, TEST");
                rs.next();
                time = System.nanoTime() - time;
                TestBase.logError("query was too quick; result: " + rs.getInt(1) + " time:" + TimeUnit.NANOSECONDS.toMillis(time), null);
            }
            catch (SQLException e) {
                sQLExceptionArray[0] = e;
            }
        });
        t.start();
        Thread.sleep(300L);
        long time = System.nanoTime();
        conn.close();
        t.join(5000L);
        if (stopped[0] == null) {
            this.fail("query still running");
        } else {
            this.assertKnownException(stopped[0]);
        }
        time = System.nanoTime() - time;
        if (time > TimeUnit.SECONDS.toNanos(5L) && !this.config.reopen) {
            this.fail("closing took " + time);
        }
        this.deleteDb("cases");
    }

    private void testExecuteTrace() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT ? FROM DUAL {1: 'Hello'}");
        rs.next();
        this.assertEquals("Hello", rs.getString(1));
        this.assertFalse(rs.next());
        rs = stat.executeQuery("SELECT ? FROM DUAL UNION ALL SELECT ? FROM DUAL {1: 'Hello', 2:'World' }");
        rs.next();
        this.assertEquals("Hello", rs.getString(1));
        rs.next();
        this.assertEquals("World", rs.getString(1));
        this.assertFalse(rs.next());
        conn.close();
    }

    private void checkExplain(Statement stat, String sql, String expected) throws SQLException {
        ResultSet rs = stat.executeQuery(sql);
        this.assertTrue(rs.next());
        this.assertEquals(expected, rs.getString(1));
    }

    private void testExplain() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE ORGANIZATION(id int primary key, name varchar(100))");
        stat.execute("CREATE TABLE PERSON(id int primary key, orgId int, name varchar(100), salary int)");
        this.checkExplain(stat, "/* bla-bla */ EXPLAIN SELECT ID FROM ORGANIZATION WHERE id = ?", "SELECT\n    \"ID\"\nFROM \"PUBLIC\".\"ORGANIZATION\"\n    /* PUBLIC.PRIMARY_KEY_D: ID = ?1 */\nWHERE \"ID\" = ?1");
        this.checkExplain(stat, "EXPLAIN SELECT ID FROM ORGANIZATION WHERE id = 1", "SELECT\n    \"ID\"\nFROM \"PUBLIC\".\"ORGANIZATION\"\n    /* PUBLIC.PRIMARY_KEY_D: ID = 1 */\nWHERE \"ID\" = 1");
        this.checkExplain(stat, "EXPLAIN SELECT * FROM PERSON WHERE id = ?", "SELECT\n    \"PUBLIC\".\"PERSON\".\"ID\",\n    \"PUBLIC\".\"PERSON\".\"ORGID\",\n    \"PUBLIC\".\"PERSON\".\"NAME\",\n    \"PUBLIC\".\"PERSON\".\"SALARY\"\nFROM \"PUBLIC\".\"PERSON\"\n    /* PUBLIC.PRIMARY_KEY_8: ID = ?1 */\nWHERE \"ID\" = ?1");
        this.checkExplain(stat, "EXPLAIN SELECT * FROM PERSON WHERE id = 50", "SELECT\n    \"PUBLIC\".\"PERSON\".\"ID\",\n    \"PUBLIC\".\"PERSON\".\"ORGID\",\n    \"PUBLIC\".\"PERSON\".\"NAME\",\n    \"PUBLIC\".\"PERSON\".\"SALARY\"\nFROM \"PUBLIC\".\"PERSON\"\n    /* PUBLIC.PRIMARY_KEY_8: ID = 50 */\nWHERE \"ID\" = 50");
        this.checkExplain(stat, "EXPLAIN SELECT * FROM PERSON WHERE salary > ? and salary < ?", "SELECT\n    \"PUBLIC\".\"PERSON\".\"ID\",\n    \"PUBLIC\".\"PERSON\".\"ORGID\",\n    \"PUBLIC\".\"PERSON\".\"NAME\",\n    \"PUBLIC\".\"PERSON\".\"SALARY\"\nFROM \"PUBLIC\".\"PERSON\"\n    /* PUBLIC.PERSON.tableScan */\nWHERE (\"SALARY\" > ?1)\n    AND (\"SALARY\" < ?2)");
        this.checkExplain(stat, "EXPLAIN SELECT * FROM PERSON WHERE salary > 1000 and salary < 2000", "SELECT\n    \"PUBLIC\".\"PERSON\".\"ID\",\n    \"PUBLIC\".\"PERSON\".\"ORGID\",\n    \"PUBLIC\".\"PERSON\".\"NAME\",\n    \"PUBLIC\".\"PERSON\".\"SALARY\"\nFROM \"PUBLIC\".\"PERSON\"\n    /* PUBLIC.PERSON.tableScan */\nWHERE (\"SALARY\" > 1000)\n    AND (\"SALARY\" < 2000)");
        this.checkExplain(stat, "EXPLAIN SELECT * FROM PERSON WHERE name = lower(?)", "SELECT\n    \"PUBLIC\".\"PERSON\".\"ID\",\n    \"PUBLIC\".\"PERSON\".\"ORGID\",\n    \"PUBLIC\".\"PERSON\".\"NAME\",\n    \"PUBLIC\".\"PERSON\".\"SALARY\"\nFROM \"PUBLIC\".\"PERSON\"\n    /* PUBLIC.PERSON.tableScan */\nWHERE \"NAME\" = LOWER(?1)");
        this.checkExplain(stat, "EXPLAIN SELECT * FROM PERSON WHERE name = lower('Smith')", "SELECT\n    \"PUBLIC\".\"PERSON\".\"ID\",\n    \"PUBLIC\".\"PERSON\".\"ORGID\",\n    \"PUBLIC\".\"PERSON\".\"NAME\",\n    \"PUBLIC\".\"PERSON\".\"SALARY\"\nFROM \"PUBLIC\".\"PERSON\"\n    /* PUBLIC.PERSON.tableScan */\nWHERE \"NAME\" = 'smith'");
        this.checkExplain(stat, "EXPLAIN SELECT * FROM PERSON p INNER JOIN ORGANIZATION o ON p.id = o.id WHERE o.id = ? AND p.salary > ?", "SELECT\n    \"P\".\"ID\",\n    \"P\".\"ORGID\",\n    \"P\".\"NAME\",\n    \"P\".\"SALARY\",\n    \"O\".\"ID\",\n    \"O\".\"NAME\"\nFROM \"PUBLIC\".\"ORGANIZATION\" \"O\"\n    /* PUBLIC.PRIMARY_KEY_D: ID = ?1 */\n    /* WHERE O.ID = ?1\n    */\nINNER JOIN \"PUBLIC\".\"PERSON\" \"P\"\n    /* PUBLIC.PRIMARY_KEY_8: ID = O.ID */\n    ON 1=1\nWHERE (\"P\".\"ID\" = \"O\".\"ID\")\n    AND (\"O\".\"ID\" = ?1)\n    AND (\"P\".\"SALARY\" > ?2)");
        this.checkExplain(stat, "EXPLAIN SELECT * FROM PERSON p INNER JOIN ORGANIZATION o ON p.id = o.id WHERE o.id = 10 AND p.salary > 1000", "SELECT\n    \"P\".\"ID\",\n    \"P\".\"ORGID\",\n    \"P\".\"NAME\",\n    \"P\".\"SALARY\",\n    \"O\".\"ID\",\n    \"O\".\"NAME\"\nFROM \"PUBLIC\".\"ORGANIZATION\" \"O\"\n    /* PUBLIC.PRIMARY_KEY_D: ID = 10 */\n    /* WHERE O.ID = 10\n    */\nINNER JOIN \"PUBLIC\".\"PERSON\" \"P\"\n    /* PUBLIC.PRIMARY_KEY_8: ID = O.ID */\n    ON 1=1\nWHERE (\"P\".\"ID\" = \"O\".\"ID\")\n    AND (\"O\".\"ID\" = 10)\n    AND (\"P\".\"SALARY\" > 1000)");
        PreparedStatement pStat = conn.prepareStatement("/* bla-bla */ EXPLAIN SELECT ID FROM ORGANIZATION WHERE id = ?");
        ResultSet rs = pStat.executeQuery();
        this.assertTrue(rs.next());
        this.assertEquals("SELECT\n    \"ID\"\nFROM \"PUBLIC\".\"ORGANIZATION\"\n    /* PUBLIC.PRIMARY_KEY_D: ID = ?1 */\nWHERE \"ID\" = ?1", rs.getString(1));
        conn.close();
    }

    private void testExplainAnalyze() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE ORGANIZATION(id int primary key, name varchar(100))");
        stat.execute("CREATE TABLE PERSON(id int primary key, orgId int, name varchar(100), salary int)");
        stat.execute("INSERT INTO ORGANIZATION VALUES(1, 'org1')");
        stat.execute("INSERT INTO ORGANIZATION VALUES(2, 'org2')");
        stat.execute("INSERT INTO PERSON VALUES(1, 1, 'person1', 1000)");
        stat.execute("INSERT INTO PERSON VALUES(2, 1, 'person2', 2000)");
        stat.execute("INSERT INTO PERSON VALUES(3, 2, 'person3', 3000)");
        stat.execute("INSERT INTO PERSON VALUES(4, 2, 'person4', 4000)");
        this.assertThrows(90012, stat, "/* bla-bla */ EXPLAIN ANALYZE SELECT ID FROM ORGANIZATION WHERE id = ?");
        PreparedStatement pStat = conn.prepareStatement("/* bla-bla */ EXPLAIN ANALYZE SELECT ID FROM ORGANIZATION WHERE id = ?");
        this.assertThrows(90012, pStat).executeQuery();
        pStat.setInt(1, 1);
        ResultSet rs = pStat.executeQuery();
        this.assertTrue(rs.next());
        this.assertEquals("SELECT\n    \"ID\"\nFROM \"PUBLIC\".\"ORGANIZATION\"\n    /* PUBLIC.PRIMARY_KEY_D: ID = ?1 */\n    /* scanCount: 2 */\nWHERE \"ID\" = ?1", rs.getString(1));
        pStat = conn.prepareStatement("EXPLAIN ANALYZE SELECT * FROM PERSON p INNER JOIN ORGANIZATION o ON o.id = p.id WHERE o.id = ?");
        this.assertThrows(90012, pStat).executeQuery();
        pStat.setInt(1, 1);
        rs = pStat.executeQuery();
        this.assertTrue(rs.next());
        this.assertEquals("SELECT\n    \"P\".\"ID\",\n    \"P\".\"ORGID\",\n    \"P\".\"NAME\",\n    \"P\".\"SALARY\",\n    \"O\".\"ID\",\n    \"O\".\"NAME\"\nFROM \"PUBLIC\".\"PERSON\" \"P\"\n    /* PUBLIC.PRIMARY_KEY_8: ID = ?1 */\n    /* scanCount: 2 */\nINNER JOIN \"PUBLIC\".\"ORGANIZATION\" \"O\"\n    /* PUBLIC.PRIMARY_KEY_D: ID = ?1\n        AND ID = P.ID\n     */\n    ON 1=1\n    /* scanCount: 2 */\nWHERE (\"O\".\"ID\" = ?1)\n    AND (\"O\".\"ID\" = \"P\".\"ID\")", rs.getString(1));
        conn.close();
    }

    private void testAlterTableReconnect() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id identity);");
        stat.execute("insert into test values(1);");
        this.assertThrows(23502, stat).execute("alter table test add column name varchar not null;");
        conn.close();
        conn = this.getConnection("cases");
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM TEST");
        rs.next();
        this.assertEquals("1", rs.getString(1));
        this.assertFalse(rs.next());
        stat = conn.createStatement();
        stat.execute("drop table test");
        stat.execute("create table test(id identity)");
        stat.execute("insert into test values(1)");
        stat.execute("alter table test alter column id set default 'x'");
        conn.close();
        conn = this.getConnection("cases");
        stat = conn.createStatement();
        rs = conn.createStatement().executeQuery("SELECT * FROM TEST");
        rs.next();
        this.assertEquals("1", rs.getString(1));
        this.assertFalse(rs.next());
        stat.execute("drop table test");
        stat.execute("create table test(id identity)");
        stat.execute("insert into test values(1)");
        this.assertThrows(22018, stat).execute("alter table test alter column id date");
        conn.close();
        conn = this.getConnection("cases");
        rs = conn.createStatement().executeQuery("SELECT * FROM TEST");
        rs.next();
        this.assertEquals("1", rs.getString(1));
        this.assertFalse(rs.next());
        conn.close();
    }

    private void testCollation() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("SET COLLATION ENGLISH STRENGTH PRIMARY");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello'), (2, 'World'), (3, 'WORLD'), (4, 'HELLO')");
        stat.execute("create index idxname on test(name)");
        ResultSet rs = stat.executeQuery("select name from test order by name");
        rs.next();
        this.assertEquals("Hello", rs.getString(1));
        rs.next();
        this.assertEquals("HELLO", rs.getString(1));
        rs.next();
        this.assertEquals("World", rs.getString(1));
        rs.next();
        this.assertEquals("WORLD", rs.getString(1));
        rs = stat.executeQuery("select name from test where name like 'He%'");
        rs.next();
        this.assertEquals("Hello", rs.getString(1));
        rs.next();
        this.assertEquals("HELLO", rs.getString(1));
        conn.close();
    }

    private void testPersistentSettings() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("SET COLLATION de_DE");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        stat.execute("CREATE INDEX IDXNAME ON TEST(NAME)");
        stat.execute("INSERT INTO TEST VALUES(1, 'B\u00f6hlen'), (2, 'Bach'), (3, 'Bucher')");
        conn.close();
        conn = this.getConnection("cases");
        ResultSet rs = conn.createStatement().executeQuery("SELECT NAME FROM TEST ORDER BY NAME");
        rs.next();
        this.assertEquals("Bach", rs.getString(1));
        rs.next();
        this.assertEquals("B\u00f6hlen", rs.getString(1));
        rs.next();
        this.assertEquals("Bucher", rs.getString(1));
        conn.close();
    }

    private void testInsertSelectUnion() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ORDER_ID INT PRIMARY KEY, ORDER_DATE DATETIME, USER_ID INT, DESCRIPTION VARCHAR, STATE VARCHAR, TRACKING_ID VARCHAR)");
        Timestamp orderDate = Timestamp.valueOf("2005-05-21 17:46:00");
        String sql = "insert into TEST (ORDER_ID,ORDER_DATE,USER_ID,DESCRIPTION,STATE,TRACKING_ID) select cast(? as int),cast(? as date),cast(? as int),cast(? as varchar),cast(? as varchar),cast(? as varchar) union all select ?,?,?,?,?,?";
        PreparedStatement ps = conn.prepareStatement(sql);
        ps.setInt(1, 5555);
        ps.setTimestamp(2, orderDate);
        ps.setInt(3, 2222);
        ps.setString(4, "test desc");
        ps.setString(5, "test_state");
        ps.setString(6, "testid");
        ps.setInt(7, 5556);
        ps.setTimestamp(8, orderDate);
        ps.setInt(9, 2222);
        ps.setString(10, "test desc");
        ps.setString(11, "test_state");
        ps.setString(12, "testid");
        this.assertEquals(2, ps.executeUpdate());
        ps.close();
        conn.close();
    }

    private void testViewReconnect() throws SQLException {
        this.trace("testViewReconnect");
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int)");
        stat.execute("create view abc as select * from test");
        stat.execute("drop table test cascade");
        conn.close();
        conn = this.getConnection("cases");
        stat = conn.createStatement();
        this.assertThrows(42104, stat).execute("select * from abc");
        conn.close();
    }

    private void testDefaultQueryReconnect() throws SQLException {
        this.trace("testDefaultQueryReconnect");
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("create table parent(id int)");
        stat.execute("insert into parent values(1)");
        stat.execute("create table test(id int default (select max(id) from parent), name varchar)");
        conn.close();
        conn = this.getConnection("cases");
        stat = conn.createStatement();
        conn.setAutoCommit(false);
        stat.execute("insert into parent values(2)");
        stat.execute("insert into test(name) values('test')");
        ResultSet rs = stat.executeQuery("select * from test");
        rs.next();
        this.assertEquals(2, rs.getInt(1));
        this.assertFalse(rs.next());
        conn.close();
    }

    private void testBigString() throws SQLException {
        this.trace("testBigString");
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(ID INT, TEXT VARCHAR, TEXT_C CLOB)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?, ?, ?)");
        int len = this.getSize(1000, 66000);
        char[] buff = new char[len];
        Random random = new Random();
        random.setSeed(1L);
        int i = 0;
        while (i < len) {
            char c;
            while ((c = (char)random.nextInt()) >= '\ud800' && c <= '\udfff') {
            }
            buff[i] = c;
            ++i;
        }
        String big = new String(buff);
        prep.setInt(1, 1);
        prep.setString(2, big);
        prep.setString(3, big);
        prep.execute();
        prep.setInt(1, 2);
        prep.setCharacterStream(2, (Reader)new StringReader(big), 0);
        prep.setCharacterStream(3, (Reader)new StringReader(big), 0);
        prep.execute();
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals(big, rs.getString(2));
        this.assertEquals(big, this.readString(rs.getCharacterStream(2)));
        this.assertEquals(big, rs.getString(3));
        this.assertEquals(big, this.readString(rs.getCharacterStream(3)));
        rs.next();
        this.assertEquals(2, rs.getInt(1));
        this.assertEquals(big, rs.getString(2));
        this.assertEquals(big, this.readString(rs.getCharacterStream(2)));
        this.assertEquals(big, rs.getString(3));
        this.assertEquals(big, this.readString(rs.getCharacterStream(3)));
        rs.next();
        this.assertFalse(rs.next());
        conn.close();
    }

    private void testConstraintReconnect() throws SQLException {
        this.trace("testConstraintReconnect");
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("drop table if exists parent");
        stat.execute("drop table if exists child");
        stat.execute("create table parent(id int primary key)");
        stat.execute("create table child(c_id int, p_id int, foreign key(p_id) references parent(id))");
        stat.execute("insert into parent values(1), (2)");
        stat.execute("insert into child values(1, 1)");
        stat.execute("insert into child values(2, 2)");
        stat.execute("insert into child values(3, 2)");
        stat.execute("delete from child");
        conn.close();
        conn = this.getConnection("cases");
        conn.close();
    }

    private void testDoubleRecovery() throws SQLException {
        if (this.config.networked || this.config.googleAppEngine) {
            return;
        }
        this.trace("testDoubleRecovery");
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("SET WRITE_DELAY 0");
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello')");
        conn.setAutoCommit(false);
        stat.execute("INSERT INTO TEST VALUES(2, 'World')");
        this.crash(conn);
        conn = this.getConnection("cases");
        stat = conn.createStatement();
        stat.execute("SET WRITE_DELAY 0");
        stat.execute("INSERT INTO TEST VALUES(3, 'Break')");
        this.crash(conn);
        conn = this.getConnection("cases");
        stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        rs.next();
        this.assertEquals(3, rs.getInt(1));
        this.assertEquals("Break", rs.getString(2));
        conn.close();
    }

    private void testRenameReconnect() throws SQLException {
        this.trace("testRenameReconnect");
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        conn.createStatement().execute("CREATE TABLE TEST_SEQ(ID INT GENERATED BY DEFAULT AS IDENTITY, NAME VARCHAR(255))");
        conn.createStatement().execute("CREATE TABLE TEST(ID INT PRIMARY KEY)");
        conn.createStatement().execute("ALTER TABLE TEST RENAME TO TEST2");
        conn.createStatement().execute("CREATE TABLE TEST_B(ID INT PRIMARY KEY, NAME VARCHAR, UNIQUE(NAME))");
        conn.close();
        conn = this.getConnection("cases");
        ResultSet rs = conn.createStatement().executeQuery("SELECT ID FROM FINAL TABLE(INSERT INTO TEST_SEQ(NAME) VALUES('Hi'))");
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        conn.createStatement().execute("SELECT * FROM TEST2");
        conn.createStatement().execute("SELECT * FROM TEST_B");
        conn.createStatement().execute("ALTER TABLE TEST_B RENAME TO TEST_B2");
        conn.close();
        conn = this.getConnection("cases");
        conn.createStatement().execute("SELECT * FROM TEST_B2");
        rs = conn.createStatement().executeQuery("SELECT ID FROM FINAL TABLE(INSERT INTO TEST_SEQ(NAME) VALUES('World'))");
        rs.next();
        this.assertEquals(2, rs.getInt(1));
        conn.close();
    }

    private void testSelectForUpdate() throws SQLException {
        this.trace("testSelectForUpdate");
        this.deleteDb("cases");
        Connection conn1 = this.getConnection("cases");
        Statement stat1 = conn1.createStatement();
        stat1.execute("CREATE TABLE TEST(ID INT)");
        stat1.execute("INSERT INTO TEST VALUES(1)");
        conn1.setAutoCommit(false);
        stat1.execute("SELECT * FROM TEST FOR UPDATE");
        Connection conn2 = this.getConnection("cases");
        Statement stat2 = conn2.createStatement();
        this.assertThrows(50200, stat2).execute("UPDATE TEST SET ID=2");
        conn1.commit();
        stat2.execute("UPDATE TEST SET ID=2");
        conn1.close();
        conn2.close();
    }

    private void testMutableObjects() throws SQLException {
        this.trace("testMutableObjects");
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT, D DATE, T TIME, TS TIMESTAMP)");
        stat.execute("INSERT INTO TEST VALUES(1, '2001-01-01', '20:00:00', '2002-02-02 22:22:22.2')");
        stat.execute("INSERT INTO TEST VALUES(1, '2001-01-01', '20:00:00', '2002-02-02 22:22:22.2')");
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST");
        rs.next();
        Date d1 = rs.getDate("D");
        Time t1 = rs.getTime("T");
        Timestamp ts1 = rs.getTimestamp("TS");
        rs.next();
        Date d2 = rs.getDate("D");
        Time t2 = rs.getTime("T");
        Timestamp ts2 = rs.getTimestamp("TS");
        this.assertTrue(ts1 != ts2);
        this.assertTrue(d1 != d2);
        this.assertTrue(t1 != t2);
        this.assertTrue(t2 != rs.getObject("T"));
        this.assertTrue(d2 != rs.getObject("D"));
        this.assertTrue(ts2 != rs.getObject("TS"));
        this.assertFalse(rs.next());
        conn.close();
    }

    private void testCreateDrop() throws SQLException {
        this.trace("testCreateDrop");
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("create table employee(id int, firstName VARCHAR(50), salary decimal(10, 2), superior_id int, CONSTRAINT PK_employee PRIMARY KEY (id), CONSTRAINT FK_superior FOREIGN KEY (superior_id) REFERENCES employee(ID))");
        stat.execute("DROP TABLE employee");
        conn.close();
        conn = this.getConnection("cases");
        conn.close();
    }

    private void testPolePos() throws SQLException {
        this.trace("testPolePos");
        Connection c0 = this.getConnection("cases");
        c0.createStatement().executeUpdate("SET AUTOCOMMIT FALSE");
        c0.createStatement().executeUpdate("create table australia (ID  INTEGER NOT NULL, Name VARCHAR(100), firstName VARCHAR(100), Points INTEGER, LicenseID INTEGER, PRIMARY KEY(ID))");
        c0.createStatement().executeUpdate("COMMIT");
        c0.close();
        c0 = this.getConnection("cases");
        c0.createStatement().executeUpdate("SET AUTOCOMMIT FALSE");
        PreparedStatement p15 = c0.prepareStatement("insert into australia(id, Name, firstName, Points, LicenseID) values (?, ?, ?, ?, ?)");
        int len = this.getSize(1, 1000);
        int i = 0;
        while (i < len) {
            p15.setInt(1, i);
            p15.setString(2, "Pilot_" + i);
            p15.setString(3, "Herkules");
            p15.setInt(4, i);
            p15.setInt(5, i);
            p15.executeUpdate();
            ++i;
        }
        c0.createStatement().executeUpdate("COMMIT");
        c0.close();
        c0 = this.getConnection("cases");
        c0.createStatement().executeUpdate("SET AUTOCOMMIT FALSE");
        c0.createStatement().executeUpdate("drop table australia");
        c0.createStatement().executeUpdate("create table australia (ID  INTEGER NOT NULL, Name VARCHAR(100), firstName VARCHAR(100), Points INTEGER, LicenseID INTEGER, PRIMARY KEY(ID))");
        c0.createStatement().executeUpdate("COMMIT");
        c0.close();
        c0 = this.getConnection("cases");
        c0.createStatement().executeUpdate("SET AUTOCOMMIT FALSE");
        PreparedStatement p65 = c0.prepareStatement("insert into australia(id, Name, FirstName, Points, LicenseID) values (?, ?, ?, ?, ?)");
        len = this.getSize(1, 1000);
        int i2 = 0;
        while (i2 < len) {
            p65.setInt(1, i2);
            p65.setString(2, "Pilot_" + i2);
            p65.setString(3, "Herkules");
            p65.setInt(4, i2);
            p65.setInt(5, i2);
            p65.executeUpdate();
            ++i2;
        }
        c0.createStatement().executeUpdate("COMMIT");
        c0.createStatement().executeUpdate("COMMIT");
        c0.createStatement().executeUpdate("COMMIT");
        c0.close();
        c0 = this.getConnection("cases");
        c0.close();
    }

    private void testQuick() throws SQLException {
        this.trace("testQuick");
        this.deleteDb("cases");
        Connection c0 = this.getConnection("cases");
        c0.createStatement().executeUpdate("create table test (ID  int PRIMARY KEY)");
        c0.createStatement().executeUpdate("insert into test values(1)");
        c0.createStatement().executeUpdate("drop table test");
        c0.createStatement().executeUpdate("create table test (ID  int PRIMARY KEY)");
        c0.close();
        c0 = this.getConnection("cases");
        c0.createStatement().executeUpdate("insert into test values(1)");
        c0.close();
        c0 = this.getConnection("cases");
        c0.close();
    }

    private void testOrderByWithSubselect() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("create table master(id number primary key, name varchar2(30));");
        stat.execute("create table detail(id number references master(id), location varchar2(30));");
        stat.execute("Insert into master values(1,'a'), (2,'b'), (3,'c');");
        stat.execute("Insert into detail values(1,'a'), (2,'b'), (3,'c');");
        ResultSet rs = stat.executeQuery("select master.id, master.name from master where master.id in (select detail.id from detail) order by master.id");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertTrue(rs.next());
        this.assertEquals(2, rs.getInt(1));
        this.assertTrue(rs.next());
        this.assertEquals(3, rs.getInt(1));
        conn.close();
    }

    private void testDeleteAndDropTableWithLobs(boolean useDrop) throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(id int, content BLOB)");
        stat.execute("set MAX_LENGTH_INPLACE_LOB 1");
        PreparedStatement prepared = conn.prepareStatement("INSERT INTO TEST VALUES(?, ?)");
        byte[] blobContent = "BLOB_CONTENT".getBytes();
        prepared.setInt(1, 1);
        prepared.setBytes(2, blobContent);
        prepared.execute();
        if (useDrop) {
            stat.execute("DROP TABLE TEST");
        } else {
            stat.execute("DELETE FROM TEST");
        }
        conn.close();
        List<String> list = FileUtils.newDirectoryStream(this.getBaseDir() + "/cases.lobs.db");
        this.assertEquals("Lob file was not deleted: " + String.valueOf(list), 0, list.size());
    }

    private void testMinimalCoveringIndexPlan() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("create table t(a int, b int, c int)");
        stat.execute("create index a_idx on t(a)");
        stat.execute("create index b_idx on t(b)");
        stat.execute("create index ab_idx on t(a, b)");
        stat.execute("create index abc_idx on t(a, b, c)");
        ResultSet rs = stat.executeQuery("explain select a from t");
        this.assertTrue(rs.next());
        String plan = rs.getString(1);
        this.assertContains(plan, "/* PUBLIC.A_IDX */");
        rs.close();
        rs = stat.executeQuery("explain select b from t");
        this.assertTrue(rs.next());
        plan = rs.getString(1);
        this.assertContains(plan, "/* PUBLIC.B_IDX */");
        rs.close();
        rs = stat.executeQuery("explain select b, a from t");
        this.assertTrue(rs.next());
        plan = rs.getString(1);
        this.assertContains(plan, "/* PUBLIC.AB_IDX */");
        rs.close();
        rs = stat.executeQuery("explain select b, a, c from t");
        this.assertTrue(rs.next());
        plan = rs.getString(1);
        this.assertContains(plan, "/* PUBLIC.ABC_IDX */");
        rs.close();
        conn.close();
    }

    private void testMinMaxDirectLookupIndex() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("create table t(a int, b int)");
        stat.execute("create index b_idx on t(b desc)");
        stat.execute("create index ab_idx on t(a, b)");
        int count = 100;
        PreparedStatement p = conn.prepareStatement("insert into t values (?,?)");
        int i = 0;
        while (i <= 100) {
            p.setInt(1, i);
            p.setInt(2, 100 - i);
            this.assertEquals(1, p.executeUpdate());
            ++i;
        }
        p.close();
        ResultSet rs = stat.executeQuery("select max(b) from t");
        this.assertTrue(rs.next());
        this.assertEquals(100, rs.getInt(1));
        rs.close();
        rs = stat.executeQuery("explain select max(b) from t");
        this.assertTrue(rs.next());
        String plan = rs.getString(1);
        this.assertContains(plan, "/* PUBLIC.B_IDX */");
        this.assertContains(plan, "/* direct lookup */");
        rs.close();
        rs = stat.executeQuery("select min(b) from t");
        this.assertTrue(rs.next());
        this.assertEquals(0, rs.getInt(1));
        rs.close();
        rs = stat.executeQuery("explain select min(b) from t");
        this.assertTrue(rs.next());
        plan = rs.getString(1);
        this.assertContains(plan, "/* PUBLIC.B_IDX */");
        this.assertContains(plan, "/* direct lookup */");
        rs.close();
        conn.close();
    }

    private void testLikeExpressions() throws SQLException {
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("select * from (select 'fo%' a union all select '%oo') where 'foo' like a");
        this.assertTrue(rs.next());
        this.assertEquals("fo%", rs.getString(1));
        this.assertTrue(rs.next());
        this.assertEquals("%oo", rs.getString(1));
        conn.close();
    }

    private void testDataChangeDeltaTable() throws SQLException {
        String updateCommand = "UPDATE TEST SET V = 3 WHERE ID = 1";
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT, V INT)");
        this.assertEquals(0, stat.executeUpdate(updateCommand));
        ResultSet rs = stat.executeQuery("SELECT V FROM FINAL TABLE (INSERT INTO TEST VALUES (1, 1))");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals(1, stat.executeUpdate(updateCommand));
        rs = stat.executeQuery("SELECT V FROM TEST");
        this.assertTrue(rs.next());
        this.assertEquals(3, rs.getInt(1));
        conn.close();
    }

    private void testGroupSortedReset() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE T1(A INT PRIMARY KEY, B INT) AS VALUES (1, 4), (2, 5), (3, 6)");
        String sql = "SELECT B FROM T1 LEFT JOIN (VALUES 2) T2(A) USING(A) WHERE T2.A = 2 GROUP BY T1.A";
        stat.execute(sql);
        stat.execute("UPDATE T1 SET B = 7 WHERE A = 3");
        stat.execute(sql);
        conn.close();
    }

    private void testShowColumns() throws SQLException {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(A INTEGER)");
        PreparedStatement prep = conn.prepareStatement("SHOW COLUMNS FROM TEST");
        ResultSet rs = prep.executeQuery();
        this.assertTrue(rs.next());
        this.assertFalse(rs.next());
        stat.execute("ALTER TABLE TEST ADD COLUMN B INTEGER");
        rs = prep.executeQuery();
        this.assertTrue(rs.next());
        this.assertTrue(rs.next());
        this.assertFalse(rs.next());
        conn.close();
    }
}

