/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.h2.Driver;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.tools.CreateCluster;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Server;
import org.h2.util.JdbcUtils;

public class TestCluster
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public boolean isEnabled() {
        return !this.config.memory && !this.config.networked && this.config.cipher == null;
    }

    @Override
    public void test() throws Exception {
        this.testClob();
        this.testRecover();
        this.testRollback();
        this.testCase();
        this.testClientInfo();
        this.testCreateClusterAtRuntime();
        this.testStartStopCluster();
    }

    private void testClob() throws SQLException {
        this.deleteFiles();
        Driver.load();
        String user = this.getUser();
        String password = this.getPassword();
        Server n1 = null;
        try {
            n1 = Server.createTcpServer("-ifNotExists", "-baseDir", this.getBaseDir() + "/node1").start();
            int port1 = n1.getPort();
            String url1 = this.getURL("jdbc:h2:tcp://localhost:" + port1 + "/test", false);
            Throwable throwable = null;
            Object var7_8 = null;
            try (Connection conn = this.getConnection(url1, user, password);){
                Statement stat = conn.createStatement();
                stat.execute("create table t1(id int, name clob)");
                stat.execute("insert into t1 values(1, repeat('Hello', 50))");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            Server n2 = null;
            try {
                n2 = Server.createTcpServer("-ifNotExists", "-baseDir", this.getBaseDir() + "/node2").start();
                int port2 = n2.getPort();
                String url2 = this.getURL("jdbc:h2:tcp://localhost:" + port2 + "/test", false);
                String serverList = "localhost:" + port1 + ",localhost:" + port2;
                String urlCluster = this.getURL("jdbc:h2:tcp://" + serverList + "/test", true);
                CreateCluster.main("-urlSource", url1, "-urlTarget", url2, "-user", user, "-password", password, "-serverList", serverList);
                Connection conn = this.getConnection(urlCluster, user, password);
                conn.close();
            }
            finally {
                if (n2 != null) {
                    n2.stop();
                }
            }
        }
        finally {
            if (n1 != null) {
                n1.stop();
            }
            this.deleteFiles();
        }
    }

    private void testRecover() throws SQLException {
        this.deleteFiles();
        Driver.load();
        String user = this.getUser();
        String password = this.getPassword();
        Server server1 = Server.createTcpServer("-ifNotExists", "-baseDir", this.getBaseDir() + "/node1").start();
        int port1 = server1.getPort();
        Server server2 = Server.createTcpServer("-ifNotExists", "-baseDir", this.getBaseDir() + "/node2").start();
        int port2 = server2.getPort();
        String url1 = this.getURL("jdbc:h2:tcp://localhost:" + port1 + "/test", true);
        String url2 = this.getURL("jdbc:h2:tcp://localhost:" + port2 + "/test", true);
        String serverList = "localhost:" + port1 + ",localhost:" + port2;
        String urlCluster = this.getURL("jdbc:h2:tcp://" + serverList + "/test", true);
        CreateCluster.main("-urlSource", url1, "-urlTarget", url2, "-user", user, "-password", password, "-serverList", serverList);
        Connection conn = this.getConnection(urlCluster, user, password);
        Statement stat = conn.createStatement();
        stat.execute("create table t1(id int, name varchar(30))");
        stat.execute("insert into t1 values(1, 'a'), (2, 'b'), (3, 'c')");
        ResultSet rs = stat.executeQuery("select count(*) from t1");
        rs.next();
        this.assertEquals(3, rs.getInt(1));
        server2.stop();
        DeleteDbFiles.main("-dir", this.getBaseDir() + "/node2", "-quiet");
        stat.execute("insert into t1 values(4, 'd'), (5, 'e')");
        rs = stat.executeQuery("select count(*) from t1");
        rs.next();
        this.assertEquals(5, rs.getInt(1));
        server2 = Server.createTcpServer("-ifNotExists", "-tcpPort", "" + port2, "-baseDir", this.getBaseDir() + "/node2").start();
        CreateCluster.main("-urlSource", url1, "-urlTarget", url2, "-user", user, "-password", password, "-serverList", serverList);
        conn.close();
        conn = this.getConnection(urlCluster, user, password);
        stat = conn.createStatement();
        rs = stat.executeQuery("select count(*) from t1");
        rs.next();
        this.assertEquals(5, rs.getInt(1));
        conn.close();
        server1.stop();
        server2.stop();
        this.deleteFiles();
    }

    private void testRollback() throws SQLException {
        this.deleteFiles();
        Driver.load();
        String user = this.getUser();
        String password = this.getPassword();
        Server n1 = Server.createTcpServer("-ifNotExists", "-baseDir", this.getBaseDir() + "/node1").start();
        int port1 = n1.getPort();
        Server n2 = Server.createTcpServer("-ifNotExists", "-baseDir", this.getBaseDir() + "/node2").start();
        int port2 = n2.getPort();
        String url1 = this.getURL("jdbc:h2:tcp://localhost:" + port1 + "/test", true);
        String url2 = this.getURL("jdbc:h2:tcp://localhost:" + port2 + "/test", true);
        String serverList = "localhost:" + port1 + ",localhost:" + port2;
        String urlCluster = this.getURL("jdbc:h2:tcp://" + serverList + "/test", true);
        CreateCluster.main("-urlSource", url1, "-urlTarget", url2, "-user", user, "-password", password, "-serverList", serverList);
        Connection conn = this.getConnection(urlCluster, user, password);
        Statement stat = conn.createStatement();
        this.assertTrue(conn.getAutoCommit());
        stat.execute("create table test(id int, name varchar)");
        this.assertTrue(conn.getAutoCommit());
        stat.execute("set autocommit false");
        conn.setAutoCommit(false);
        this.assertFalse(conn.getAutoCommit());
        stat.execute("insert into test values(1, 'Hello')");
        stat.execute("rollback");
        ResultSet rs = stat.executeQuery("select * from test order by id");
        this.assertFalse(rs.next());
        conn.close();
        n1.stop();
        n2.stop();
        this.deleteFiles();
    }

    private void testCase() throws SQLException {
        this.deleteFiles();
        Driver.load();
        String user = this.getUser();
        String password = this.getPassword();
        Server n1 = Server.createTcpServer("-ifNotExists", "-baseDir", this.getBaseDir() + "/node1").start();
        int port1 = n1.getPort();
        Server n2 = Server.createTcpServer("-ifNotExists", "-baseDir", this.getBaseDir() + "/node2").start();
        int port2 = n2.getPort();
        String serverList = "localhost:" + port1 + ",localhost:" + port2;
        String url1 = this.getURL("jdbc:h2:tcp://localhost:" + port1 + "/test", true);
        String url2 = this.getURL("jdbc:h2:tcp://localhost:" + port2 + "/test", true);
        String urlCluster = this.getURL("jdbc:h2:tcp://" + serverList + "/test", true);
        CreateCluster.main("-urlSource", url1, "-urlTarget", url2, "-user", user, "-password", password, "-serverList", serverList);
        Connection conn = this.getConnection(urlCluster, user, password);
        Statement stat = conn.createStatement();
        this.assertTrue(conn.getAutoCommit());
        stat.execute("create table test(name int)");
        this.assertTrue(conn.getAutoCommit());
        stat.execute("insert into test values(1)");
        conn.setAutoCommit(false);
        this.assertFalse(conn.getAutoCommit());
        stat.execute("insert into test values(2)");
        this.assertFalse(conn.getAutoCommit());
        conn.rollback();
        ResultSet rs = stat.executeQuery("select * from test order by name");
        this.assertTrue(rs.next());
        this.assertFalse(rs.next());
        conn.close();
        n2.stop();
        conn = this.getConnection(urlCluster, user, password);
        stat = conn.createStatement();
        rs = stat.executeQuery("select * from test");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        conn.close();
        n1.stop();
        this.deleteFiles();
    }

    private void testClientInfo() throws SQLException {
        this.deleteFiles();
        Driver.load();
        String user = this.getUser();
        String password = this.getPassword();
        Server n1 = Server.createTcpServer("-ifNotExists", "-baseDir", this.getBaseDir() + "/node1").start();
        int port1 = n1.getPort();
        Server n2 = Server.createTcpServer("-ifNotExists", "-baseDir", this.getBaseDir() + "/node2").start();
        int port2 = n2.getPort();
        String serverList = "localhost:" + port1 + ",localhost:" + port2;
        String url1 = this.getURL("jdbc:h2:tcp://localhost:" + port1 + "/test", true);
        String url2 = this.getURL("jdbc:h2:tcp://localhost:" + port2 + "/test", true);
        String urlCluster = this.getURL("jdbc:h2:tcp://" + serverList + "/test", true);
        CreateCluster.main("-urlSource", url1, "-urlTarget", url2, "-user", user, "-password", password, "-serverList", serverList);
        Connection conn = this.getConnection(urlCluster, user, password);
        Properties p = conn.getClientInfo();
        this.assertEquals("2", p.getProperty("numServers"));
        this.assertEquals("127.0.0.1:" + port1, p.getProperty("server0"));
        this.assertEquals("127.0.0.1:" + port2, p.getProperty("server1"));
        this.assertEquals("2", conn.getClientInfo("numServers"));
        this.assertEquals("127.0.0.1:" + port1, conn.getClientInfo("server0"));
        this.assertEquals("127.0.0.1:" + port2, conn.getClientInfo("server1"));
        conn.close();
        n2.stop();
        conn = this.getConnection(urlCluster, user, password);
        p = conn.getClientInfo();
        this.assertEquals("1", p.getProperty("numServers"));
        this.assertEquals("127.0.0.1:" + port1, p.getProperty("server0"));
        this.assertEquals("1", conn.getClientInfo("numServers"));
        this.assertEquals("127.0.0.1:" + port1, conn.getClientInfo("server0"));
        conn.close();
        n1.stop();
        this.deleteFiles();
    }

    private void testCreateClusterAtRuntime() throws SQLException {
        this.deleteFiles();
        Driver.load();
        String user = this.getUser();
        String password = this.getPassword();
        int len = 10;
        Server n1 = Server.createTcpServer("-ifNotExists", "-baseDir", this.getBaseDir() + "/node1").start();
        int port1 = n1.getPort();
        String url1 = this.getURL("jdbc:h2:tcp://localhost:" + port1 + "/test", false);
        Connection conn = this.getConnection(url1, user, password);
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, name varchar) as select x, 'Data' || x from system_range(0, " + (len - 1) + ")");
        stat.execute("create user test password 'test'");
        stat.execute("grant all on test to test");
        Server n2 = Server.createTcpServer("-ifNotExists", "-baseDir", this.getBaseDir() + "/node2").start();
        int port2 = n2.getPort();
        String url2 = this.getURL("jdbc:h2:tcp://localhost:" + port2 + "/test", false);
        String serverList = "localhost:" + port1 + ",localhost:" + port2;
        CreateCluster.main("-urlSource", url1, "-urlTarget", url2, "-user", user, "-password", password, "-serverList", serverList);
        this.assertThrows(90067, stat).execute("select * from test");
        JdbcUtils.closeSilently(conn);
        String urlCluster = this.getURL("jdbc:h2:tcp://" + serverList + "/test", false);
        Connection connApp = this.getConnection(urlCluster + ";AUTO_RECONNECT=TRUE", user, password);
        this.check(connApp, len, "'" + serverList + "'");
        connApp.setAutoCommit(false);
        connApp.createStatement().execute("delete from test");
        n2.stop();
        connApp.createStatement().executeQuery("select count(*) from test");
        connApp.rollback();
        this.check(connApp, len, "''");
        connApp.setAutoCommit(true);
        n2 = Server.createTcpServer("-ifNotExists", "-tcpPort", "" + port2, "-baseDir", this.getBaseDir() + "/node2").start();
        CreateCluster.main("-urlSource", url1, "-urlTarget", url2, "-user", user, "-password", password, "-serverList", serverList);
        this.check(connApp, len, "'" + serverList + "'");
        connApp.close();
        String user2 = "test";
        String password2 = this.getPassword("test");
        connApp = this.getConnection(urlCluster, user2, password2);
        this.check(connApp, len, "'" + serverList + "'");
        connApp.close();
        n1.stop();
        Connection connApp2 = this.getConnection(urlCluster + ";AUTO_RECONNECT=TRUE", user2, password2);
        this.check(connApp2, len, "''");
        connApp2.close();
        connApp2 = this.getConnection(urlCluster + ";AUTO_RECONNECT=TRUE", user2, password2);
        this.check(connApp2, len, "''");
        connApp2.close();
        n2.stop();
        this.deleteFiles();
    }

    private void testStartStopCluster() throws SQLException {
        int port1 = 9193;
        int port2 = 9194;
        String serverList = "localhost:" + port1 + ",localhost:" + port2;
        this.deleteFiles();
        Driver.load();
        String urlNode1 = this.getURL("node1/test", true);
        String urlNode2 = this.getURL("node2/test", true);
        String user = this.getUser();
        String password = this.getPassword();
        Connection conn = this.getConnection(urlNode1, user, password);
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?, ?)");
        int len = this.getSize(10, 1000);
        int i = 0;
        while (i < len) {
            prep.setInt(1, i);
            prep.setString(2, "Data" + i);
            prep.executeUpdate();
            ++i;
        }
        this.check(conn, len, "''");
        conn.close();
        CreateCluster.main("-urlSource", urlNode1, "-urlTarget", urlNode2, "-user", user, "-password", password, "-serverList", serverList);
        Server n1 = Server.createTcpServer("-tcpPort", "" + port1, "-baseDir", this.getBaseDir() + "/node1").start();
        Server n2 = Server.createTcpServer("-tcpPort", "" + port2, "-baseDir", this.getBaseDir() + "/node2").start();
        this.assertThrows(90094, () -> this.getConnection("jdbc:h2:tcp://localhost:" + port1 + "/test", user, password));
        this.assertThrows(90094, () -> this.getConnection("jdbc:h2:tcp://localhost:" + port2 + "/test", user, password));
        conn = this.getConnection("jdbc:h2:tcp://" + serverList + "/test", user, password);
        this.check(conn, len, "'" + serverList + "'");
        conn.close();
        n2.stop();
        conn = this.getConnection("jdbc:h2:tcp://" + serverList + "/test", user, password);
        this.check(conn, len, "''");
        conn.close();
        conn = this.getConnection("jdbc:h2:tcp://" + serverList + "/test", user, password);
        this.check(conn, len, "''");
        conn.close();
        conn = this.getConnection("jdbc:h2:tcp://localhost:" + port1 + "/test;CLUSTER=''", user, password);
        conn.close();
        n1.stop();
        DeleteDbFiles.main("-dir", this.getBaseDir() + "/node2", "-quiet");
        CreateCluster.main("-urlSource", urlNode1, "-urlTarget", urlNode2, "-user", user, "-password", password, "-serverList", serverList);
        n1 = Server.createTcpServer("-tcpPort", "" + port1, "-baseDir", this.getBaseDir() + "/node1").start();
        n2 = Server.createTcpServer("-tcpPort", "" + port2, "-baseDir", this.getBaseDir() + "/node2").start();
        conn = this.getConnection("jdbc:h2:tcp://" + serverList + "/test", user, password);
        stat = conn.createStatement();
        stat.execute("CREATE TABLE BOTH(ID INT)");
        n1.stop();
        stat.execute("CREATE TABLE A(ID INT)");
        conn.close();
        n2.stop();
        n1 = Server.createTcpServer("-tcpPort", "" + port1, "-baseDir", this.getBaseDir() + "/node1").start();
        conn = this.getConnection("jdbc:h2:tcp://localhost:" + port1 + "/test;CLUSTER=''", user, password);
        this.check(conn, len, "''");
        conn.close();
        n1.stop();
        n2 = Server.createTcpServer("-tcpPort", "" + port2, "-baseDir", this.getBaseDir() + "/node2").start();
        conn = this.getConnection("jdbc:h2:tcp://localhost:" + port2 + "/test;CLUSTER=''", user, password);
        this.check(conn, len, "''");
        conn.createStatement().execute("SELECT * FROM A");
        conn.close();
        n2.stop();
        this.deleteFiles();
    }

    private void deleteFiles() throws SQLException {
        DeleteDbFiles.main("-dir", this.getBaseDir() + "/node1", "-quiet");
        DeleteDbFiles.main("-dir", this.getBaseDir() + "/node2", "-quiet");
        FileUtils.delete(this.getBaseDir() + "/node1");
        FileUtils.delete(this.getBaseDir() + "/node2");
    }

    private void check(Connection conn, int len, String expectedCluster) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("SELECT * FROM TEST WHERE ID=?");
        int i = 0;
        while (i < len) {
            prep.setInt(1, i);
            ResultSet rs = prep.executeQuery();
            rs.next();
            this.assertEquals("Data" + i, rs.getString(2));
            this.assertFalse(rs.next());
            ++i;
        }
        ResultSet rs = conn.createStatement().executeQuery("SELECT SETTING_VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE SETTING_NAME = 'CLUSTER'");
        String cluster = rs.next() ? rs.getString(1) : "''";
        this.assertEquals(expectedCluster, cluster);
    }
}

