/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestCompatibility
extends TestDb {
    private Connection conn;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws SQLException {
        this.deleteDb("compatibility");
        this.testCaseSensitiveIdentifiers();
        this.conn = this.getConnection("compatibility");
        this.testDomain();
        this.testColumnAlias();
        this.testUniqueIndexSingleNull();
        this.testUniqueIndexOracle();
        this.testPostgreSQL();
        this.testHsqlDb();
        this.testMySQL();
        this.testConcurrentAutoIncrement();
        this.testDB2();
        this.testDerby();
        this.testSybaseAndMSSQLServer();
        this.testUnknownSet();
        this.conn.close();
        this.testIdentifiers();
        this.testIdentifiersCaseInResultSet();
        this.testDatabaseToLowerParser();
        this.testOldInformationSchema();
        this.deleteDb("compatibility");
        this.testUnknownURL();
    }

    private void testCaseSensitiveIdentifiers() throws SQLException {
        Connection c = this.getConnection("compatibility;DATABASE_TO_UPPER=FALSE;CASE_INSENSITIVE_IDENTIFIERS=TRUE");
        Statement stat = c.createStatement();
        stat.execute("create table test(id int primary key, name varchar) as select 1, 'hello'");
        this.assertThrows(42101, stat).execute("create table test(id int primary key, name varchar)");
        this.assertThrows(42121, stat).execute("alter table test add column Name varchar");
        DatabaseMetaData meta = c.getMetaData();
        ResultSet rs = meta.getTables(null, null, "test", null);
        this.assertTrue(rs.next());
        this.assertEquals("test", rs.getString("TABLE_NAME"));
        rs = stat.executeQuery("select id, name from test");
        this.assertEquals("id", rs.getMetaData().getColumnLabel(1));
        this.assertEquals("name", rs.getMetaData().getColumnLabel(2));
        rs = stat.executeQuery("select Id, Name from Test");
        this.assertEquals("id", rs.getMetaData().getColumnLabel(1));
        this.assertEquals("name", rs.getMetaData().getColumnLabel(2));
        rs = stat.executeQuery("select ID, NAME from TEST");
        this.assertEquals("id", rs.getMetaData().getColumnLabel(1));
        this.assertEquals("name", rs.getMetaData().getColumnLabel(2));
        stat.execute("select COUNT(*), count(*), Count(*), Sum(id) from test");
        stat.execute("select LENGTH(name), length(name), Length(name) from test");
        stat.execute("select t.id from test t group by t.id");
        stat.execute("select id from test t group by t.id");
        stat.execute("select id from test group by ID");
        stat.execute("select id as c from test group by c");
        stat.execute("select t.id from test t group by T.ID");
        stat.execute("select id from test t group by T.ID");
        stat.execute("drop table test");
        rs = stat.executeQuery("select 1e10, 1000000000000000000000e10, 0xfAfBl");
        this.assertTrue(rs.next());
        this.assertEquals(1.0E10, rs.getDouble(1));
        this.assertEquals(1.0E31, rs.getDouble(2));
        this.assertEquals(64251L, rs.getLong(3));
        this.assertFalse(rs.next());
        stat.execute("create table \"t 1\" (a int, b int)");
        stat.execute("create view v as select * from \"t 1\"");
        stat.executeQuery("select * from v").close();
        stat.execute("drop view v");
        stat.execute("drop table \"t 1\"");
        c.close();
    }

    private void testDomain() throws SQLException {
        if (this.config.memory) {
            return;
        }
        Statement stat = this.conn.createStatement();
        stat.execute("create table test(id int primary key) as select 1");
        this.assertThrows(90119, stat).execute("create domain int as varchar");
        this.conn.close();
        this.conn = this.getConnection("compatibility");
        stat = this.conn.createStatement();
        stat.execute("insert into test values(2)");
        stat.execute("drop table test");
    }

    private void testColumnAlias() throws SQLException {
        Statement stat = this.conn.createStatement();
        String[] modes = new String[]{"PostgreSQL", "MySQL", "HSQLDB", "MSSQLServer", "Derby", "Oracle", "Regular"};
        String columnAlias = "HSQLDB,MySQL,Regular";
        stat.execute("CREATE TABLE TEST(ID INT)");
        String[] stringArray = modes;
        int n = modes.length;
        int n2 = 0;
        while (n2 < n) {
            String mode = stringArray[n2];
            stat.execute("SET MODE " + mode);
            ResultSet rs = stat.executeQuery("SELECT ID I FROM TEST");
            ResultSetMetaData meta = rs.getMetaData();
            this.assertEquals(mode + " mode", "I", meta.getColumnLabel(1));
            String columnName = meta.getColumnName(1);
            String tableName = meta.getTableName(1);
            String schemaName = meta.getSchemaName(1);
            if (columnAlias.contains(mode)) {
                this.assertEquals(mode + " mode", "ID", columnName);
                this.assertEquals(mode + " mode", "TEST", tableName);
                this.assertEquals(mode + " mode", "PUBLIC", schemaName);
            } else {
                this.assertEquals(mode + " mode", "I", columnName);
                this.assertEquals(mode + " mode", "", tableName);
                this.assertEquals(mode + " mode", "", schemaName);
            }
            ++n2;
        }
        stat.execute("DROP TABLE TEST");
    }

    private void testUniqueIndexSingleNull() throws SQLException {
        Statement stat = this.conn.createStatement();
        String[] modes = new String[]{"PostgreSQL", "MySQL", "HSQLDB", "MSSQLServer", "Derby", "Oracle", "Regular"};
        String multiNull = "PostgreSQL,MySQL,HSQLDB,Oracle,Regular";
        String[] stringArray = modes;
        int n = modes.length;
        int n2 = 0;
        while (n2 < n) {
            String mode = stringArray[n2];
            stat.execute("SET MODE " + mode);
            stat.execute("CREATE TABLE TEST(ID INT)");
            stat.execute("CREATE UNIQUE INDEX IDX_ID_U ON TEST(ID)");
            try {
                stat.execute("INSERT INTO TEST VALUES(1), (2), (NULL), (NULL)");
                this.assertTrue(mode + " mode should not support multiple NULL", multiNull.contains(mode));
            }
            catch (SQLException e) {
                this.assertTrue(mode + " mode should support multiple NULL", multiNull.indexOf(mode) < 0);
            }
            stat.execute("DROP TABLE TEST");
            ++n2;
        }
    }

    private void testUniqueIndexOracle() throws SQLException {
        Statement stat = this.conn.createStatement();
        stat.execute("SET MODE ORACLE");
        stat.execute("create table t2(c1 int, c2 int)");
        stat.execute("create unique index i2 on t2(c1, c2)");
        stat.execute("insert into t2 values (null, 1)");
        this.assertThrows(23505, stat).execute("insert into t2 values (null, 1)");
        stat.execute("insert into t2 values (null, null)");
        stat.execute("insert into t2 values (null, null)");
        stat.execute("insert into t2 values (1, null)");
        this.assertThrows(23505, stat).execute("insert into t2 values (1, null)");
        stat.execute("DROP TABLE T2");
    }

    private void testHsqlDb() throws SQLException {
        Statement stat = this.conn.createStatement();
        stat.execute("set mode hsqldb");
        this.testLog(Math.log(10.0), stat);
        stat.execute("DROP TABLE TEST IF EXISTS; CREATE TABLE TEST(ID INT PRIMARY KEY); ");
        stat.execute("CALL CURRENT_TIME");
        stat.execute("CALL CURRENT_TIMESTAMP");
        stat.execute("CALL CURRENT_DATE");
        stat.execute("CALL SYSDATE");
        stat.execute("CALL TODAY");
        stat.execute("DROP TABLE TEST IF EXISTS");
    }

    private void testLog(double expected, Statement stat) throws SQLException {
        stat.execute("create table log(id int)");
        stat.execute("insert into log values(1)");
        ResultSet rs = stat.executeQuery("select log(10) from log");
        rs.next();
        this.assertEquals((int)(expected * 100.0), (int)(rs.getDouble(1) * 100.0));
        rs = stat.executeQuery("select ln(10) from log");
        rs.next();
        this.assertEquals((int)(Math.log(10.0) * 100.0), (int)(rs.getDouble(1) * 100.0));
        stat.execute("drop table log");
    }

    private void testPostgreSQL() throws SQLException {
        String[] DISALLOWED_TYPES;
        Statement stat = this.conn.createStatement();
        stat.execute("SET MODE PostgreSQL");
        this.testLog(Math.log10(10.0), stat);
        this.assertResult("ABC", stat, "SELECT SUBSTRING('ABCDEF' FOR 3)");
        this.assertResult("ABCD", stat, "SELECT SUBSTRING('0ABCDEF' FROM 2 FOR 4)");
        stat.execute("CREATE TABLE TEST(CH CHAR(10))");
        stat.execute("INSERT INTO TEST (CH) VALUES ('Hello')");
        this.assertResult("Hello     ", stat, "SELECT CH FROM TEST");
        this.assertResult("Hello     ", stat, "SELECT CH FROM TEST WHERE CH = 'Hello'");
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(CH CHAR)");
        stat.execute("INSERT INTO TEST (CH) VALUES ('')");
        this.assertResult(" ", stat, "SELECT CH FROM TEST");
        this.assertResult(" ", stat, "SELECT CH FROM TEST WHERE CH = ''");
        stat.execute("DELETE FROM TEST");
        stat.execute("INSERT INTO TEST (CH) VALUES ('1   ')");
        this.assertResult("1", stat, "SELECT CH FROM TEST");
        this.assertResult("1", stat, "SELECT CH FROM TEST WHERE CH = '1      '");
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(CH CHAR(2))");
        stat.execute("INSERT INTO TEST (CH) VALUES ('1   ')");
        this.assertResult("1 ", stat, "SELECT CH FROM TEST");
        this.assertResult("1 ", stat, "SELECT CH FROM TEST WHERE CH = '1      '");
        String[] stringArray = DISALLOWED_TYPES = new String[]{"NUMBER", "IDENTITY", "TINYINT", "BLOB"};
        int n = DISALLOWED_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            stat.execute("DROP TABLE IF EXISTS TEST");
            this.assertThrows(50004, stat).execute("CREATE TABLE TEST(COL " + type + ")");
            ++n2;
        }
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(M MONEY)");
        stat.execute("INSERT INTO TEST(M) VALUES (-92233720368547758.08)");
        stat.execute("INSERT INTO TEST(M) VALUES (0.11111)");
        stat.execute("INSERT INTO TEST(M) VALUES (92233720368547758.07)");
        ResultSet rs = stat.executeQuery("SELECT M FROM TEST ORDER BY M");
        this.assertTrue(rs.next());
        this.assertEquals(new BigDecimal("-92233720368547758.08"), rs.getBigDecimal(1));
        this.assertTrue(rs.next());
        this.assertEquals(new BigDecimal("0.11"), rs.getBigDecimal(1));
        this.assertTrue(rs.next());
        this.assertEquals(new BigDecimal("92233720368547758.07"), rs.getBigDecimal(1));
        this.assertFalse(rs.next());
        this.assertEquals(0, stat.getQueryTimeout());
        this.conn.close();
        this.deleteDb("compatibility");
        this.conn = this.getConnection("compatibility;MODE=PostgreSQL");
        stat = this.conn.createStatement();
        stat.execute("SET STATEMENT_TIMEOUT TO 30000");
        this.assertEquals(30, stat.getQueryTimeout());
    }

    private void testMySQL() throws SQLException {
        this.conn.close();
        this.deleteDb("compatibility");
        this.conn = this.getConnection("compatibility;MODE=MYSQL;DATABASE_TO_LOWER=TRUE");
        Statement stat = this.conn.createStatement();
        stat.execute("create schema test_schema");
        stat.execute("use test_schema");
        this.assertResult("test_schema", stat, "select schema()");
        stat.execute("use public");
        this.assertResult("public", stat, "select schema()");
        stat.execute("SELECT 1");
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE `TEST`(ID INT PRIMARY KEY, NAME VARCHAR)");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello'), (2, 'World')");
        this.assertResult(null, stat, "SELECT UNIX_TIMESTAMP(NULL)");
        this.assertResult("0", stat, "SELECT UNIX_TIMESTAMP('1970-01-01 00:00:00Z')");
        this.assertResult("1196418619", stat, "SELECT UNIX_TIMESTAMP('2007-11-30 10:30:19Z')");
        this.assertResult("1196418619", stat, "SELECT UNIX_TIMESTAMP(FROM_UNIXTIME(1196418619))");
        this.assertResult("2007 November", stat, "SELECT FROM_UNIXTIME(1196300000, '%Y %M')");
        this.assertResult("2003-12-31", stat, "SELECT DATE('2003-12-31 11:02:03')");
        this.assertResult("2003-12-31", stat, "SELECT DATE('2003-12-31 11:02:03')");
        this.assertResult(null, stat, "SELECT DATE('100')");
        stat.execute("DELETE TEST FROM TEST WHERE 1=2");
        String string = "ABCD\u1234";
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        stat.execute("CREATE TABLE TEST2(C VARCHAR, B VARBINARY)");
        stat.execute("INSERT INTO TEST2(C) VALUES ('" + string + "')");
        this.assertEquals(1, stat.executeUpdate("UPDATE TEST2 SET B = C"));
        ResultSet rs = stat.executeQuery("SELECT B FROM TEST2");
        this.assertTrue(rs.next());
        this.assertEquals(bytes, rs.getBytes(1));
        this.assertEquals(bytes, rs.getBytes("B"));
        this.assertEquals(1, stat.executeUpdate("UPDATE TEST2 SET C = B"));
        this.testMySQLBytesCheck(stat, string, bytes);
        PreparedStatement prep = this.conn.prepareStatement("UPDATE TEST2 SET C = ?");
        prep.setBytes(1, bytes);
        this.assertEquals(1, prep.executeUpdate());
        this.testMySQLBytesCheck(stat, string, bytes);
        stat.execute("DELETE FROM TEST2");
        prep = this.conn.prepareStatement("INSERT INTO TEST2(C) VALUES (?)");
        prep.setBytes(1, bytes);
        this.assertEquals(1, prep.executeUpdate());
        this.testMySQLBytesCheck(stat, string, bytes);
        prep = this.conn.prepareStatement("SELECT C FROM TEST2 WHERE C = ?");
        prep.setBytes(1, bytes);
        this.testMySQLBytesCheck(prep.executeQuery(), string, bytes);
        stat.execute("CREATE INDEX TEST2_C ON TEST2(C)");
        prep = this.conn.prepareStatement("SELECT C FROM TEST2 WHERE C = ?");
        prep.setBytes(1, bytes);
        this.testMySQLBytesCheck(prep.executeQuery(), string, bytes);
        stat.execute("DROP TABLE TEST2");
        if (!this.config.memory) {
            this.conn.close();
            this.conn = this.getConnection("compatibility;MODE=MYSQL;DATABASE_TO_LOWER=TRUE");
            stat = this.conn.createStatement();
            this.testLog(Math.log(10.0), stat);
            DatabaseMetaData meta = this.conn.getMetaData();
            this.assertTrue(meta.storesLowerCaseIdentifiers());
            this.assertFalse(meta.storesLowerCaseQuotedIdentifiers());
            this.assertFalse(meta.storesMixedCaseIdentifiers());
            this.assertFalse(meta.storesMixedCaseQuotedIdentifiers());
            this.assertFalse(meta.storesUpperCaseIdentifiers());
            this.assertFalse(meta.storesUpperCaseQuotedIdentifiers());
            stat = this.conn.createStatement(1004, 1008);
            this.assertResult("test", stat, "SHOW TABLES");
            rs = stat.executeQuery("SELECT * FROM TEST");
            rs.next();
            rs.updateString(2, "Hallo");
            rs.updateRow();
            rs = stat.executeQuery("SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME > 'aaaa'");
            rs = stat.executeQuery("SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME < 'aaaa'");
            stat.execute("CREATE TABLE TEST_1(ID INT PRIMARY KEY) ENGINE=InnoDb");
            stat.execute("CREATE TABLE TEST_2(ID INT PRIMARY KEY) ENGINE=MyISAM");
            stat.execute("CREATE TABLE TEST_3(ID INT PRIMARY KEY) ENGINE=InnoDb charset=UTF8");
            stat.execute("CREATE TABLE TEST_4(ID INT PRIMARY KEY) charset=UTF8");
            stat.execute("CREATE TABLE TEST_5(ID INT AUTO_INCREMENT PRIMARY KEY) ENGINE=InnoDb auto_increment=3 default charset=UTF8");
            stat.execute("CREATE TABLE TEST_6(ID INT AUTO_INCREMENT PRIMARY KEY) ENGINE=MyISAM default character set UTF8MB4, auto_increment 3");
            stat.execute("CREATE TABLE TEST_7(ID INT AUTO_INCREMENT PRIMARY KEY) ENGINE=InnoDb auto_increment=3 charset=UTF8 comment 'text'");
            stat.execute("CREATE TABLE TEST_8(ID INT AUTO_INCREMENT PRIMARY KEY) ENGINE=InnoDb auto_increment=3 character set=UTF8");
            stat.execute("CREATE TABLE TEST_9(ID INT, KEY TEST_7_IDX(ID) USING BTREE)");
            stat.execute("CREATE TABLE TEST_10(ID INT, UNIQUE KEY TEST_10_IDX(ID) USING BTREE)");
            stat.execute("CREATE TABLE TEST_11(ID INT) COLLATE UTF8");
            stat.execute("CREATE TABLE TEST_12(ID INT) DEFAULT COLLATE UTF8");
            stat.execute("CREATE TABLE TEST_13(a VARCHAR(10) COLLATE UTF8MB4)");
            stat.execute("CREATE TABLE TEST_14(a VARCHAR(10) NULL CHARACTER SET UTF8MB4 COLLATE UTF8MB4_BIN)");
            stat.execute("ALTER TABLE TEST_14 CONVERT TO CHARACTER SET UTF8MB4 COLLATE UTF8MB4_UNICODE_CI");
            stat.execute("ALTER TABLE TEST_14 MODIFY a VARCHAR(10) NOT NULL CHARACTER SET UTF8MB4 COLLATE UTF8");
            this.assertThrows(42000, stat).execute("CREATE TABLE TEST_99(ID INT PRIMARY KEY) CHARSET UTF8,");
            this.assertThrows(42122, stat).execute("CREATE TABLE TEST_99(ID INT PRIMARY KEY) AUTO_INCREMENT 100");
            this.assertThrows(42122, stat).execute("CREATE TABLE TEST_99(ID INT) AUTO_INCREMENT 100");
            stat.execute("SET foreign_key_checks = 0");
            stat.execute("SET foreign_key_checks = 1");
            this.conn.close();
            this.conn = this.getConnection("compatibility;MODE=MYSQL;DATABASE_TO_LOWER=TRUE");
            stat = this.conn.createStatement();
            stat.execute("DROP TABLE IF EXISTS TEST_NO_COMMENT");
            stat.execute("CREATE table TEST_NO_COMMENT (ID bigint not null auto_increment, SOME_STR varchar(255), primary key (ID))");
            stat.execute("DROP TABLE IF EXISTS TEST_COMMENT");
            stat.execute("create table TEST_COMMENT (ID bigint not null auto_increment, SOME_STR varchar(255), primary key (ID)) comment='Some comment.'");
            stat.execute("DROP TABLE IF EXISTS TEST_COMMENT_ENGINE");
            stat.execute("create table TEST_COMMENT_ENGINE (ID bigint not null auto_increment, ATTACHMENT_ID varchar(255), SOME_ITEM_ID bigint not null, primary key (ID), unique (ATTACHMENT_ID, SOME_ITEM_ID)) comment='Comment Again' ENGINE=InnoDB");
            stat.execute("CREATE TABLE TEST2(ID INT) ROW_FORMAT=DYNAMIC");
            stat.execute("ALTER TABLE TEST_COMMENT_ENGINE ADD CONSTRAINT CommentUnique UNIQUE (SOME_ITEM_ID)");
            stat.execute("ALTER TABLE TEST_COMMENT_ENGINE DROP INDEX CommentUnique");
            stat.execute("CREATE INDEX IDX_ATTACHMENT_ID ON TEST_COMMENT_ENGINE (ATTACHMENT_ID)");
            stat.execute("DROP INDEX IDX_ATTACHMENT_ID ON TEST_COMMENT_ENGINE");
            stat.execute("DROP ALL OBJECTS");
        }
        this.conn.close();
        this.deleteDb("compatibility");
        this.conn = this.getConnection("compatibility");
    }

    private void testMySQLBytesCheck(Statement stat, String string, byte[] bytes) throws SQLException {
        this.testMySQLBytesCheck(stat.executeQuery("SELECT C FROM TEST2"), string, bytes);
    }

    private void testMySQLBytesCheck(ResultSet rs, String string, byte[] bytes) throws SQLException {
        this.assertTrue(rs.next());
        this.assertEquals(string, rs.getString(1));
        this.assertEquals(bytes, rs.getBytes(1));
        this.assertEquals(bytes, rs.getBytes("C"));
    }

    /*
     * Unable to fully structure code
     */
    private void testConcurrentAutoIncrement() throws SQLException {
        nThreads = 50;
        threads = new Thread[nThreads];
        ref = new AtomicReference<V>();
        stat = this.conn.createStatement();
        stat.execute("SET MODE MySQL;");
        stat.execute("CREATE TABLE TEST(ID INT AUTO_INCREMENT PRIMARY KEY, V INT)");
        try {
            i = 0;
            while (i < nThreads) {
                threads[i] = new Thread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$0(java.util.concurrent.atomic.AtomicReference ), ()V)((TestCompatibility)this, ref));
                ++i;
            }
            i = 0;
            while (i < nThreads) {
                threads[i].start();
                ++i;
            }
        }
        finally {
            i = 0;
            ** while (i < nThreads)
        }
lbl-1000:
        // 1 sources

        {
            t = threads[i];
            if (t != null) {
                try {
                    t.join();
                }
                catch (Exception var9_14) {
                    // empty catch block
                }
            }
            ++i;
            continue;
        }
lbl33:
        // 1 sources

        stat.execute("DROP TABLE TEST");
        e = (SQLException)ref.get();
        if (e != null) {
            throw e;
        }
    }

    private void testSybaseAndMSSQLServer() throws SQLException {
        Statement stat = this.conn.createStatement();
        stat.execute("SET MODE MSSQLServer");
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(NAME VARCHAR(50), SURNAME VARCHAR(50))");
        stat.execute("INSERT INTO TEST VALUES('John', 'Doe')");
        stat.execute("INSERT INTO TEST VALUES('Jack', 'Sullivan')");
        this.assertResult("abcd123", stat, "SELECT 'abc' + 'd123'");
        this.assertResult("Doe, John", stat, "SELECT surname + ', ' + name FROM test WHERE SUBSTRING(NAME,1,1)+SUBSTRING(SURNAME,1,1) = 'JD'");
        stat.execute("ALTER TABLE TEST ADD COLUMN full_name VARCHAR(100)");
        stat.execute("UPDATE TEST SET full_name = name + ', ' + surname");
        this.assertResult("John, Doe", stat, "SELECT full_name FROM TEST where name='John'");
        PreparedStatement prep = this.conn.prepareStatement("INSERT INTO TEST VALUES(?, ?, ? + ', ' + ?)");
        int ca = 1;
        prep.setString(ca++, "Paul");
        prep.setString(ca++, "Frank");
        prep.setString(ca++, "Paul");
        prep.setString(ca++, "Frank");
        prep.executeUpdate();
        prep.close();
        this.assertResult("Paul, Frank", stat, "SELECT full_name FROM test WHERE name = 'Paul'");
        prep = this.conn.prepareStatement("SELECT ? + ?");
        int cb = 1;
        prep.setString(cb++, "abcd123");
        prep.setString(cb++, "d123");
        prep.executeQuery();
        prep.close();
        prep = this.conn.prepareStatement("SELECT full_name FROM test WHERE (SUBSTRING(name, 1, 1) + SUBSTRING(surname, 2, 3)) = ?");
        prep.setString(1, "Joe");
        ResultSet rs = prep.executeQuery();
        this.assertTrue("Result cannot be empty", rs.next());
        this.assertEquals("John, Doe", rs.getString(1));
        rs.close();
        prep.close();
        rs = stat.executeQuery("SELECT CONVERT(INT, '10')");
        rs.next();
        this.assertEquals(10, rs.getInt(1));
        rs.close();
        rs = stat.executeQuery("SELECT X FROM (SELECT CONVERT(INT, '10') AS X)");
        rs.next();
        this.assertEquals(10, rs.getInt(1));
        rs.close();
        rs = stat.executeQuery("select * from test (index table1_index)");
        rs.close();
        stat.execute("create table test3 (id UNIQUEIDENTIFIER)");
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(M MONEY)");
        stat.execute("INSERT INTO TEST(M) VALUES (-922337203685477.5808)");
        stat.execute("INSERT INTO TEST(M) VALUES (0.11111)");
        stat.execute("INSERT INTO TEST(M) VALUES (922337203685477.5807)");
        rs = stat.executeQuery("SELECT M FROM TEST ORDER BY M");
        this.assertTrue(rs.next());
        this.assertEquals(new BigDecimal("-922337203685477.5808"), rs.getBigDecimal(1));
        this.assertTrue(rs.next());
        this.assertEquals(new BigDecimal("0.1111"), rs.getBigDecimal(1));
        this.assertTrue(rs.next());
        this.assertEquals(new BigDecimal("922337203685477.5807"), rs.getBigDecimal(1));
        this.assertFalse(rs.next());
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(M SMALLMONEY)");
        stat.execute("INSERT INTO TEST(M) VALUES (-214748.3648)");
        stat.execute("INSERT INTO TEST(M) VALUES (0.11111)");
        stat.execute("INSERT INTO TEST(M) VALUES (214748.3647)");
        rs = stat.executeQuery("SELECT M FROM TEST ORDER BY M");
        this.assertTrue(rs.next());
        this.assertEquals(new BigDecimal("-214748.3648"), rs.getBigDecimal(1));
        this.assertTrue(rs.next());
        this.assertEquals(new BigDecimal("0.1111"), rs.getBigDecimal(1));
        this.assertTrue(rs.next());
        this.assertEquals(new BigDecimal("214748.3647"), rs.getBigDecimal(1));
        this.assertFalse(rs.next());
    }

    private void testDB2() throws SQLException {
        this.conn.close();
        this.conn = this.getConnection("compatibility;MODE=DB2");
        Statement stat = this.conn.createStatement();
        this.testLog(Math.log(10.0), stat);
        ResultSet res = this.conn.createStatement().executeQuery("SELECT 1 FROM sysibm.sysdummy1");
        res.next();
        this.assertEquals("1", res.getString(1));
        this.conn.close();
        this.conn = this.getConnection("compatibility;MODE=MySQL");
        this.assertThrows(90079, this.conn.createStatement()).executeQuery("SELECT 1 FROM sysibm.sysdummy1");
        this.conn.close();
        this.conn = this.getConnection("compatibility;MODE=DB2");
        stat = this.conn.createStatement();
        stat.execute("drop table test if exists");
        stat.execute("create table test(id varchar)");
        stat.execute("insert into test values ('3'),('1'),('2')");
        res = stat.executeQuery("select id from test order by id fetch next 2 rows only");
        res.next();
        this.assertEquals("1", res.getString(1));
        res.next();
        this.assertEquals("2", res.getString(1));
        this.assertFalse(res.next());
        this.conn.close();
        this.conn = this.getConnection("compatibility;MODE=DB2");
        stat = this.conn.createStatement();
        stat.execute("drop table test if exists");
        stat.execute("create table test(id varchar)");
        res = stat.executeQuery("select * from test with ur");
        stat.executeUpdate("insert into test values (1) with ur");
        res = stat.executeQuery("select * from test where id = 1 with rr");
        res = stat.executeQuery("select * from test order by id fetch next 2 rows only with rr");
        res = stat.executeQuery("select * from test order by id fetch next 2 rows only with rs");
        res = stat.executeQuery("select * from test order by id fetch next 2 rows only with cs");
        res = stat.executeQuery("select * from test order by id fetch next 2 rows only with ur");
        res = stat.executeQuery("select * from test order by id fetch next 2 rows only with rr use and keep share locks");
        res = stat.executeQuery("select * from test order by id fetch next 2 rows only with rs use and keep update locks");
        res = stat.executeQuery("select * from test order by id fetch next 2 rows only with rr use and keep exclusive locks");
        stat.execute("drop table test if exists");
        stat.execute("create table test(date TIMESTAMP)");
        stat.executeUpdate("insert into test (date) values ('2014-04-05-09.48.28.020005')");
        this.assertResult("2014-04-05 09:48:28.020005", stat, "select date from test");
        this.assertResult("2014-04-05 09:48:28.020005", stat, "select date from test where date = '2014-04-05-09.48.28.020005'");
        this.assertResult("2014-04-05 09:48:28.020005", stat, "select date from test where date = '2014-04-05 09:48:28.020005'");
        this.assertResult("TRUE", stat, "SELECT LOCALTIMESTAMP = CURRENT TIMESTAMP");
        this.assertResult("TRUE", stat, "SELECT CAST(LOCALTIMESTAMP AS VARCHAR) = CAST(CURRENT TIMESTAMP AS VARCHAR)");
        this.assertResult("TRUE", stat, "SELECT CURRENT_TIMESTAMP = CURRENT TIMESTAMP WITH TIME ZONE");
        this.assertResult("TRUE", stat, "SELECT CAST(CURRENT_TIMESTAMP AS VARCHAR) = CAST(CURRENT TIMESTAMP WITH TIME ZONE AS VARCHAR)");
        this.assertResult("TRUE", stat, "SELECT CURRENT_TIME = CURRENT TIME");
        this.assertResult("TRUE", stat, "SELECT CURRENT_DATE = CURRENT DATE");
    }

    private void testDerby() throws SQLException {
        this.conn.close();
        this.conn = this.getConnection("compatibility;MODE=Derby");
        Statement stat = this.conn.createStatement();
        this.testLog(Math.log(10.0), stat);
        ResultSet res = this.conn.createStatement().executeQuery("SELECT 1 FROM sysibm.sysdummy1 fetch next 1 row only");
        res.next();
        this.assertEquals("1", res.getString(1));
        this.conn.close();
        this.conn = this.getConnection("compatibility;MODE=PostgreSQL");
        this.assertThrows(90079, this.conn.createStatement()).executeQuery("SELECT 1 FROM sysibm.sysdummy1");
        this.conn.close();
        this.conn = this.getConnection("compatibility");
    }

    private void testUnknownSet() throws SQLException {
        Statement stat = this.conn.createStatement();
        this.assertThrows(90088, stat).execute("SET MODE UnknownMode");
    }

    private void testIdentifiers() throws SQLException {
        this.deleteDb("compatibility");
        this.testIdentifiers(false, false, false);
        this.testIdentifiers(false, false, true);
        this.testIdentifiers(true, false, false);
        this.testIdentifiers(true, false, true);
        this.testIdentifiers(false, true, false);
        this.testIdentifiers(false, true, true);
    }

    private void testIdentifiers(boolean upper, boolean lower, boolean caseInsensitiveIdentifiers) throws SQLException {
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (Connection conn = this.getConnection("compatibility;DATABASE_TO_UPPER=" + upper + ";DATABASE_TO_LOWER=" + lower + ";CASE_INSENSITIVE_IDENTIFIERS=" + caseInsensitiveIdentifiers);){
                Statement stat = conn.createStatement();
                stat.execute("CREATE TABLE Test(Id INT) AS VALUES 2");
                String schema = "PUBLIC";
                String table = "Test";
                String column = "Id";
                if (upper) {
                    table = table.toUpperCase(Locale.ROOT);
                    column = column.toUpperCase(Locale.ROOT);
                } else if (lower) {
                    schema = schema.toLowerCase(Locale.ROOT);
                    table = table.toLowerCase(Locale.ROOT);
                    column = column.toLowerCase(Locale.ROOT);
                }
                Throwable throwable2 = null;
                Throwable throwable3 = null;
                try (ResultSet rs = stat.executeQuery("SELECT TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME ILIKE 'Test'");){
                    this.assertTrue(rs.next());
                    this.assertEquals(schema, rs.getString(1));
                    this.assertEquals(table, rs.getString(2));
                    this.assertEquals(column, rs.getString(3));
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                    } else if (throwable2 != throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    throw throwable2;
                }
                this.testIdentifiers(stat, "Test", "Id", true);
                this.testIdentifiers(stat, "`Test`", "`Id`", true);
                boolean ok = upper || lower || caseInsensitiveIdentifiers;
                this.testIdentifiers(stat, "TEST", "ID", ok);
                this.testIdentifiers(stat, "`TEST`", "`ID`", ok);
                this.testIdentifiers(stat, "test", "id", ok);
                this.testIdentifiers(stat, "`test`", "`id`", ok);
                this.testIdentifiers(stat, "\"" + table + "\"", "\"" + column + "\"", true);
                this.testIdentifiers(stat, "\"TeSt\"", "\"iD\"", caseInsensitiveIdentifiers);
                stat.execute("CREATE TABLE T2(\"`\" INT, `\"'\"` INT) AS VALUES (1, 2)");
                throwable3 = null;
                Object var13_19 = null;
                try (ResultSet rs = stat.executeQuery("SELECT ````, \"\"\"'\"\"\" FROM T2");){
                    this.assertTrue(rs.next());
                    this.assertEquals(1, rs.getInt(1));
                    this.assertEquals(2, rs.getInt(2));
                }
                catch (Throwable throwable5) {
                    if (throwable3 == null) {
                        throwable3 = throwable5;
                    } else if (throwable3 != throwable5) {
                        throwable3.addSuppressed(throwable5);
                    }
                    throw throwable3;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        finally {
            this.deleteDb("compatibility");
        }
    }

    private void testIdentifiers(Statement stat, String table, String column, boolean ok) throws SQLException {
        block10: {
            String query = "SELECT _ROWID_, " + column + " FROM " + table;
            if (ok) {
                Throwable throwable = null;
                Object var7_8 = null;
                try (ResultSet rs = stat.executeQuery(query);){
                    this.assertTrue(rs.next());
                    this.assertEquals(1L, rs.getLong(1));
                    this.assertEquals(2, rs.getInt(2));
                    break block10;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            this.assertThrows(42103, stat).executeQuery(query);
        }
    }

    private void testUnknownURL() {
        this.assertThrows(90088, () -> {
            this.getConnection("compatibility;MODE=Unknown").close();
            this.deleteDb("compatibility");
        });
    }

    private void testIdentifiersCaseInResultSet() throws SQLException {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Connection conn = this.getConnection("compatibility;DATABASE_TO_UPPER=FALSE;CASE_INSENSITIVE_IDENTIFIERS=TRUE");){
                Statement stat = conn.createStatement();
                stat.execute("CREATE TABLE TEST(A INT)");
                ResultSet rs = stat.executeQuery("SELECT a from test");
                ResultSetMetaData md = rs.getMetaData();
                this.assertEquals("A", md.getColumnName(1));
                rs = stat.executeQuery("SELECT a FROM (SELECT 1) t(A)");
                md = rs.getMetaData();
                this.assertEquals("A", md.getColumnName(1));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.deleteDb("compatibility");
        }
    }

    private void testDatabaseToLowerParser() throws SQLException {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Connection conn = this.getConnection("compatibility;DATABASE_TO_LOWER=TRUE");){
                Statement stat = conn.createStatement();
                ResultSet rs = stat.executeQuery("SELECT 0x1234567890AbCdEf");
                rs.next();
                this.assertEquals(1311768467294899695L, rs.getLong(1));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.deleteDb("compatibility");
        }
    }

    private void testOldInformationSchema() throws SQLException {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Connection conn = this.getConnection("compatibility;OLD_INFORMATION_SCHEMA=TRUE");){
                Statement stat = conn.createStatement();
                ResultSet rs = stat.executeQuery("TABLE INFORMATION_SCHEMA.TABLE_TYPES");
                rs.next();
                this.assertEquals("TABLE", rs.getString(1));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.deleteDb("compatibility");
        }
    }

    private /* synthetic */ void lambda$0(AtomicReference atomicReference) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Connection c = this.getConnection("compatibility;MODE=MYSQL");){
                PreparedStatement ps = c.prepareStatement("INSERT INTO TEST(V) VALUES (?)");
                int j = 0;
                while (j < 1000 && atomicReference.get() == null) {
                    ps.setInt(1, j);
                    ps.executeUpdate();
                    ++j;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            atomicReference.compareAndSet(null, e);
        }
    }
}

