/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestCompatibilitySQLServer
extends TestDb {
    public static void main(String ... s) throws Exception {
        TestBase test = TestBase.createCaller().init();
        test.testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.deleteDb("sqlserver");
        Connection conn = this.getConnection("sqlserver;MODE=MSSQLServer");
        try {
            this.testDiscardTableHints(conn);
            this.testPrimaryKeyIdentity(conn);
        }
        finally {
            conn.close();
            this.deleteDb("sqlserver");
        }
    }

    private void testDiscardTableHints(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        stat.execute("create table parent(id int primary key, name varchar(255))");
        stat.execute("create table child(id int primary key, parent_id int, name varchar(255), foreign key (parent_id) references public.parent(id))");
        stat.execute("select * from parent");
        stat.execute("select * from parent with(nolock)");
        stat.execute("select * from parent with(nolock, index = id)");
        stat.execute("select * from parent with(nolock, index(id, name))");
        stat.execute("select * from parent p join child ch on ch.parent_id = p.id");
        stat.execute("select * from parent p with(nolock) join child ch with(nolock) on ch.parent_id = p.id");
        stat.execute("select * from parent p with(nolock) join child ch with(nolock, index = id) on ch.parent_id = p.id");
        stat.execute("select * from parent p with(nolock) join child ch with(nolock, index(id, name)) on ch.parent_id = p.id");
    }

    private void testPrimaryKeyIdentity(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key identity, expected_id int)");
        stat.execute("insert into test (expected_id) VALUES (1), (2), (3)");
        ResultSet results = stat.executeQuery("select * from test");
        while (results.next()) {
            this.assertEquals(results.getInt("expected_id"), results.getInt("id"));
        }
        stat.execute("create table test2 (id int primary key not null identity)");
    }
}

