/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.test.unit.TestDate;
import org.h2.value.ValueTimestamp;

public class TestDateStorage
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws SQLException {
        this.deleteDb(this.getTestName());
        this.testDateTimeTimestampWithCalendar();
        this.testAllTimeZones();
        TestDateStorage.testCurrentTimeZone();
    }

    private void testDateTimeTimestampWithCalendar() throws SQLException {
        Connection conn = this.getConnection(this.getTestName());
        Statement stat = conn.createStatement();
        stat.execute("create table ts(x timestamp primary key)");
        stat.execute("create table t(x time primary key)");
        stat.execute("create table d(x date)");
        GregorianCalendar utcCalendar = new GregorianCalendar(new SimpleTimeZone(0, "Z"));
        stat.execute("SET TIME ZONE 'PST'");
        TimeZone old = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("PST"));
        try {
            Timestamp ts1 = Timestamp.valueOf("2010-03-13 18:15:00");
            Time t1 = new Time(ts1.getTime());
            Date d1 = new Date(ts1.getTime());
            Timestamp ts2 = Timestamp.valueOf("2010-03-13 19:15:00");
            Time t2 = new Time(ts2.getTime());
            Date d2 = new Date(ts2.getTime());
            PreparedStatement prep = conn.prepareStatement("insert into ts values(?)");
            prep.setTimestamp(1, ts1, utcCalendar);
            prep.execute();
            prep.setTimestamp(1, ts2, utcCalendar);
            prep.execute();
            prep = conn.prepareStatement("insert into t values(?)");
            prep.setTime(1, t1, utcCalendar);
            prep.execute();
            prep.setTime(1, t2, utcCalendar);
            prep.execute();
            prep = conn.prepareStatement("insert into d values(?)");
            prep.setDate(1, d1, utcCalendar);
            prep.execute();
            prep.setDate(1, d2, utcCalendar);
            prep.execute();
            ResultSet rs = stat.executeQuery("select * from ts order by x");
            rs.next();
            this.assertEquals("2010-03-14 02:15:00", rs.getString(1));
            this.assertEquals("2010-03-13 18:15:00.0", rs.getTimestamp(1, (Calendar)utcCalendar).toString());
            this.assertEquals("2010-03-14 03:15:00.0", rs.getTimestamp(1).toString());
            this.assertEquals("2010-03-14 02:15:00", rs.getString("x"));
            this.assertEquals("2010-03-13 18:15:00.0", rs.getTimestamp("x", (Calendar)utcCalendar).toString());
            this.assertEquals("2010-03-14 03:15:00.0", rs.getTimestamp("x").toString());
            rs.next();
            this.assertEquals("2010-03-14 03:15:00", rs.getString(1));
            this.assertEquals("2010-03-13 19:15:00.0", rs.getTimestamp(1, (Calendar)utcCalendar).toString());
            this.assertEquals("2010-03-14 03:15:00.0", rs.getTimestamp(1).toString());
            this.assertEquals("2010-03-14 03:15:00", rs.getString("x"));
            this.assertEquals("2010-03-13 19:15:00.0", rs.getTimestamp("x", (Calendar)utcCalendar).toString());
            this.assertEquals("2010-03-14 03:15:00.0", rs.getTimestamp("x").toString());
            rs = stat.executeQuery("select * from t order by x");
            rs.next();
            this.assertEquals("02:15:00", rs.getString(1));
            this.assertEquals("18:15:00", rs.getTime(1, (Calendar)utcCalendar).toString());
            this.assertEquals("02:15:00", rs.getTime(1).toString());
            this.assertEquals("02:15:00", rs.getString("x"));
            this.assertEquals("18:15:00", rs.getTime("x", (Calendar)utcCalendar).toString());
            this.assertEquals("02:15:00", rs.getTime("x").toString());
            rs.next();
            this.assertEquals("03:15:00", rs.getString(1));
            this.assertEquals("19:15:00", rs.getTime(1, (Calendar)utcCalendar).toString());
            this.assertEquals("03:15:00", rs.getTime(1).toString());
            this.assertEquals("03:15:00", rs.getString("x"));
            this.assertEquals("19:15:00", rs.getTime("x", (Calendar)utcCalendar).toString());
            this.assertEquals("03:15:00", rs.getTime("x").toString());
            rs = stat.executeQuery("select * from d order by x");
            rs.next();
            this.assertEquals("2010-03-14", rs.getString(1));
            this.assertEquals("2010-03-13", rs.getDate(1, (Calendar)utcCalendar).toString());
            this.assertEquals("2010-03-14", rs.getDate(1).toString());
            this.assertEquals("2010-03-14", rs.getString("x"));
            this.assertEquals("2010-03-13", rs.getDate("x", (Calendar)utcCalendar).toString());
            this.assertEquals("2010-03-14", rs.getDate("x").toString());
            rs.next();
            this.assertEquals("2010-03-14", rs.getString(1));
            this.assertEquals("2010-03-13", rs.getDate(1, (Calendar)utcCalendar).toString());
            this.assertEquals("2010-03-14", rs.getDate(1).toString());
            this.assertEquals("2010-03-14", rs.getString("x"));
            this.assertEquals("2010-03-13", rs.getDate("x", (Calendar)utcCalendar).toString());
            this.assertEquals("2010-03-14", rs.getDate("x").toString());
        }
        finally {
            stat.execute("SET TIME ZONE LOCAL");
            TimeZone.setDefault(old);
        }
        stat.execute("drop table ts");
        stat.execute("drop table t");
        stat.execute("drop table d");
        conn.close();
    }

    private static void testCurrentTimeZone() {
        int year = 1890;
        while (year < 2050) {
            int month = 1;
            while (month <= 12) {
                int day = 1;
                while (day < 29) {
                    int hour = 0;
                    while (hour < 24) {
                        TestDateStorage.test(year, month, day, hour);
                        ++hour;
                    }
                    ++day;
                }
                ++month;
            }
            year += 3;
        }
    }

    private static void test(int year, int month, int day, int hour) {
        ValueTimestamp.parse(year + "-" + month + "-" + day + " " + hour + ":00:00", null);
    }

    private void testAllTimeZones() throws SQLException {
        Connection conn = this.getConnection(this.getTestName());
        TimeZone defaultTimeZone = TimeZone.getDefault();
        PreparedStatement prepTimeZone = conn.prepareStatement("SET TIME ZONE ?");
        PreparedStatement prep = conn.prepareStatement("CALL CAST(? AS DATE)");
        try {
            ArrayList<TimeZone> distinct = TestDate.getDistinctTimeZones();
            for (TimeZone tz : distinct) {
                if (tz.getID().startsWith("SystemV/") && tz.getDSTSavings() < 0) continue;
                prepTimeZone.setString(1, tz.getID());
                prepTimeZone.executeUpdate();
                TimeZone.setDefault(tz);
                int d = 101;
                while (d < 129) {
                    this.test(prep, d);
                    ++d;
                }
            }
        }
        finally {
            TimeZone.setDefault(defaultTimeZone);
        }
        conn.close();
        this.deleteDb(this.getTestName());
    }

    private void test(PreparedStatement prep, int d) throws SQLException {
        String x;
        String s = "2040-10-" + ("" + d).substring(1);
        Date date = Date.valueOf(s);
        long time = date.getTime();
        while (!(x = (date = new Date(time)).toString()).equals(s)) {
            time += 1000L;
        }
        if (!date.toString().equals(s)) {
            this.println(TimeZone.getDefault().getID() + " " + s + " <> " + date.toString());
            return;
        }
        prep.setString(1, s);
        ResultSet rs = prep.executeQuery();
        rs.next();
        String t = rs.getString(1);
        if (!s.equals(t)) {
            this.assertEquals(TimeZone.getDefault().getID(), s, t);
        }
    }
}

