/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.util.Task;

public class TestDeadlock
extends TestDb {
    Connection c1;
    Connection c2;
    Connection c3;
    private volatile SQLException lastException;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.deleteDb("deadlock");
        this.testTemporaryTablesAndMetaDataLocking();
        this.testDeadlockInFulltextSearch();
        this.testConcurrentLobReadAndTempResultTableDelete();
        this.testNoDeadlock();
        this.deleteDb("deadlock");
    }

    private void testDeadlockInFulltextSearch() throws SQLException {
        this.deleteDb("deadlock");
        String url = "deadlock";
        Connection conn = this.getConnection(url);
        Connection conn2 = this.getConnection(url);
        final Statement stat = conn.createStatement();
        Statement stat2 = conn2.createStatement();
        stat.execute("create alias if not exists ft_init for \"org.h2.fulltext.FullText.init\"");
        stat.execute("call ft_init()");
        stat.execute("create table test(id int primary key, name varchar)");
        stat.execute("call ft_create_index('PUBLIC', 'TEST', null)");
        Task t = new Task(){

            @Override
            public void call() throws Exception {
                while (!this.stop) {
                    stat.executeQuery("select * from test");
                }
            }
        };
        t.execute();
        long start = System.nanoTime();
        while (System.nanoTime() - start < TimeUnit.SECONDS.toNanos(1L)) {
            stat2.execute("insert into test values(1, 'Hello')");
            stat2.execute("delete from test");
        }
        t.get();
        conn2.close();
        conn.close();
        conn = this.getConnection(url);
        conn.createStatement().execute("drop all objects");
        conn.close();
    }

    private void testConcurrentLobReadAndTempResultTableDelete() throws Exception {
        this.deleteDb("deadlock");
        String url = "deadlock;MAX_MEMORY_ROWS=10";
        Connection conn = this.getConnection(url);
        Connection conn2 = this.getConnection(url);
        final Statement stat = conn.createStatement();
        Statement stat2 = conn2.createStatement();
        stat.execute("create table test(id int primary key, name varchar) as select x, 'Hello' from system_range(1,20)");
        stat2.execute("create table test_clob(id int primary key, data clob) as select 1, space(10000)");
        ResultSet rs2 = stat2.executeQuery("select * from test_clob");
        rs2.next();
        Task t = new Task(){

            @Override
            public void call() throws Exception {
                while (!this.stop) {
                    stat.execute("select * from (select distinct id from test)");
                }
            }
        };
        t.execute();
        long start = System.nanoTime();
        while (System.nanoTime() - start < TimeUnit.SECONDS.toNanos(1L)) {
            int x;
            Reader r = rs2.getCharacterStream(2);
            char[] buff = new char[1024];
            while ((x = r.read(buff)) >= 0) {
            }
        }
        t.get();
        stat.execute("drop all objects");
        conn.close();
        conn2.close();
    }

    private void initTest() throws SQLException {
        this.c1 = this.getConnection("deadlock");
        this.c2 = this.getConnection("deadlock");
        this.c3 = this.getConnection("deadlock");
        this.c1.createStatement().execute("SET LOCK_TIMEOUT 1000");
        this.c2.createStatement().execute("SET LOCK_TIMEOUT 1000");
        this.c3.createStatement().execute("SET LOCK_TIMEOUT 1000");
        this.c1.setAutoCommit(false);
        this.c2.setAutoCommit(false);
        this.c3.setAutoCommit(false);
        this.lastException = null;
    }

    private void end() throws SQLException {
        this.c1.close();
        this.c2.close();
        this.c3.close();
    }

    void catchDeadlock(SQLException e) {
        if (this.lastException != null) {
            this.lastException.setNextException(e);
        } else {
            this.lastException = e;
        }
    }

    private void testNoDeadlock() throws Exception {
        this.initTest();
        this.c1.createStatement().execute("CREATE TABLE TEST_A(ID INT PRIMARY KEY)");
        this.c1.createStatement().execute("CREATE TABLE TEST_B(ID INT PRIMARY KEY)");
        this.c1.createStatement().execute("CREATE TABLE TEST_C(ID INT PRIMARY KEY)");
        this.c1.commit();
        this.c1.createStatement().execute("INSERT INTO TEST_A VALUES(1)");
        this.c2.createStatement().execute("INSERT INTO TEST_B VALUES(1)");
        this.c3.createStatement().execute("INSERT INTO TEST_C VALUES(1)");
        DoIt t2 = new DoIt(this){

            @Override
            public void execute() throws SQLException {
                c1.createStatement().execute("DELETE FROM TEST_B");
                c1.commit();
            }
        };
        t2.start();
        DoIt t3 = new DoIt(this){

            @Override
            public void execute() throws SQLException {
                c2.createStatement().execute("DELETE FROM TEST_C");
                c2.commit();
            }
        };
        t3.start();
        Thread.sleep(500L);
        try {
            this.c3.createStatement().execute("DELETE FROM TEST_C");
            this.c3.commit();
        }
        catch (SQLException e) {
            this.catchDeadlock(e);
        }
        t2.join();
        t3.join();
        if (this.lastException != null) {
            throw this.lastException;
        }
        this.c1.commit();
        this.c2.commit();
        this.c3.commit();
        this.c1.createStatement().execute("DROP TABLE TEST_A, TEST_B, TEST_C");
        this.end();
    }

    private void testTemporaryTablesAndMetaDataLocking() throws Exception {
        this.deleteDb("deadlock");
        Connection conn = this.getConnection("deadlock");
        Statement stmt = conn.createStatement();
        conn.setAutoCommit(false);
        stmt.execute("CREATE SEQUENCE IF NOT EXISTS SEQ1 START WITH 1000000");
        stmt.execute("CREATE FORCE VIEW V1 AS WITH RECURSIVE TEMP(X) AS (SELECT x FROM DUAL) SELECT * FROM TEMP");
        stmt.executeQuery("SELECT NEXT VALUE FOR SEQ1");
        conn.close();
    }

    abstract class DoIt
    extends Thread {
        DoIt() {
        }

        abstract void execute() throws SQLException;

        @Override
        public void run() {
            try {
                this.execute();
            }
            catch (SQLException e) {
                TestDeadlock.this.catchDeadlock(e);
            }
        }
    }
}

