/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestEncryptedDb
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public boolean isEnabled() {
        return !this.config.memory && this.config.cipher == null;
    }

    @Override
    public void test() throws SQLException {
        Statement stat;
        Connection conn;
        this.deleteDb("encrypted");
        this.assertThrows(50100, () -> this.getConnection("encrypted;CIPHER=AES;PAGE_SIZE=2048", "sa", "1234 1234"));
        Throwable throwable = null;
        Object var2_4 = null;
        try {
            conn = this.getConnection("encrypted;CIPHER=AES", "sa", "123 123");
            try {
                stat = conn.createStatement();
                stat.execute("CREATE TABLE TEST(ID INT)");
                stat.execute("CHECKPOINT");
                stat.execute("SET WRITE_DELAY 0");
                stat.execute("INSERT INTO TEST VALUES(1)");
                stat.execute("SHUTDOWN IMMEDIATELY");
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.assertThrows(90049, () -> this.getConnection("encrypted;CIPHER=AES", "sa", "1234 1234"));
        throwable = null;
        var2_4 = null;
        try {
            conn = this.getConnection("encrypted;CIPHER=AES", "sa", "123 123");
            try {
                stat = conn.createStatement();
                ResultSet rs = stat.executeQuery("SELECT * FROM TEST");
                this.assertTrue(rs.next());
                this.assertEquals(1, rs.getInt(1));
                this.assertFalse(rs.next());
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        this.deleteDb("encrypted");
    }
}

