/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicInteger;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.util.Task;

public class TestExclusive
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testSetExclusiveTrueFalse();
        this.testSetExclusiveGetExclusive();
    }

    private void testSetExclusiveTrueFalse() throws Exception {
        this.deleteDb("exclusive");
        Connection conn = this.getConnection("exclusive");
        Statement stat = conn.createStatement();
        stat.execute("set exclusive true");
        this.assertThrows(90135, () -> this.getConnection("exclusive"));
        stat.execute("set exclusive false");
        Connection conn2 = this.getConnection("exclusive");
        final Statement stat2 = conn2.createStatement();
        stat.execute("set exclusive true");
        final AtomicInteger state = new AtomicInteger();
        Task task = new Task(){

            @Override
            public void call() throws SQLException {
                stat2.execute("select * from dual");
                if (state.get() != 1) {
                    new Error("unexpected state: " + state.get()).printStackTrace();
                }
            }
        };
        task.execute();
        state.set(1);
        stat.execute("set exclusive false");
        task.get();
        stat.execute("set exclusive true");
        conn.close();
        stat2.execute("select * from dual");
        conn2.close();
        this.deleteDb("exclusive");
    }

    private void testSetExclusiveGetExclusive() throws SQLException {
        this.deleteDb("exclusive");
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection connection = this.getConnection("exclusive");){
            this.assertFalse(TestExclusive.getExclusiveMode(connection));
            TestExclusive.setExclusiveMode(connection, 1);
            this.assertTrue(TestExclusive.getExclusiveMode(connection));
            TestExclusive.setExclusiveMode(connection, 0);
            this.assertFalse(TestExclusive.getExclusiveMode(connection));
            TestExclusive.setExclusiveMode(connection, 0);
            this.assertFalse(TestExclusive.getExclusiveMode(connection));
            TestExclusive.setExclusiveMode(connection, 1);
            this.assertTrue(TestExclusive.getExclusiveMode(connection));
            TestExclusive.setExclusiveMode(connection, 1);
            this.assertTrue(TestExclusive.getExclusiveMode(connection));
            TestExclusive.setExclusiveMode(connection, 2);
            this.assertTrue(TestExclusive.getExclusiveMode(connection));
            TestExclusive.setExclusiveMode(connection, 0);
            this.assertFalse(TestExclusive.getExclusiveMode(connection));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void setExclusiveMode(Connection connection, int exclusiveMode) throws SQLException {
        String sql = "SET EXCLUSIVE " + exclusiveMode;
        Throwable throwable = null;
        Object var4_5 = null;
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.execute();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static boolean getExclusiveMode(Connection connection) throws SQLException {
        boolean exclusiveMode = false;
        String sql = "SELECT SETTING_VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE SETTING_NAME = 'EXCLUSIVE'";
        Throwable throwable = null;
        Object var4_5 = null;
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            ResultSet result = statement.executeQuery();
            if (result.next()) {
                exclusiveMode = result.getBoolean(1);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return exclusiveMode;
    }
}

