/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestIgnoreCatalogs
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.canCommentOn();
        this.canUseDefaultSchema();
        this.canYetIdentifyWrongCatalogName();
        this.canUseSettingInUrl();
        this.canUseSetterSyntax();
        this.canCatalogNameEqualSchemaName();
        this.canUseCatalogAtIndexName();
        this.canCommentOn();
        this.canAllCombined();
        this.doesNotAcceptEmptySchemaWhenNotMSSQL();
    }

    private void doesNotAcceptEmptySchemaWhenNotMSSQL() throws SQLException {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Connection conn = this.getConnection("ignoreCatalogs;IGNORE_CATALOGS=TRUE");){
                Throwable throwable2 = null;
                Object var5_8 = null;
                try (Statement stat = conn.createStatement();){
                    TestIgnoreCatalogs.prepareDbAndSetDefaultSchema(stat);
                    stat.execute("set schema dbo");
                    stat.execute("create table catalog1.dbo.test(id int primary key, name varchar(255))");
                    this.assertThrows(42001, stat, "comment on table catalog1..test is 'table comment3'");
                    this.assertThrows(42001, stat, "create table catalog1..test2(id int primary key, name varchar(255))");
                    stat.execute("comment on table catalog1.dbo.test is 'table comment1'");
                    stat.execute("insert into test values(1, 'Hello')");
                    stat.execute("insert into cat.dbo.test values(2, 'Hello2')");
                    this.assertThrows(42001, stat, "comment on column catalog1...test.id is 'id comment1'");
                    this.assertThrows(42001, stat, "comment on column catalog1..test..id is 'id comment1'");
                    this.assertThrows(42001, stat, "comment on column ..test..id is 'id comment1'");
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        finally {
            this.deleteDb("ignoreCatalogs");
        }
    }

    private void canCommentOn() throws Exception {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Connection conn = this.getConnection("ignoreCatalogs;MODE=MSSQLSERVER;IGNORE_CATALOGS=TRUE;");){
                Throwable throwable2 = null;
                Object var5_8 = null;
                try (Statement stat = conn.createStatement();){
                    TestIgnoreCatalogs.prepareDbAndSetDefaultSchema(stat);
                    stat.execute("create table catalog1.dbo.test(id int primary key, name varchar(255))");
                    stat.execute("comment on table catalog1.dbo.test is 'table comment1'");
                    stat.execute("comment on table dbo.test is 'table comment2'");
                    stat.execute("comment on table catalog1..test is 'table comment3'");
                    stat.execute("comment on table test is 'table comment4'");
                    stat.execute("comment on column catalog1..test.id is 'id comment1'");
                    stat.execute("comment on column catalog1.dbo.test.id is 'id comment1'");
                    stat.execute("comment on column dbo.test.id is 'id comment1'");
                    stat.execute("comment on column test.id is 'id comment1'");
                    this.assertThrows(42001, stat, "comment on column catalog1...id is 'id comment1'");
                    this.assertThrows(42001, stat, "comment on column catalog1...test.id is 'id comment1'");
                    this.assertThrows(42001, stat, "comment on column catalog1..test..id is 'id comment1'");
                    this.assertThrows(42001, stat, "comment on column ..test..id is 'id comment1'");
                    this.assertThrows(42001, stat, "comment on column test..id is 'id comment1'");
                    this.assertThrows(42001, stat, "comment on column .PUBLIC.TEST.ID 'id comment1'");
                    this.assertThrows(42001, stat, "comment on column .TEST.ID 'id comment1'");
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        finally {
            this.deleteDb("ignoreCatalogs");
        }
    }

    private void canUseDefaultSchema() throws Exception {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Connection conn = this.getConnection("ignoreCatalogs;MODE=MSSQLSERVER;IGNORE_CATALOGS=TRUE;");){
                Throwable throwable2 = null;
                Object var5_8 = null;
                try (Statement stat = conn.createStatement();){
                    TestIgnoreCatalogs.prepareDbAndSetDefaultSchema(stat);
                    stat.execute("create table catalog1..test(id int primary key, name varchar(255))");
                    stat.execute("create table test2(id int primary key, name varchar(255))");
                    this.assertThrows(42101, stat, "create table catalog2.dbo.test(id int primary key, name varchar(255))");
                    stat.execute("insert into test values(1, 'Hello')");
                    stat.execute("insert into test2 values(1, 'Hello')");
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        finally {
            this.deleteDb("ignoreCatalogs");
        }
    }

    private void canUseSettingInUrl() throws Exception {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Connection conn = this.getConnection("ignoreCatalogs;MODE=MSSQLSERVER;IGNORE_CATALOGS=TRUE;");){
                Throwable throwable2 = null;
                Object var5_8 = null;
                try (Statement stat = conn.createStatement();){
                    TestIgnoreCatalogs.prepareDb(stat);
                    stat.execute("create table catalog1.dbo.test(id int primary key, name varchar(255))");
                    this.assertThrows(42101, stat, "create table catalog2.dbo.test(id int primary key, name varchar(255))");
                    stat.execute("insert into dbo.test values(1, 'Hello')");
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        finally {
            this.deleteDb("ignoreCatalogs");
        }
    }

    private void canUseSetterSyntax() throws Exception {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Connection conn = this.getConnection("ignoreCatalogs;MODE=MSSQLSERVER;");){
                Throwable throwable2 = null;
                Object var5_8 = null;
                try (Statement stat = conn.createStatement();){
                    TestIgnoreCatalogs.prepareDb(stat);
                    stat.execute("set IGNORE_CATALOGS=TRUE");
                    stat.execute("create table catalog1.dbo.test(id int primary key, name varchar(255))");
                    this.assertThrows(42101, stat, "create table catalog2.dbo.test(id int primary key, name varchar(255))");
                    stat.execute("insert into dbo.test values(1, 'Hello')");
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        finally {
            this.deleteDb("ignoreCatalogs");
        }
    }

    private void canCatalogNameEqualSchemaName() throws Exception {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Connection conn = this.getConnection("ignoreCatalogs;MODE=MSSQLSERVER;");){
                Throwable throwable2 = null;
                Object var5_8 = null;
                try (Statement stat = conn.createStatement();){
                    TestIgnoreCatalogs.prepareDb(stat);
                    stat.execute("set IGNORE_CATALOGS=TRUE");
                    stat.execute("create table dbo.dbo.test(id int primary key, name varchar(255))");
                    this.assertThrows(42101, stat, "create table catalog2.dbo.test(id int primary key, name varchar(255))");
                    stat.execute("insert into dbo.test values(1, 'Hello')");
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        finally {
            this.deleteDb("ignoreCatalogs");
        }
    }

    private void canYetIdentifyWrongCatalogName() throws Exception {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Connection conn = this.getConnection("ignoreCatalogs;MODE=MSSQLSERVER;");){
                Throwable throwable2 = null;
                Object var5_8 = null;
                try (Statement stat = conn.createStatement();){
                    TestIgnoreCatalogs.prepareDb(stat);
                    stat.execute("create table ignoreCatalogs.dbo.test(id int primary key, name varchar(255))");
                    this.assertThrows(90079, stat, "create table test_x.dbo.test(id int primary key, name varchar(255))");
                    this.assertThrows(90013, stat, "comment on column db..test.id is 'id'");
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        finally {
            this.deleteDb("ignoreCatalogs");
        }
    }

    private void canUseCatalogAtIndexName() throws Exception {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Connection conn = this.getConnection("ignoreCatalogs;MODE=MSSQLSERVER;");){
                Throwable throwable2 = null;
                Object var5_8 = null;
                try (Statement stat = conn.createStatement();){
                    TestIgnoreCatalogs.prepareDb(stat);
                    stat.execute("set IGNORE_CATALOGS=TRUE");
                    stat.execute("create table dbo.dbo.test(id int primary key, name varchar(255))");
                    stat.execute("create index i on dbo.dbo.test(id,name)");
                    stat.execute("create index dbo.i2 on dbo.dbo.test(id,name)");
                    stat.execute("create index catalog.dbo.i3 on dbo.dbo.test(id,name)");
                    this.assertThrows(90079, stat, "create index dboNotExistent.i4 on dbo.dbo.test(id,name)");
                    stat.execute("insert into dbo.test values(1, 'Hello')");
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        finally {
            this.deleteDb("ignoreCatalogs");
        }
    }

    private void canAllCombined() throws SQLException {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Connection conn = this.getConnection("ignoreCatalogs;MODE=MSSQLSERVER;IGNORE_CATALOGS=TRUE;");){
                Throwable throwable2 = null;
                Object var5_8 = null;
                try (Statement stat = conn.createStatement();){
                    TestIgnoreCatalogs.prepareDbAndSetDefaultSchema(stat);
                    stat.execute("create table dbo.test(id int primary key, name varchar(255))");
                    stat.execute("create table catalog1.dbo.test2(id int primary key, name varchar(255))");
                    stat.execute("insert into dbo.test values(1, 'Hello')");
                    stat.execute("insert into dbo.test2 values(1, 'Hello2')");
                    stat.execute("set ignore_catalogs=false");
                    this.assertThrows(90079, stat, "insert into catalog1.dbo.test2 values(2, 'Hello2')");
                    stat.execute("set ignore_catalogs=true");
                    this.assertResult("1", stat, "select * from test");
                    this.assertResult("1", stat, "select * from test2");
                    stat.execute("alter table xxx.dbo.test add column (a varchar(200))");
                    stat.execute("alter table xxx..test add column (b varchar(200))");
                    stat.execute("alter table test add column (c varchar(200))");
                    stat.execute("drop table xxx.dbo.test");
                    stat.execute("drop table catalog1.dbo.test2");
                    stat.execute("drop table if exists xxx.dbo.test");
                    stat.execute("drop table if exists catalog1.dbo.test2");
                    stat.execute("set ignore_catalogs=false");
                    this.assertThrows(90079, stat, "alter table xxx.dbo.test add column (a varchar(200))");
                    this.assertThrows(90079, stat, "alter table xxx..test add column (b varchar(200))");
                    this.assertThrows(42102, stat, "alter table test add column (c varchar(200))");
                    this.assertThrows(90079, stat, "drop table if exists xxx.dbo.test");
                    this.assertThrows(90079, stat, "drop table if exists xxx2..test");
                    this.assertThrows(42102, stat, "drop table test");
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        finally {
            this.deleteDb("ignoreCatalogs");
        }
    }

    private static void prepareDb(Statement stat) throws SQLException {
        stat.execute("drop all objects");
        stat.execute("create schema dbo");
    }

    private static void prepareDbAndSetDefaultSchema(Statement stat) throws SQLException {
        TestIgnoreCatalogs.prepareDb(stat);
        stat.execute("set schema dbo");
    }
}

